/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.logger;

import org.json.simple.JSONObject;

public class LogFormat {
    protected String logType = "connector";
    protected String executionId = "";
    protected String sourceId = "";

    public LogFormat() {
    }

    public LogFormat(String logType, String executionId, String sourceId) {
        this.logType = logType == null ? "connector" : logType;
        this.executionId = executionId;
        this.sourceId = sourceId;
    }

    public void setLogFormat(String logType, String executionId, String sourceId) {
        this.logType = logType == null ? "connector" : logType;
        this.executionId = executionId;
        this.sourceId = sourceId;
    }

    public void setLogFormat(String logType, JSONObject data) {
        String sourceId = this.getSourceId(data);
        String executionId = "";
        switch (logType) {
            case "connector": {
                executionId = "";
                break;
            }
            case "scan": {
                executionId = data.containsKey((Object)"scan_id") ? String.valueOf(data.get((Object)"scan_id")) : "";
                break;
            }
            case "chat": {
                executionId = data.containsKey((Object)"analysis_id") ? String.valueOf(data.get((Object)"analysis_id")) : "";
                break;
            }
            case "rule": {
                executionId = data.containsKey((Object)"job_id") ? String.valueOf(data.get((Object)"job_id")) : "";
                break;
            }
            default: {
                executionId = "";
            }
        }
        this.setLogFormat(logType, executionId, sourceId);
    }

    private String getSourceId(JSONObject data) {
        String sourceId = "";
        if (data.containsKey((Object)"source_id")) {
            sourceId = String.valueOf(data.get((Object)"source_id"));
        } else if (data.containsKey((Object)"sourceId")) {
            sourceId = String.valueOf(data.get((Object)"sourceId"));
        }
        return sourceId;
    }

    public String getFormattedLog() {
        JSONObject logJSON = this.getLogJSONObject(this.logType, this.sourceId, this.executionId);
        return logJSON.toJSONString();
    }

    protected String getFormatString() {
        return "<logs_metaInfo>%s:source#%s:execution_id#%s</logs_metaInfo>";
    }

    protected JSONObject getFormatJSONObject() {
        JSONObject formatJSON = new JSONObject();
        formatJSON.put((Object)"context", (Object)"");
        formatJSON.put((Object)"source_id", (Object)"");
        formatJSON.put((Object)"execution_id", (Object)"");
        return formatJSON;
    }

    protected JSONObject getLogJSONObject(String logType, String sourceId, String executionId) {
        JSONObject logJSON = new JSONObject();
        logJSON.put((Object)"context", (Object)logType);
        logJSON.put((Object)"source_id", (Object)sourceId);
        logJSON.put((Object)"execution_id", (Object)executionId);
        return logJSON;
    }
}

