/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.filter;

import com.dvsum.util.ByteArrayOutputStream2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class GzipFilter
extends HandlerInterceptorAdapter
implements Filter {
    protected int bufferSize = 8192;
    protected int minGzipSize = 0;

    public void init(FilterConfig filterConfig) throws ServletException {
        String temp = filterConfig.getInitParameter("bufferSize");
        if (temp != null) {
            this.bufferSize = Integer.parseInt(temp);
        }
        if ((temp = filterConfig.getInitParameter("minGzipSize")) != null) {
            this.minGzipSize = Integer.parseInt(temp);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block10: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String requestURI = request.getRequestURI();
            if (requestURI.endsWith(".png") || requestURI.endsWith(".gif") || requestURI.endsWith(".swf") || requestURI.endsWith(".jpg") || requestURI.endsWith(".jpeg") || requestURI.contains("fileDownload")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String ae = request.getHeader("accept-encoding");
            Boolean gzip = (Boolean)request.getAttribute("GzipFilter");
            if (!(ae == null || ae.indexOf("gzip") < 0 || response.containsHeader("Content-Encoding") || gzip != null && !gzip.booleanValue() || "HEAD".equalsIgnoreCase(request.getMethod()))) {
                GZIPResponseWrapper wrappedResponse = this.newGZIPResponseWrapper(request, response);
                boolean exceptional = true;
                try {
                    try {
                        chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
                        exceptional = false;
                        break block10;
                    }
                    catch (RuntimeException e) {
                        request.setAttribute("GzipFilter", (Object)Boolean.FALSE);
                        if (!response.isCommitted()) {
                            response.reset();
                        }
                        throw e;
                    }
                }
                finally {
                    if (exceptional && !response.isCommitted()) {
                        wrappedResponse.resetBuffer();
                        wrappedResponse.noGzip();
                    } else {
                        wrappedResponse.finish();
                    }
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected GZIPResponseWrapper newGZIPResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new GZIPResponseWrapper(request, response);
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    public class GZIPResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletRequest request;
        boolean noGzip;
        PrintWriter writer;
        GzipStream gzStream;
        long contentLength;

        public GZIPResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.contentLength = -1L;
            this.request = request;
        }

        public void setContentType(String ct) {
            int colon;
            super.setContentType(ct);
            if (ct != null && (colon = ct.indexOf(";")) > 0) {
                ct = ct.substring(0, colon);
            }
            if (!(this.gzStream != null && this.gzStream.out != null || !"application/gzip".equalsIgnoreCase(ct) && ct != null && this.isCompressibleContentType(ct))) {
                this.noGzip();
            }
        }

        private boolean isCompressibleContentType(String contentType) {
            if (contentType == null) {
                return false;
            }
            String lowerCaseContentType = contentType.toLowerCase();
            if (lowerCaseContentType.indexOf("image") > -1) {
                return false;
            }
            return lowerCaseContentType.indexOf("text") > -1 || lowerCaseContentType.indexOf("javascript") > -1 || lowerCaseContentType.indexOf("ecmascript") > -1 || lowerCaseContentType.indexOf("xml") > -1 || lowerCaseContentType.indexOf("json") > -1;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            if (sc < 200 || sc >= 300) {
                this.noGzip();
            }
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            if (sc < 200 || sc >= 300) {
                this.noGzip();
            }
        }

        public void setContentLength(int length) {
            this.contentLength = length;
            if (this.gzStream != null) {
                this.gzStream.setContentLength(length);
            }
        }

        public void addHeader(String name, String value) {
            if ("content-length".equalsIgnoreCase(name)) {
                this.contentLength = Long.parseLong(value);
                if (this.gzStream != null) {
                    this.gzStream.setContentLength(this.contentLength);
                }
            } else if ("content-type".equalsIgnoreCase(name)) {
                this.setContentType(value);
            } else if ("content-encoding".equalsIgnoreCase(name)) {
                super.addHeader(name, value);
                if (!this.isCommitted()) {
                    this.noGzip();
                }
            } else {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if ("content-length".equalsIgnoreCase(name)) {
                this.contentLength = Long.parseLong(value);
                if (this.gzStream != null) {
                    this.gzStream.setContentLength(this.contentLength);
                }
            } else if ("content-type".equalsIgnoreCase(name)) {
                this.setContentType(value);
            } else if ("content-encoding".equalsIgnoreCase(name)) {
                super.setHeader(name, value);
                if (!this.isCommitted()) {
                    this.noGzip();
                }
            } else {
                super.setHeader(name, value);
            }
        }

        public void setIntHeader(String name, int value) {
            if ("content-length".equalsIgnoreCase(name)) {
                this.contentLength = value;
                if (this.gzStream != null) {
                    this.gzStream.setContentLength(this.contentLength);
                }
            } else {
                super.setIntHeader(name, value);
            }
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.gzStream != null) {
                this.gzStream.finish();
            } else {
                this.getResponse().flushBuffer();
            }
        }

        public void reset() {
            super.reset();
            if (this.gzStream != null) {
                this.gzStream.resetBuffer();
            }
            this.writer = null;
            this.gzStream = null;
            this.noGzip = false;
            this.contentLength = -1L;
        }

        public void resetBuffer() {
            super.resetBuffer();
            if (this.gzStream != null) {
                this.gzStream.resetBuffer();
            }
            this.writer = null;
            this.gzStream = null;
        }

        public void sendError(int sc, String msg) throws IOException {
            this.resetBuffer();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.resetBuffer();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.resetBuffer();
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.gzStream == null) {
                if (this.getResponse().isCommitted() || this.noGzip) {
                    return this.getResponse().getOutputStream();
                }
                this.gzStream = this.newGzipStream(this.request, (HttpServletResponse)this.getResponse(), this.contentLength, GzipFilter.this.bufferSize, GzipFilter.this.minGzipSize);
            } else if (this.writer != null) {
                throw new IllegalStateException("getWriter() called");
            }
            return this.gzStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                if (this.gzStream != null) {
                    throw new IllegalStateException("getOutputStream() called");
                }
                if (this.getResponse().isCommitted() || this.noGzip) {
                    return this.getResponse().getWriter();
                }
                this.gzStream = this.newGzipStream(this.request, (HttpServletResponse)this.getResponse(), this.contentLength, GzipFilter.this.bufferSize, GzipFilter.this.minGzipSize);
                this.writer = GzipFilter.this.newWriter((OutputStream)((Object)this.gzStream), this.getCharacterEncoding());
            }
            return this.writer;
        }

        void noGzip() {
            this.noGzip = true;
            if (this.gzStream != null) {
                try {
                    this.gzStream.doNotGzip();
                }
                catch (IOException e) {
                    throw new IllegalStateException();
                }
            }
        }

        void finish() throws IOException {
            if (this.writer != null && !this.gzStream.closed) {
                this.writer.flush();
            }
            if (this.gzStream != null) {
                this.gzStream.finish();
            }
        }

        protected GzipStream newGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            return new GzipStream(request, response, contentLength, bufferSize, minGzipSize);
        }
    }

    public static class GzipStream
    extends ServletOutputStream {
        protected HttpServletRequest request;
        protected HttpServletResponse response;
        protected OutputStream out;
        protected ByteArrayOutputStream2 bOut;
        protected GZIPOutputStream gzOut;
        protected boolean closed;
        protected int streamBufferSize;
        protected int streamMinGzipSize;
        protected long streamContentLength;

        public GzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            this.request = request;
            this.response = response;
            this.streamContentLength = contentLength;
            this.streamBufferSize = bufferSize;
            this.streamMinGzipSize = minGzipSize;
            if (minGzipSize == 0) {
                this.doGzip();
            }
        }

        public void resetBuffer() {
            this.closed = false;
            this.out = null;
            this.bOut = null;
            if (this.gzOut != null && !this.response.isCommitted()) {
                this.response.setHeader("Content-Encoding", null);
            }
            this.gzOut = null;
        }

        public void setContentLength(long length) {
            this.streamContentLength = length;
        }

        public void flush() throws IOException {
            if (this.out == null || this.bOut != null) {
                if (this.streamContentLength > 0L && this.streamContentLength < (long)this.streamMinGzipSize) {
                    this.doNotGzip();
                } else {
                    this.doGzip();
                }
            }
            this.out.flush();
        }

        public void close() throws IOException {
            if (this.request.getAttribute("javax.servlet.include.request_uri") != null) {
                this.flush();
            } else {
                if (this.bOut != null) {
                    if (this.streamContentLength < 0L) {
                        this.streamContentLength = this.bOut.getCount();
                    }
                    if (this.streamContentLength < (long)this.streamMinGzipSize) {
                        this.doNotGzip();
                    } else {
                        this.doGzip();
                    }
                } else if (this.out == null) {
                    this.doNotGzip();
                }
                if (this.gzOut != null) {
                    this.gzOut.close();
                } else {
                    this.out.close();
                }
                this.closed = true;
            }
        }

        public void finish() throws IOException {
            if (!this.closed) {
                if (this.out == null || this.bOut != null) {
                    if (this.streamContentLength > 0L && this.streamContentLength < (long)this.streamMinGzipSize) {
                        this.doNotGzip();
                    } else {
                        this.doGzip();
                    }
                }
                if (this.gzOut != null && !this.closed) {
                    this.closed = true;
                    this.gzOut.close();
                }
            }
        }

        public void write(int b) throws IOException {
            this.checkOut(1);
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.checkOut(b.length);
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.checkOut(len);
            this.out.write(b, off, len);
        }

        protected boolean setContentEncodingGzip() {
            this.response.setHeader("Content-Encoding", "gzip");
            return this.response.containsHeader("Content-Encoding");
        }

        public void doGzip() throws IOException {
            if (this.gzOut == null) {
                if (this.response.isCommitted()) {
                    throw new IllegalStateException();
                }
                if (this.setContentEncodingGzip()) {
                    this.gzOut = new GZIPOutputStream((OutputStream)this.response.getOutputStream(), this.streamBufferSize);
                    this.out = this.gzOut;
                    if (this.bOut != null) {
                        this.out.write(this.bOut.getBuf(), 0, this.bOut.getCount());
                        this.bOut = null;
                    }
                } else {
                    this.doNotGzip();
                }
            }
        }

        public void doNotGzip() throws IOException {
            if (this.gzOut != null) {
                throw new IllegalStateException();
            }
            if (this.out == null || this.bOut != null) {
                this.out = this.response.getOutputStream();
                if (this.streamContentLength >= 0L) {
                    if (this.streamContentLength < Integer.MAX_VALUE) {
                        this.response.setContentLength((int)this.streamContentLength);
                    } else {
                        this.response.setHeader("Content-Length", Long.toString(this.streamContentLength));
                    }
                }
                if (this.bOut != null) {
                    this.out.write(this.bOut.getBuf(), 0, this.bOut.getCount());
                }
                this.bOut = null;
            }
        }

        private void checkOut(int length) throws IOException {
            if (this.closed) {
                throw new IOException("CLOSED");
            }
            if (this.out == null) {
                if (this.response.isCommitted() || this.streamContentLength >= 0L && this.streamContentLength < (long)this.streamMinGzipSize) {
                    this.doNotGzip();
                } else if (length > this.streamMinGzipSize) {
                    this.doGzip();
                } else {
                    this.bOut = new ByteArrayOutputStream2(this.streamBufferSize);
                    this.out = this.bOut;
                }
            } else if (this.bOut != null) {
                if (this.response.isCommitted() || this.streamContentLength >= 0L && this.streamContentLength < (long)this.streamMinGzipSize) {
                    this.doNotGzip();
                } else if (length >= this.bOut.getBuf().length - this.bOut.getCount()) {
                    this.doGzip();
                }
            }
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
        }
    }
}

