/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.springframework.stereotype.Component;

@Component
public class ExcelDataSource
extends DataSource {
    private static final CustomLogger logger = CustomLogger.getLogger(ExcelDataSource.class);
    private static final String EXCEL_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String filePath;
    private String dynamicFile;

    @Override
    public void initializeConnectionParameters(JSONObject dataSourceInfoAndQuery) {
        super.initializeConnectionParameters(dataSourceInfoAndQuery);
        try {
            JSONObject connectionJson = JsonUtil.parseToJsonObject(String.valueOf(dataSourceInfoAndQuery.get((Object)"connectionJson")));
            this.dynamicFile = String.valueOf(connectionJson.get((Object)"dynamicFilename"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public ExcelDataSource(JSONObject DBInfo, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
    }

    public ExcelDataSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return EXCEL_DRIVER;
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("jdbc:odbc:Driver={Microsoft Excel Driver (*.xls, *.xlsx, *.xlsm, *.xlsb)};DBQ=");
        String filePath = "";
        if (Util.isNullOrEmpty(this.dynamicFile)) {
            filePath = this.fileSystemPath;
        } else {
            filePath = this.dynamicFile.replace("\\", "/");
            logger.debug("Executing Test against dynamic File " + this.dynamicFile);
        }
        strBuilder.append(String.valueOf(filePath) + ";READONLY=true");
        return strBuilder.toString();
    }
}

