/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.LogFormat;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class DB2DataSource
extends DataSource {
    public static final String TEST_CONNECTION_QUERY = "SELECT 1 AS ping FROM sysibm.sysdummy1";

    public DB2DataSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.initializeConnectionParameters(DBInfo);
        this.isCataloging = isCataloging;
    }

    public DB2DataSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("jdbc:db2://");
        strBuilder.append(String.valueOf(this.host) + ":");
        strBuilder.append(String.valueOf(this.port) + "/");
        strBuilder.append(this.serviceId);
        strBuilder = new StringBuilder(String.valueOf(this.addOptionalProps(this.optionalParams, strBuilder.toString())));
        return strBuilder.toString();
    }
}

