/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class CsvOrTextFileDataSource
extends DataSource {
    private static final String CSV_DRIVER = "org.relique.jdbc.csv.CsvDriver";
    String tableName;
    String delimeterType;
    String columnTypes;
    String dateFormate;

    @Override
    public void initializeConnectionParameters(JSONObject dataSourceInfoAndQueryObject) {
        super.initializeConnectionParameters(dataSourceInfoAndQueryObject);
        try {
            JSONObject connectionJson = dataSourceInfoAndQueryObject;
            this.tableName = dataSourceInfoAndQueryObject.get((Object)"tableName").toString();
            this.delimeterType = connectionJson.get((Object)"delimeterType.id") != null ? connectionJson.get((Object)"delimeterType.id").toString() : ",";
            this.columnTypes = dataSourceInfoAndQueryObject.get((Object)"columnTypes") != null ? dataSourceInfoAndQueryObject.get((Object)"columnTypes").toString() : null;
            this.dateFormate = dataSourceInfoAndQueryObject.get((Object)"dateFormate") != null ? dataSourceInfoAndQueryObject.get((Object)"dateFormate").toString() : "M/D/YYYY";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CsvOrTextFileDataSource(JSONObject DBInfo, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
    }

    public CsvOrTextFileDataSource() {
        super(new LogFormat());
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("jdbc:relique:csv:");
        strBuilder.append(this.getCSVFolderPath());
        return strBuilder.toString();
    }

    @Override
    public String getDriver() {
        return CSV_DRIVER;
    }

    @Override
    public void connect() throws Exception {
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        Properties props = new Properties();
        props.put("columnTypes", this.columnTypes);
        props.put("separator", this.delimeterType);
        props.put("dateFormat", this.dateFormate);
        props.put("ignoreNonParseableLines", "True");
        props.put("trimValues", "True");
        this.connection = DriverManager.getConnection(this.getURL(), props);
    }

    public String getCSVFilePath() throws JSONException {
        StringBuilder csvFilePath = new StringBuilder();
        String csvFolderPath = this.getCSVFolderPath();
        if (!csvFolderPath.substring(csvFolderPath.length() - 1).equals("\\")) {
            csvFolderPath = String.valueOf(csvFolderPath) + "\\";
        }
        csvFilePath.append(csvFolderPath);
        csvFilePath.append(this.tableName);
        csvFilePath.append(".csv");
        return csvFilePath.toString();
    }

    public String getCSVFolderPath() {
        String filePath = this.fileSystemPath;
        if (filePath.contains(".csv")) {
            filePath = filePath.substring(0, filePath.lastIndexOf(47));
        }
        return filePath;
    }
}

