/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.InMemoryProps;
import com.dvsum.util.FileUtil;
import com.dvsum.util.Util;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class CDataDataSource
extends DataSource {
    private static final String PARENT_DIR = System.getProperty("user.dir");
    private static final String CDATA_DIR = String.valueOf(PARENT_DIR) + File.separator + "cdata" + File.separator;
    protected String authFilePath;
    protected String credsFilePath;
    protected Properties props;

    public CDataDataSource(LogFormat logFormat) {
        super(logFormat);
        this.authFilePath = String.valueOf(CDATA_DIR) + "auth-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        this.credsFilePath = String.valueOf(CDATA_DIR) + "creds-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        this.props = new Properties();
    }

    public CDataDataSource() {
        super(new LogFormat());
        this.authFilePath = String.valueOf(CDATA_DIR) + "auth-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        this.credsFilePath = String.valueOf(CDATA_DIR) + "creds-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        this.props = new Properties();
    }

    @Override
    public void connect() throws Exception {
        this.authFilePath = String.valueOf(CDATA_DIR) + "auth-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        this.credsFilePath = String.valueOf(CDATA_DIR) + "creds-" + (Util.isNotNullOrEmpty(this.sourceId) ? this.sourceId : "temp-" + (Math.floor(Math.random() * 9.0E9) + 1.0E9)) + ".txt";
        File cdataDir = new File(CDATA_DIR);
        if (!cdataDir.exists()) {
            cdataDir.mkdirs();
        }
        if (this.isTestConnection) {
            FileUtil.recreateFile(this.authFilePath);
            FileUtil.recreateFile(this.credsFilePath);
        } else {
            File authFile;
            File cdataCredFile = new File(this.credsFilePath);
            if (!cdataCredFile.exists()) {
                cdataCredFile.createNewFile();
            }
            if (!(authFile = new File(this.authFilePath)).exists()) {
                authFile.createNewFile();
            }
        }
        this.props.setProperty("OEMKey", InMemoryProps.CDATA_OEM_KEY);
        this.props.setProperty("Logfile", String.valueOf(PARENT_DIR) + "/logs/cdata-logs.txt");
        this.props.setProperty("Location", this.authFilePath);
        this.props.setProperty("Verbosity", "1");
        this.props.setProperty("Other", "ConnectOnOpen=True;");
    }

    @Override
    public ResultSet getTableCatalog() throws SQLException {
        return this.connection.getMetaData().getTables(null, null, "%", null);
    }

    @Override
    public ResultSet getColumnCatalog() throws SQLException {
        return this.connection.getMetaData().getColumns(null, null, "%", null);
    }

    @Override
    public ResultSet getPrimaryKeyCatalog() throws SQLException {
        return this.connection.getMetaData().getPrimaryKeys(null, null, "%");
    }

    @Override
    public ResultSet getForeignKeyCatalog() throws SQLException {
        return this.connection.getMetaData().getImportedKeys(null, null, "%");
    }

    @Override
    public void cleanCDataCache() throws SQLException {
        Statement st = this.connection.createStatement();
        st.executeUpdate("RESET SCHEMA CACHE");
    }

    @Override
    public ResultSet executeCatalog(String catalogType) throws SQLException {
        if ("COLS_META".equalsIgnoreCase(catalogType)) {
            return this.getColumnCatalog();
        }
        if ("TBLS_META".equalsIgnoreCase(catalogType)) {
            return this.getTableCatalog();
        }
        if ("CONS_META".equalsIgnoreCase(catalogType)) {
            return this.getPrimaryKeyCatalog();
        }
        if ("CONS_META_FOREIGN".equalsIgnoreCase(catalogType)) {
            return this.getForeignKeyCatalog();
        }
        return null;
    }

    @Override
    public String getDriver() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }
}

