/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.Util;
import org.json.simple.JSONObject;

public class AzureSqlDataSource
extends DataSource {
    private static final CustomLogger logger = CustomLogger.getLogger(AzureSqlDataSource.class);
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    Boolean isDynamicPortEnbaled;
    LogFormat logFormat;

    @Override
    public void initializeConnectionParameters(JSONObject dataSourceInfoAndQuery) {
        super.initializeConnectionParameters(dataSourceInfoAndQuery);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        try {
            JSONObject connectionJson = dataSourceInfoAndQuery;
            this.isDynamicPortEnbaled = connectionJson.get((Object)"isDynamicPortEnabled") != null && "1".equalsIgnoreCase(String.valueOf(connectionJson.get((Object)"isDynamicPortEnabled")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AzureSqlDataSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.isCataloging = isCataloging;
    }

    public AzureSqlDataSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        if (Util.isNullOrEmpty(this.connectionString)) {
            if (this.isDynamicPortEnbaled.booleanValue()) {
                strBuilder.append("jdbc:sqlserver://");
                strBuilder.append(this.host);
                strBuilder.append(";instanceName=" + this.instance_name);
                if (Util.isNotNullOrEmpty(this.database)) {
                    strBuilder.append(";databaseName=" + this.database);
                }
                strBuilder.append(";sslProtocol=TLSv1.2");
            } else {
                strBuilder.append("jdbc:sqlserver://");
                strBuilder.append(String.valueOf(this.host) + ":");
                strBuilder.append(this.port);
                if (Util.isNotNullOrEmpty(this.database)) {
                    strBuilder.append(";databaseName=" + this.database);
                }
                strBuilder.append(";trustServerCertificate=true");
                strBuilder.append(";sslProtocol=TLSv1.2");
            }
            strBuilder = new StringBuilder(String.valueOf(this.addOptionalProps(this.optionalParams, strBuilder.toString())));
        } else {
            strBuilder.append(this.connectionString);
        }
        return strBuilder.toString();
    }
}

