/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.logger.CustomLogger;
import com.dvsum.model.Configuration;
import com.dvsum.services.SawsUpgradeService;
import com.dvsum.services.UserService;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.StatusUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SAWSManagementController
extends BaseController {
    private static final long serialVersionUID = 1L;
    private static final CustomLogger logger = CustomLogger.getLogger(SAWSManagementController.class);
    @Value(value="${example.message}")
    private String message;
    @Value(value="${saws.version}")
    private String sawsVersion;
    @Autowired
    private UserService userService;
    @Autowired
    private SawsUpgradeService sawsUpgradeService;

    @RequestMapping(value={"/status"})
    public ModelAndView status(Model model) {
        model.addAttribute("startTime", (Object)EmbeddedJetty.SERVER_START_TIME);
        model.addAttribute("version", (Object)this.sawsVersion);
        model = this.addRequiredAttributes(model);
        return new ModelAndView("status");
    }

    @RequestMapping(value={"/configuration"})
    public ModelAndView configuration(Model model) {
        model.addAttribute("version", (Object)this.sawsVersion);
        model.addAttribute("sawsConfiguration", (Object)FileUtil.getSawsConfigurationInfo());
        model = this.addRequiredAttributes(model);
        return new ModelAndView("configuration");
    }

    @ResponseBody
    @RequestMapping(value={"/updateSAWSConfiguration"}, method={RequestMethod.POST})
    public String updateSAWSConfiguration(@ModelAttribute Configuration configuration, BindingResult result, Model model) {
        this.userService.updateSAWSConfiguration(configuration);
        return "SUCCESS";
    }

    @ResponseBody
    @RequestMapping(value={"/upgradeWebservice"}, method={RequestMethod.POST})
    public String upgradeWebservice(@RequestParam(value="key") String key, HttpServletRequest request) throws IOException {
        String token;
        block6: {
            block5: {
                token = CryptographicUtil.decrypt(FileUtil.getAPIkey());
                key = CryptographicUtil.decrypt(key);
                key = key.trim();
                logger.info("upgradeWebservice start");
                if (!token.trim().equals(key) || StatusUtil.isSawsBusy()) break block5;
                logger.info("download ok");
                this.sawsUpgradeService.upgradeSaws();
                return "SUCCESS";
            }
            if (!StatusUtil.isSawsBusy()) break block6;
            EmbeddedJetty.SCHEDULE_UPDATE = true;
            this.sawsUpgradeService.scheduleSAWSUpdate();
            return "EXECUTTION_IN_PROGRESS";
        }
        try {
            if (!token.trim().equals(key)) {
                return "INVALID_KEY";
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            logger.error(e.getMessage(), e);
        }
        return "FAILED";
    }

    @ResponseBody
    @RequestMapping(value={"/upgradeWebserviceTest"}, method={RequestMethod.POST})
    public String upgradeWebservice(HttpServletRequest request) {
        logger.info("executing ......................... ");
        this.sawsUpgradeService.restartSaws();
        return "FAILED";
    }

    @ResponseBody
    @RequestMapping(value={"/restart"}, method={RequestMethod.POST})
    public String restartJetty(HttpServletRequest request, HttpServletResponse responce) {
        this.sawsUpgradeService.rebootSaws();
        return "SUCCESS";
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/pingCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public String showIndex1(HttpServletRequest reques) {
        return this.message;
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/isSawsup"}, method={RequestMethod.GET})
    @ResponseBody
    public String isSawsUp(HttpServletRequest reques) {
        return "SUCCESS";
    }

    @RequestMapping(value={"/statusDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public String status(HttpServletRequest request) {
        return StatusUtil.getSatusData().toJSONString();
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public String testDM(HttpServletRequest request) {
        return CryptographicUtil.encrypt(FileUtil.readDataFromFile("C:\\Shafaqat\\DvSum\\05- Development-requirement\\Addr Validation issue\\json.txt"));
    }
}

