/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.model.User;
import com.dvsum.services.UserService;
import com.dvsum.util.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LoginController
extends BaseController {
    private static final long serialVersionUID = 3239358647104084546L;
    @Value(value="${example.message}")
    private String message;
    @Value(value="${logowhite}")
    private String logowhite;
    @Value(value="${bandTitle}")
    private String bandTitle;
    @Value(value="${logosm}")
    private String logosm;
    @Value(value="${saws.version}")
    private String sawsVersion;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/"})
    public ModelAndView home(Model model) {
        model = this.addRequiredAttributes(model);
        return new ModelAndView("redirect:login");
    }

    @RequestMapping(value={"/login"})
    public String showLogin(@RequestParam(value="emailAddress", required=false) String emailAddress, @ModelAttribute User user, BindingResult result, Model model) {
        model = this.addRequiredAttributes(model);
        if (!Util.isNullOrEmpty(this.getUserEmailAddress())) {
            return "redirect:/home";
        }
        if (!Util.isNullOrEmpty(emailAddress)) {
            model.addAttribute("emailAddress", (Object)emailAddress);
        }
        return "login";
    }

    @ResponseBody
    @RequestMapping(value={"/login.do"}, method={RequestMethod.POST})
    public String login(@ModelAttribute User user, HttpServletRequest request, HttpServletResponse response, BindingResult result, Model model) {
        String authResponse = this.userService.login(user);
        if ("SUCCESS".equalsIgnoreCase(authResponse)) {
            this.setSessionUser(response, user);
            return "SUCCESS";
        }
        model = this.addRequiredAttributes(model);
        return "login";
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logoutUser(response);
        model = this.addRequiredAttributes(model);
        return "redirect:/login";
    }

    @RequestMapping(value={"/home"})
    public ModelAndView dashboard(Model model) {
        model = this.addRequiredAttributes(model);
        return new ModelAndView("dashboard");
    }
}

