/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.model.User;
import com.dvsum.util.Util;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
public class BaseController
implements Serializable {
    private static final long serialVersionUID = -147196343638577002L;
    @Value(value="${logowhite}")
    private String logowhite;
    @Value(value="${brandTitle}")
    private String brandTitle;
    @Value(value="${logosm}")
    private String logosm;
    @Value(value="${saws.version}")
    private String sawsVersion;

    protected long getUniqueKey() {
        return System.currentTimeMillis();
    }

    protected String getUserEmailAddress() {
        return Util.getUserEmailAddress(this.getRequest());
    }

    protected HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    protected void setSessionUser(HttpServletResponse response, User user) {
        HttpServletRequest request = this.getRequest();
        request.getSession().setAttribute("loggedInUserName", (Object)user.getEmailAddress());
    }

    public void logoutUser(HttpServletResponse response) {
        this.getRequest().getSession().invalidate();
    }

    public Model addRequiredAttributes(Model model) {
        model.addAttribute("logosm", (Object)this.logosm);
        model.addAttribute("logowhite", (Object)this.logowhite);
        model.addAttribute("brandTitle", (Object)this.brandTitle);
        model.addAttribute("version", (Object)this.sawsVersion);
        return model;
    }
}

