/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.simple.JSONObject;

public class SnowflakeSource
extends CDataDataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";

    public SnowflakeSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public SnowflakeSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "cdata.jdbc.snowflake.SnowflakeDriver";
    }

    @Override
    public String getURL() {
        return "jdbc:snowflake:";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            this.props.setProperty("Url", this.url);
            this.props.setProperty("User", this.userName);
            this.props.setProperty("Password", this.password);
            this.props.setProperty("Database", Util.isNotNullOrEmpty(this.database) ? this.database : "SNOWFLAKE");
            this.props.setProperty("Warehouse", this.warehouse);
            this.props.setProperty("UseAsyncQuery", "true");
            this.props.setProperty("RoleName", Util.isNotNullOrEmpty(this.roleName) ? this.roleName : "PUBLIC");
            this.props.setProperty("AsyncQueryTimeout", "600");
            this.props.setProperty("Timeout", "600");
            this.props.setProperty("QueryPassthrough", "true");
            this.props.setProperty("MaxThreads", "20");
            if (Util.isNotNullOrEmpty(this.clientId)) {
                this.props.setProperty("Account", this.clientId);
            }
            this.props.setProperty("CredentialsLocation", this.credsFilePath);
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }
}

