/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.netezza.Driver;
import org.netezza.datasource.NzDatasource;
import org.netezza.ui.UIConstants;
import org.netezza.ui.gui.DsnDialog;
import org.netezza.ui.gui.GUIMain;

public class Dialogs
implements UIConstants {
    private static DsnDialog datasourceDialog;
    private static JOptionPane pane;
    private static final Font LABEL_FONT;

    public static void showSuccessDialog(String message, Component component) {
        JOptionPane.showMessageDialog(component, message, "Success", 1);
    }

    public static void showConnectionSuccessDialog(String message, Component component) {
        StringBuffer msg = new StringBuffer();
        msg.append("Connection Status : Success\n\n");
        msg.append(message);
        JTextArea area = new JTextArea(msg.toString());
        area.setEditable(false);
        area.setOpaque(false);
        area.setFont(LABEL_FONT);
        JOptionPane.showMessageDialog(component, area, "Connection Status", 1);
    }

    public static void showConnectionFailureDialog(Exception e, String message, Component component) {
        StringBuffer msg = new StringBuffer();
        msg.append("Connection Status : Failure\n");
        msg.append("Reason : " + e.getMessage() + "\n\n");
        msg.append(message);
        JTextArea area = new JTextArea(msg.toString());
        area.setEditable(false);
        area.setOpaque(false);
        area.setFont(LABEL_FONT);
        JOptionPane.showMessageDialog(component, area, "Connection Status", 0);
    }

    public static boolean showConfirmDialog(String message, Component component) {
        int result = JOptionPane.showConfirmDialog(component, message, "Confirmation", 0, 3);
        return result == 0;
    }

    public static void showErrorDialog(String error, Component component) {
        JOptionPane.showMessageDialog(component, error, "Error", 0);
    }

    public static NzDatasource showDatasourceDialog() {
        datasourceDialog.setVisible(true);
        return datasourceDialog.getDatasource();
    }

    public static NzDatasource showDatasourceDialog(NzDatasource source) {
        datasourceDialog.setVisible(source, true);
        return datasourceDialog.getDatasource();
    }

    public static void showHelpDialog(String help, Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        final JDialog dialog = pane.createDialog(component, "Help");
        dialog.setSize(width, height);
        dialog.getContentPane().removeAll();
        dialog.getContentPane().setLayout(null);
        dialog.setResizable(false);
        dialog.setModal(false);
        JTextPane textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane(textPane);
        String _help = Driver.getVersion() + "\n---------------------------------------------------------\n\n" + help;
        textPane.setText(_help);
        textPane.setCaretPosition(0);
        textPane.setEditable(false);
        scrollPane.getVerticalScrollBar().setValue(0);
        scrollPane.setBounds(0, 0, width - 8, height - 70);
        dialog.getContentPane().add(scrollPane);
        JButton ok = new JButton("OK");
        ok.setMnemonic(79);
        ok.setBounds(width / 2 - 40, height - 60, 80, 20);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.getContentPane().add(ok);
        GUIMain.setComponentToCenter(dialog);
        dialog.setVisible(true);
    }

    static {
        LABEL_FONT = new JLabel().getFont();
        datasourceDialog = new DsnDialog();
        datasourceDialog.setTitle("Data Source Configuration");
        GUIMain.setComponentToCenter(datasourceDialog);
        pane = new JOptionPane();
    }
}

