/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netezza.error.NzSQLException;
import org.netezza.internal.NzQuery;
import org.netezza.internal.ParseException;

public class NzPreparedQuery
extends NzQuery {
    protected final String query;
    protected final ArrayList<String> nativeQueryTokens;
    protected final StringBuilder preparedQuery;
    protected boolean parsed;
    protected NzQuery.QueryType type;
    protected int numberOfParams;
    protected String[] params;
    protected int[] paramBinary;
    protected final Vector<String[]> batch;
    protected boolean shouldAddZero = false;
    boolean isValuesClause = false;
    protected int[] maxParamLength;

    public NzPreparedQuery(String query) {
        this.query = query;
        this.nativeQueryTokens = new ArrayList();
        this.preparedQuery = new StringBuilder();
        this.batch = new Vector();
        this.paramBinary = null;
    }

    @Override
    public NzQuery parse() throws ParseException {
        if (this.query == null) {
            throw new ParseException("Query can not be NULL");
        }
        if (!this.parsed) {
            boolean analyzeFlg = this.getAnalyzeFlg();
            this.parsed = true;
            int index = 0;
            char c = '\u0000';
            int length = this.query.length();
            char next = '\u0000';
            StringBuilder buffer = new StringBuilder();
            StringBuilder token = new StringBuilder();
            StringBuilder pToken = new StringBuilder();
            StringBuilder newToken = new StringBuilder();
            char[] limitCharArr = new char[]{'L', 'I', 'M', 'I', 'T'};
            char[] offsetCharArr = new char[]{'O', 'F', 'F', 'S', 'E', 'T'};
            boolean mayBeBatch = false;
            block19: while (index < length) {
                c = this.query.charAt(index++);
                if (mayBeBatch) {
                    int spaceIndex = index;
                    while (spaceIndex < this.query.length()) {
                        if ((next = this.query.charAt(spaceIndex++)) == ' ' || next == '\t' || next == '\n') continue;
                        this.type = NzQuery.QueryType.BATCH;
                        mayBeBatch = false;
                        pToken.append(';');
                        break;
                    }
                }
                block1 : switch (c) {
                    case '\"': 
                    case '\'': {
                        char quote = c;
                        token.append(c);
                        pToken.append(c);
                        while (index < this.query.length()) {
                            c = this.query.charAt(index++);
                            token.append(c);
                            pToken.append(c);
                            if (c != quote) continue;
                            break block1;
                        }
                        continue block19;
                    }
                    case '/': {
                        if (this.type == null) {
                            newToken.append(c);
                        } else {
                            token.append(c);
                            pToken.append(c);
                        }
                        if (index == this.query.length()) break;
                        if (this.type == null) {
                            index = this.parseMultiLineComment(index, newToken);
                            break;
                        }
                        index = this.parseMultiLineComment(token, pToken, index);
                        break;
                    }
                    case '-': {
                        token.append(c);
                        pToken.append(c);
                        if (index == this.query.length()) break;
                        index = this.parseSingleLineComment(token, pToken, index);
                        break;
                    }
                    case '?': {
                        this.processParameterMarker(token, pToken);
                        break;
                    }
                    case '{': {
                        buffer = new StringBuilder();
                        buffer.append(c);
                        int curlyBraceCounter = 1;
                        char quoteInEscape = '\u0000';
                        do {
                            if (index >= this.query.length()) {
                                throw new ParseException("Syntax Error");
                            }
                            c = this.query.charAt(index++);
                            if (quoteInEscape == '\u0000') {
                                switch (c) {
                                    case '{': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter + 1);
                                        break;
                                    }
                                    case '}': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter - 1);
                                        break;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        quoteInEscape = c;
                                        break;
                                    }
                                }
                            } else if (c == quoteInEscape) {
                                quoteInEscape = '\u0000';
                            }
                            buffer.append(c);
                        } while (curlyBraceCounter != 0);
                        StringBuilder escapeBuilder = new StringBuilder();
                        int val = this.parseEscapeSequence(buffer.toString(), escapeBuilder);
                        if (val == -2) {
                            token.append(escapeBuilder + " ");
                            pToken.append(escapeBuilder + " ");
                            break;
                        }
                        if (val != -1) continue block19;
                        throw new ParseException("Syntax Error");
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        String type;
                        if (this.type == null && token.toString().matches("(.*)[A-Za-z]+(.*)") && (type = token.toString().replaceAll("[()]", "").trim().toUpperCase()) != null && type.length() != 0) {
                            this.type = NzQuery.QueryType.getType(type.toUpperCase());
                        }
                        token.append(c);
                        pToken.append(c);
                        break;
                    }
                    case ';': {
                        token.append(c);
                        if (this.type == NzQuery.QueryType.BATCH) continue block19;
                        mayBeBatch = true;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        boolean isLimitKeyWord;
                        token.append(c);
                        pToken.append(c);
                        if (this.type != NzQuery.QueryType.SELECT && this.type != NzQuery.QueryType.WITH) break;
                        int indexBeforeLimit = index - 2;
                        int indexAfterLimit = index + limitCharArr.length - 1;
                        if (indexBeforeLimit >= 0 && !Character.isWhitespace(this.query.charAt(indexBeforeLimit))) break;
                        boolean bl = isLimitKeyWord = this.query.regionMatches(true, index - 1, new String(limitCharArr), 0, limitCharArr.length) && Character.isWhitespace(this.query.charAt(indexAfterLimit));
                        if (!isLimitKeyWord) break;
                        this.clearBuffer(buffer);
                        next = this.query.charAt(index++);
                        while (isLimitKeyWord && !Character.isWhitespace(next)) {
                            buffer.append(next);
                            next = this.query.charAt(index++);
                        }
                        buffer.append(next);
                        token.append((CharSequence)buffer);
                        pToken.append((CharSequence)buffer);
                        index = this.parseLimitClause(token, pToken, buffer, index, analyzeFlg);
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        token.append(c);
                        pToken.append(c);
                        if (this.type != NzQuery.QueryType.SELECT && this.type != NzQuery.QueryType.SELECT_LIMIT && this.type != NzQuery.QueryType.WITH) break;
                        int indexBeforeOffset = index - 2;
                        int indexAfterOffset = index + offsetCharArr.length - 1;
                        if (indexBeforeOffset >= 0 && !Character.isWhitespace(this.query.charAt(indexBeforeOffset))) break;
                        this.shouldAddZero = this.query.regionMatches(true, index - 1, new String(offsetCharArr), 0, offsetCharArr.length) && Character.isWhitespace(this.query.charAt(indexAfterOffset));
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        token.append(c);
                        pToken.append(c);
                        try {
                            if (!Character.isWhitespace(this.query.charAt(index - 2)) && this.query.charAt(index - 2) != ')' || !Character.isWhitespace(this.query.charAt(index + 5)) && this.query.charAt(index + 5) != '(' || !this.query.regionMatches(true, index - 1, "VALUES", 0, 6)) continue block19;
                            this.isValuesClause = true;
                        }
                        catch (IndexOutOfBoundsException e) {}
                        break;
                    }
                    default: {
                        token.append(c);
                        pToken.append(c);
                    }
                }
            }
            if (newToken.length() > 0) {
                token = new StringBuilder().append((CharSequence)newToken).append((CharSequence)token);
                pToken = new StringBuilder().append((CharSequence)newToken).append((CharSequence)pToken);
            }
            if (this.type == null) {
                this.type = NzQuery.QueryType.OTHER;
            }
            if (token.length() > 0) {
                this.nativeQueryTokens.add(token.toString());
                this.preparedQuery.append((CharSequence)pToken);
            }
            this.params = new String[this.numberOfParams];
            this.paramBinary = new int[this.numberOfParams];
            this.maxParamLength = new int[this.numberOfParams];
        }
        if (this.type == NzQuery.QueryType.INSERT && !this.isValuesClause) {
            this.type = NzQuery.QueryType.OTHER;
        }
        return this;
    }

    private int parseMultiLineComment(StringBuilder token, StringBuilder pToken, int index) {
        char next = this.query.charAt(index++);
        token.append(next);
        pToken.append(next);
        if (next == '*') {
            while (index < this.query.length()) {
                next = this.query.charAt(index++);
                token.append(next);
                pToken.append(next);
                if (next != '*' || index >= this.query.length() || (next = this.query.charAt(index++)) != '/') continue;
                token.append(next);
                pToken.append(next);
                break;
            }
        }
        return index;
    }

    private int parseMultiLineComment(int index, StringBuilder newtoken) {
        char next = this.query.charAt(index++);
        newtoken.append(next);
        if (next == '*') {
            while (index < this.query.length()) {
                next = this.query.charAt(index++);
                newtoken.append(next);
                if (next != '*' || index >= this.query.length() || (next = this.query.charAt(index++)) != '/') continue;
                newtoken.append(next);
                break;
            }
        }
        return index;
    }

    private int parseSingleLineComment(StringBuilder token, StringBuilder pToken, int index) {
        char next;
        if ((next = this.query.charAt(index++)) == '-') {
            do {
                token.append(next);
                pToken.append(next);
            } while (index < this.query.length() && (next = this.query.charAt(index++)) != '\n');
            if (next == '\n') {
                token.append(next);
                pToken.append(next);
            }
        } else {
            token.append(next);
            pToken.append(next);
        }
        return index;
    }

    private int parseLimitClause(StringBuilder token, StringBuilder pToken, StringBuilder buffer, int index, boolean analyzeFlg) {
        boolean end = false;
        this.clearBuffer(buffer);
        --index;
        index = this.skipWhiteSpaces(token, pToken, index);
        block8: while (index < this.query.length() && !end) {
            char next = this.query.charAt(index);
            switch (next) {
                case '\t': 
                case '\n': 
                case ' ': {
                    String str = buffer.toString().trim();
                    if (this.isValidLimitOpd(str)) {
                        token.append(' ' + str + ' ');
                        if (!analyzeFlg) {
                            pToken.append(" 0 ");
                        } else {
                            pToken.append(' ' + str + ' ');
                        }
                    } else {
                        token.append((CharSequence)buffer).append(next);
                        pToken.append((CharSequence)buffer).append(next);
                    }
                    this.clearBuffer(buffer);
                    char ch = this.query.charAt(index = this.skipWhiteSpaces(token, pToken, index));
                    if (ch == '?' || ch == ',') continue block8;
                    end = true;
                    break;
                }
                case '?': {
                    this.shouldAddZero = true;
                    this.processParameterMarker(token, pToken);
                    index = this.skipWhiteSpaces(token, pToken, index);
                    this.clearBuffer(buffer);
                    if (index == this.query.length() - 1) {
                        this.type = NzQuery.QueryType.SELECT_LIMIT;
                        ++index;
                        break;
                    }
                    char ch = this.query.charAt(index);
                    if (ch == ',') continue block8;
                    end = true;
                    break;
                }
                case ';': {
                    this.type = NzQuery.QueryType.SELECT_LIMIT;
                    end = true;
                    break;
                }
                case ',': {
                    token.append((CharSequence)buffer).append(next);
                    if (this.isValidLimitOpd(buffer.toString().trim())) {
                        if (!analyzeFlg) {
                            pToken.append(" 0 ").append(next);
                        } else {
                            pToken.append((CharSequence)buffer).append(next);
                        }
                    } else {
                        pToken.append((CharSequence)buffer).append(next);
                    }
                    index = this.skipWhiteSpaces(token, pToken, index);
                    this.clearBuffer(buffer);
                    continue block8;
                }
                case '/': {
                    token.append(next);
                    pToken.append(next);
                    if (++index == this.query.length()) break;
                    index = this.parseMultiLineComment(token, pToken, index);
                    --index;
                    index = this.skipWhiteSpaces(token, pToken, index);
                    break;
                }
                case '-': {
                    token.append(next);
                    pToken.append(next);
                    if (++index == this.query.length()) break;
                    index = this.parseSingleLineComment(token, pToken, index);
                    --index;
                    index = this.skipWhiteSpaces(token, pToken, index);
                    break;
                }
                default: {
                    buffer.append(next);
                    ++index;
                }
            }
        }
        if (this.isSelectLimit(index)) {
            this.type = NzQuery.QueryType.SELECT_LIMIT;
        }
        token.append((CharSequence)buffer);
        if (this.isValidLimitOpd(buffer.toString().trim()) && !analyzeFlg) {
            pToken.append(" 0 ");
        } else {
            pToken.append((CharSequence)buffer);
        }
        return index;
    }

    private boolean isSelectLimit(int indexOfLimitClause) {
        String queryTail = this.query.substring(indexOfLimitClause).trim();
        if (!queryTail.endsWith(";")) {
            queryTail = queryTail + ";";
        }
        String regex = "(/\\*(.|\r|\n)*?\\*/)|(--.*(\n)*)|\\s|;";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(queryTail);
        int start = 0;
        int end = 0;
        ArrayList<String> validQueryTokens = new ArrayList<String>();
        while (matcher.find()) {
            start = matcher.start();
            String token = queryTail.substring(end, start);
            if (token.length() != 0) {
                validQueryTokens.add(token);
            }
            end = matcher.end();
        }
        if (validQueryTokens.size() > 2) {
            return false;
        }
        if (validQueryTokens.size() == 0) {
            return true;
        }
        if (validQueryTokens.size() == 2) {
            return ((String)validQueryTokens.get(0)).equalsIgnoreCase("OFFSET") && (this.isInteger((String)validQueryTokens.get(1)) || ((String)validQueryTokens.get(1)).equals("?"));
        }
        return false;
    }

    private void processParameterMarker(StringBuilder token, StringBuilder pToken) {
        ++this.numberOfParams;
        this.nativeQueryTokens.add(token.toString());
        this.preparedQuery.append((CharSequence)pToken).append(this.shouldAddZero ? " 0 " : null);
        this.clearBuffer(token);
        this.clearBuffer(pToken);
        this.shouldAddZero = false;
    }

    private int skipWhiteSpaces(StringBuilder token, StringBuilder pToken, int index) {
        char ch;
        while (index < this.query.length() - 1 && Character.isWhitespace(ch = this.query.charAt(++index))) {
            token.append(ch);
            pToken.append(ch);
        }
        return index;
    }

    private void clearBuffer(StringBuilder buffer) {
        buffer.setLength(0);
    }

    private boolean isValidLimitOpd(String str) {
        return str.equalsIgnoreCase("ALL") || this.isInteger(str);
    }

    @Override
    public String toString() {
        return this.query;
    }

    public void setParameter(int index, String parameter) throws SQLException {
        if (!this.parsed) {
            throw new NzSQLException("netezza.query.not.parsed", "HY000", 1100, new Object[0]);
        }
        if (index < 1 || index > this.numberOfParams) {
            throw new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, index);
        }
        this.params[index - 1] = parameter;
    }

    public void clearParameters() {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = null;
        }
    }

    @Override
    public NzQuery.QueryType getQueryType() {
        return this.type;
    }

    @Override
    public String toNativeString() throws NzSQLException {
        StringBuilder buffer = new StringBuilder();
        int length = this.nativeQueryTokens.size();
        for (int i = 0; i < length; ++i) {
            buffer.append(this.nativeQueryTokens.get(i));
            if (i >= this.numberOfParams) continue;
            if (this.params[i] != null) {
                buffer.append(this.params[i]);
                continue;
            }
            throw new NzSQLException("netezza.prep.param", "HY010", 11410, new Integer(i + 1));
        }
        return buffer.toString();
    }

    public NzQuery toPreparedQuery() {
        boolean analyzeFlg = this.getAnalyzeFlg();
        String pQuery = this.preparedQuery.toString();
        if (this.type == NzQuery.QueryType.SELECT || this.type == NzQuery.QueryType.WITH) {
            pQuery = analyzeFlg ? pQuery + "\n ANALYZE" : pQuery + "\n limit 0";
        }
        if (this.type == NzQuery.QueryType.SELECT_LIMIT && analyzeFlg) {
            pQuery = pQuery + "\n ANALYZE";
        }
        return new NzSelectQueryToPrepare(pQuery);
    }

    @Override
    public boolean isParsed() {
        return this.parsed;
    }

    public int getNumberOfParameters() {
        return this.numberOfParams;
    }

    public void addBatch() {
        String[] _params = new String[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            int paramLength = this.paramBinary[i] == 1 ? (this.params[i].equals("NULL") ? this.params[i].length() : (this.params[i].length() - 3) / 2) : this.params[i].length();
            if (i >= this.maxParamLength.length) {
                this.maxParamLength[i] = paramLength;
            } else if (paramLength > this.getMaxParamLength(i)) {
                this.maxParamLength[i] = paramLength;
            }
            _params[i] = this.params[i];
        }
        this.batch.add(_params);
    }

    public void clearBatch() {
        this.batch.clear();
    }

    public int batchSize() {
        return this.batch.size();
    }

    public String[] get(int index) throws SQLException {
        if (index < 0 || index >= this.batch.size()) {
            throw new NzSQLException("netezza.idx.out.of.range", "HY000", 1021, index);
        }
        return this.batch.elementAt(index);
    }

    public int getMaxParamLength(int index) {
        if (index >= this.maxParamLength.length) {
            return 0;
        }
        return this.maxParamLength[index];
    }

    public void setParamBinary(int index, int binary) throws SQLException {
        if (!this.parsed) {
            throw new NzSQLException("netezza.query.not.parsed", "HY000", 1100, new Object[0]);
        }
        if (index < 1 || index > this.numberOfParams) {
            throw new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, index);
        }
        if (this.paramBinary == null) {
            return;
        }
        this.paramBinary[index - 1] = binary;
    }

    public int getParamBinary(int index) {
        if (this.paramBinary == null) {
            return 0;
        }
        if (index - 1 >= this.paramBinary.length) {
            return 0;
        }
        return this.paramBinary[index - 1];
    }

    protected class NzSelectQueryToPrepare
    extends NzQuery {
        private final String sql;

        public NzSelectQueryToPrepare(String sql) {
            this.sql = sql;
        }

        @Override
        public NzQuery.QueryType getQueryType() {
            return NzPreparedQuery.this.type;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return this.sql;
        }

        @Override
        public String toString() {
            return this.sql;
        }
    }
}

