/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.ietf.jgss.GSSCredential;
import org.netezza.Driver;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzSQLException;
import org.netezza.logging.LogLevel;
import org.netezza.logging.LoggerType;
import org.netezza.sql.NzConnection;
import org.netezza.util.NzSecurityLevel;

public class NzDatasource
implements DataSource {
    private String name;
    private String description;
    private String logDirPath;
    private String user;
    private String password;
    private String protocol;
    private String database;
    private String host;
    private String url;
    private String caCertificate;
    private String logLevel;
    private String loggerType;
    private String securityLevel;
    private String currentSchema;
    private int port;
    private int batchSize;
    private int loginTimeout;
    private boolean readOnly;
    private boolean autoCommit;
    private int socketBufferSize;
    private StringBuilder connectionProprties = new StringBuilder();
    private boolean specCompliantDBMeta;
    private boolean ignoreUpdtCount;
    private String krbLoginModule;
    private boolean krbSSODelegation;
    private String applicationName;
    private String clientUser;
    private String clientHostName;
    private GSSCredential clientCredentials;
    private boolean enableUserDomain;
    private PrintWriter out;

    public NzDatasource() {
        this("");
    }

    public NzDatasource(String name) {
        this.name = name;
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.autoCommit = true;
        this.batchSize = 256;
        this.caCertificate = "";
        this.database = "";
        this.description = "";
        this.host = "";
        this.logDirPath = DefaultValues.DEFAULT_LOG_DIR_PATH;
        this.logLevel = DefaultValues.DEFAULT_LOG_LEVEL;
        this.loggerType = DefaultValues.DEFAULT_LOGGER_TYPE.toString();
        this.loginTimeout = 0;
        this.password = "";
        this.port = 5480;
        this.protocol = "netezza";
        this.readOnly = false;
        this.securityLevel = DefaultValues.DEFAULT_SECURITY_LEVEL.toString();
        this.socketBufferSize = 8192;
        this.specCompliantDBMeta = false;
        this.ignoreUpdtCount = false;
        this.currentSchema = "";
        this.krbLoginModule = "EntryModuleName";
        this.krbSSODelegation = false;
        this.applicationName = "";
        this.clientUser = "";
        this.clientHostName = "";
        this.clientCredentials = DefaultValues.DEFAULT_CREDENTIALS;
        this.enableUserDomain = false;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        this.connectionProprties.append("autocommit=" + autoCommit + ";");
    }

    public void setDefaultAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean getSpecCompliantDBMeta() {
        return this.specCompliantDBMeta;
    }

    public void setSpecCompliantDBMeta(boolean specCompliantDBMeta) {
        this.specCompliantDBMeta = specCompliantDBMeta;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        this.connectionProprties.append("batchSize=" + batchSize + ";");
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
        this.connectionProprties.append("caCertFile=" + caCertificate + ";");
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host == null ? null : host.trim();
    }

    public String getLogDirPath() {
        return this.logDirPath;
    }

    public void setLogDirPath(String logDirPath) {
        this.logDirPath = logDirPath;
        this.connectionProprties.append("logDirPath=" + logDirPath + ";");
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
        this.connectionProprties.append("loginTimeout=" + loginTimeout + ";");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password == null ? null : password.trim();
        this.connectionProprties.append("password=" + password + ";");
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.connectionProprties.append("readonly=" + readOnly + ";");
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user == null ? null : user.trim();
        this.connectionProprties.append("user=" + this.user + ";");
    }

    public String getLoggerType() {
        return this.loggerType;
    }

    public void setLoggerType(String loggerType) {
        this.loggerType = loggerType;
        this.connectionProprties.append("loggerType=" + loggerType + ";");
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.getLogLevel(logLevel).toString();
        this.connectionProprties.append("logLevel=" + logLevel + ";");
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(String securityLevel) {
        this.securityLevel = securityLevel;
        this.connectionProprties.append("securityLevel=" + securityLevel + ";");
    }

    public boolean getIgnoreUpdtCount() {
        return this.ignoreUpdtCount;
    }

    public void setIgnoreUpdtCount(boolean ignoreUpdtCount) {
        this.ignoreUpdtCount = ignoreUpdtCount;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
    }

    public String getKrbLoginModuleName() {
        return this.krbLoginModule;
    }

    public void setKrbLoginModuleName(String krbLoginModule) {
        this.krbLoginModule = krbLoginModule;
        if (krbLoginModule.length() > 0) {
            this.connectionProprties.append("krbLoginModule=" + krbLoginModule + ";");
        }
    }

    public boolean isClientKrbSSODelegated() {
        return this.krbSSODelegation;
    }

    public void setClientKrbSSODelegation(boolean krbSSODelegation) {
        this.krbSSODelegation = krbSSODelegation;
        this.connectionProprties.append("krbSSODelegation=" + krbSSODelegation + ";");
    }

    public String getClientApplicationName() {
        return this.applicationName;
    }

    public void setClientApplicationName(String applicationName) {
        this.applicationName = applicationName;
        this.connectionProprties.append("applicationName=" + applicationName + ";");
    }

    public String getClientUser() {
        return this.clientUser;
    }

    public void setClientUser(String clientUser) {
        this.clientUser = clientUser;
        this.connectionProprties.append("clientUser=" + clientUser + ";");
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public void setClientHostName(String clientHostName) {
        this.clientHostName = clientHostName;
        this.connectionProprties.append("clientHostName=" + clientHostName + ";");
    }

    public GSSCredential getGSSCredential() {
        return this.clientCredentials;
    }

    public void setGSSCredential(GSSCredential clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    public boolean isUserDomainForest() {
        return this.enableUserDomain;
    }

    public void setUserDomainForest(boolean enableUserDomain) {
        this.enableUserDomain = enableUserDomain;
        this.connectionProprties.append("enableUserDomain=" + enableUserDomain + ";");
    }

    public void copyTo(NzDatasource to) {
        if (to == null) {
            return;
        }
        to.setName(this.getName());
        to.setDescription(this.getDescription());
        to.setBatchSize(this.getBatchSize());
        to.setLoginTimeout(this.getLoginTimeout());
        to.setLogLevel(this.getLogLevel());
        to.setLogDirPath(this.getLogDirPath());
        to.setLoggerType(this.getLoggerType());
        to.setUser(this.getUser());
        to.setPassword(this.getPassword());
        to.setDatabase(this.getDatabase());
        to.setHost(this.getHost());
        to.setPort(this.getPort());
        to.setReadOnly(this.isReadOnly());
        to.setAutoCommit(this.isAutoCommit());
        to.setSecurityLevel(this.getSecurityLevel());
        to.setCaCertificate(this.getCaCertificate());
        to.setProtocol(this.getProtocol());
        to.setSocketBufferSize(this.getSocketBufferSize());
        to.setSpecCompliantDBMeta(this.getSpecCompliantDBMeta());
        to.setIgnoreUpdtCount(this.getIgnoreUpdtCount());
        to.setCurrentSchema(this.getCurrentSchema());
        to.setKrbLoginModuleName(this.getKrbLoginModuleName());
        to.setClientKrbSSODelegation(this.isClientKrbSSODelegated());
        to.setClientApplicationName(this.getClientApplicationName());
        to.setClientUser(this.getClientUser());
        to.setClientHostName(this.getClientHostName());
        to.setGSSCredential(this.getGSSCredential());
        to.setUserDomainForest(this.isUserDomainForest());
    }

    public void copyFrom(NzDatasource from) {
        if (from == null) {
            return;
        }
        this.setName(from.getName());
        this.setDescription(from.getDescription());
        this.setBatchSize(from.getBatchSize());
        this.setLoginTimeout(from.getLoginTimeout());
        this.setLogLevel(from.getLogLevel());
        this.setLogDirPath(from.getLogDirPath());
        this.setLoggerType(from.getLoggerType());
        this.setUser(from.getUser());
        this.setPassword(from.getPassword());
        this.setDatabase(from.getDatabase());
        this.setHost(from.getHost());
        this.setPort(from.getPort());
        this.setReadOnly(from.isReadOnly());
        this.setAutoCommit(from.isAutoCommit());
        this.setSecurityLevel(from.getSecurityLevel());
        this.setCaCertificate(from.getCaCertificate());
        this.setProtocol(from.getProtocol());
        this.setSocketBufferSize(from.getSocketBufferSize());
        this.setSpecCompliantDBMeta(from.getSpecCompliantDBMeta());
        this.setIgnoreUpdtCount(from.getIgnoreUpdtCount());
        this.setCurrentSchema(from.getCurrentSchema());
        this.setKrbLoginModuleName(from.getKrbLoginModuleName());
        this.setClientKrbSSODelegation(from.isClientKrbSSODelegated());
        this.setClientApplicationName(from.getClientApplicationName());
        this.setClientUser(from.getClientUser());
        this.setClientHostName(from.getClientHostName());
        this.setGSSCredential(from.getGSSCredential());
        this.setUserDomainForest(from.isUserDomainForest());
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.setUser(username);
        this.setPassword(password);
        if (this.loginTimeout <= 0) {
            if (this.getUrl() == null || this.getUrl().trim().length() == 0) {
                this.setUrl("jdbc:" + this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + "/" + this.getDatabase() + "?" + this.connectionProprties);
            }
            NzConnection connection = new NzConnection(this);
            connection.open();
            return connection;
        }
        ConnectionThread cThread = new ConnectionThread();
        new Thread(cThread).start();
        return cThread.getConnetion();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.out = out;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        SQLFeatureNotSupportedException etothrow = new SQLFeatureNotSupportedException("Feature 'getParentLogger' is not supported by Netezza JDBC driver");
        throw etothrow;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        throw etothrow;
    }

    static {
        try {
            Class.forName("org.netezza.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Netezza DataSource unable to load Netezza JDBC Driver");
        }
    }

    private class ConnectionThread
    implements Runnable {
        private NzConnection tConnection = null;
        private Throwable throwable;
        private boolean abandon;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NzConnection tempConnection = null;
            this.throwable = null;
            try {
                tempConnection = new NzConnection(NzDatasource.this);
                tempConnection.open();
            }
            catch (Throwable e) {
                tempConnection = null;
                this.throwable = e;
            }
            ConnectionThread connectionThread = this;
            synchronized (connectionThread) {
                if (this.abandon) {
                    if (this.tConnection != null) {
                        try {
                            this.tConnection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.tConnection = tempConnection;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        NzConnection getConnetion() throws SQLException {
            long duration = System.currentTimeMillis() + (long)NzDatasource.this.loginTimeout;
            ConnectionThread connectionThread = this;
            synchronized (connectionThread) {
                while (this.tConnection == null) {
                    duration -= System.currentTimeMillis();
                    if (this.throwable != null) {
                        if (this.throwable instanceof SQLException) {
                            throw (SQLException)this.throwable;
                        }
                        throw new NzSQLException(this.throwable.getMessage(), "HY000", 1100, new Object[0]);
                    }
                    if (duration <= 0L) {
                        this.abandon = true;
                        throw new NzSQLException("netezza.login.timeout.expired", "HYT00", 1116, new Object[0]);
                    }
                    try {
                        this.wait(duration);
                    }
                    catch (InterruptedException e) {
                        this.abandon = true;
                        throw new NzSQLException("netezza.con.interrupted", "HY000", 1118, new Object[0]);
                    }
                }
                return this.tConnection;
            }
        }
    }

    public static interface DefaultValues {
        public static final String PROTOCOL = "netezza";
        public static final String DEFAULT_NAME = "";
        public static final int DEFAULT_BATCH_SIZE = 256;
        public static final String DEFAULT_LOG_LEVEL = LogLevel.getDefault().toString();
        public static final LoggerType DEFAULT_LOGGER_TYPE = LoggerType.DEFAULT;
        public static final int DEFAULT_LOGIN_TIMEOUT = 0;
        public static final String DEFAULT_DESCRIPTION = "";
        public static final String DEFAULT_USER = null;
        public static final String DEFAULT_PASSWORD = "";
        public static final String DEFAULT_DATABASE = "";
        public static final String DEFAULT_HOST = "";
        public static final String DEFAULT_CA_CERT_PATH = "";
        public static final NzSecurityLevel DEFAULT_SECURITY_LEVEL = NzSecurityLevel.getDefault();
        public static final String DEFAULT_LOG_DIR_PATH = Driver.getDefaultLogDirectoryPath();
        public static final String DEFAULT_CURRENT_SCHEMA = "";
        public static final int DEFAULT_PORT = 5480;
        public static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
        public static final boolean DEFAULT_READ_ONLY = false;
        public static final boolean DEFAULT_AUTO_COMMIT = true;
        public static final boolean DEFAULT_SPEC_COMPLIANT_DBMETA = false;
        public static final boolean DEFAULT_IGNORE_UPDT_COUNT = false;
        public static final String DEFAULT_KRB_LOGIN_MODULE_NAME = "EntryModuleName";
        public static final boolean DEFAULT_KRB_SSO_DELEGATION = false;
        public static final String DEFAULT_APPLICATION_NAME = "";
        public static final String DEFAULT_CLIENT_USER = "";
        public static final String DEFAULT_CLIENT_HOST_NAME = "";
        public static final GSSCredential DEFAULT_CREDENTIALS = null;
        public static final boolean DEFAULT_ENABLE_USERDOMAIN = false;
    }
}

