/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.netezza.Driver;
import org.netezza.datasource.NzConnectionPoolDatasource;
import org.netezza.datasource.NzDatasource;

public class NzConnectionPool
extends NzDatasource {
    private Stack<PooledConnection> available = new Stack();
    private Stack<PooledConnection> used = new Stack();
    private final Object LOCK = new Object();
    private boolean initialized;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private final ConnectionEventListener LISTENER = new Listener();
    private NzConnectionPoolDatasource cpds = new NzConnectionPoolDatasource();

    @Override
    public String getDescription() {
        return "Pooling DataSource '" + this.getName() + " from " + Driver.getVersion();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if ((username == null || username.equals(this.getUser())) && (username == null || username.equals(this.getPassword()))) {
            return this.getConnection();
        }
        this.setUser(username);
        this.setPassword(password);
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pooledConnection = null;
            if (this.available == null) {
                throw new SQLException("DataSource has been closed.");
            }
            while (true) {
                if (this.available.size() > 0) {
                    pooledConnection = this.available.pop();
                    this.used.push(pooledConnection);
                    break;
                }
                if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                    pooledConnection = this.cpds.getPooledConnection();
                    this.used.push(pooledConnection);
                    break;
                }
                try {
                    this.LOCK.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pooledConnection.addConnectionEventListener(this.LISTENER);
            return pooledConnection.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pc;
            while (this.available.size() > 0) {
                pc = this.available.pop();
                try {
                    pc.close();
                }
                catch (SQLException e) {}
            }
            this.available = null;
            while (true) {
                if (this.used.size() <= 0) {
                    this.used = null;
                    return;
                }
                pc = this.used.pop();
                pc.removeConnectionEventListener(this.LISTENER);
                try {
                    pc.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int initialConnections) {
        this.initialConnections = initialConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws SQLException {
        Object object = this.LOCK;
        synchronized (object) {
            this.cpds.copyFrom(this);
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.cpds.getPooledConnection());
            }
            this.initialized = true;
        }
    }

    private class Listener
    implements ConnectionEventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent event) {
            System.out.println("connection closed");
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = NzConnectionPool.this.LOCK;
            synchronized (object) {
                if (NzConnectionPool.this.available == null) {
                    return;
                }
                boolean removed = NzConnectionPool.this.used.remove(event.getSource());
                if (removed) {
                    NzConnectionPool.this.available.push((PooledConnection)event.getSource());
                    NzConnectionPool.this.LOCK.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            Object object = NzConnectionPool.this.LOCK;
            synchronized (object) {
                if (NzConnectionPool.this.available == null) {
                    return;
                }
                NzConnectionPool.this.used.remove(event.getSource());
                NzConnectionPool.this.LOCK.notify();
            }
        }
    }
}

