/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Pattern;

public class ConfigReader {
    private static final String SSL_CONFIG_FILE = "ssl_config.properties";
    private static final String APP_CONFIG_FILE = "configuration.properties";
    private static final String DEFAULT_DOMAIN = "localhost";
    private static final String DEFAULT_PORT = "8080";
    private static Properties sslProps = new Properties();
    private static Properties appProps = new Properties();

    static {
        ConfigReader.loadProperties();
    }

    private static void loadProperties() {
        ConfigReader.loadProperty(sslProps, SSL_CONFIG_FILE);
        ConfigReader.loadProperty(appProps, APP_CONFIG_FILE);
    }

    private static void loadProperty(Properties props, String fileName) {
        String currentDir = System.getProperty("user.dir");
        String filePath = Paths.get(currentDir, fileName).toString();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
                props.load(input);
                System.out.println("Loaded properties from: " + filePath);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            try {
                Throwable throwable = null;
                Object var6_13 = null;
                try (InputStream input = ConfigReader.class.getClassLoader().getResourceAsStream(fileName);){
                    if (input != null) {
                        props.load(input);
                        System.out.println("Loaded properties from classpath: " + fileName);
                    } else {
                        System.err.println("Unable to find " + fileName);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                System.err.println("Error loading " + fileName + ": " + ex.getMessage());
            }
        }
    }

    public static String getDomain() {
        String domain = sslProps.getProperty("domain_name");
        if (domain == null || domain.isEmpty()) {
            return DEFAULT_DOMAIN;
        }
        return domain.replaceFirst("^(https?://)", "");
    }

    public static String getPort() {
        String port = appProps.getProperty("port");
        return port != null && !port.isEmpty() ? port : DEFAULT_PORT;
    }

    public static String getPingUrl() {
        String domain = ConfigReader.getDomain();
        String port = ConfigReader.getPort();
        if (Pattern.matches(".*:\\d+$", domain)) {
            return String.format("https://%s/webservice/isSawsup", domain);
        }
        return String.format("https://%s:%s/webservice/isSawsup", domain, port);
    }

    public static void main(String[] args) {
        System.out.println("Ping URL: " + ConfigReader.getPingUrl());
    }
}

