/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.starter;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TLSHttpsRequestor {
    private static final Logger logger = LogManager.getLogger(TLSHttpsRequestor.class);

    private static Double getPercentage(Long total, Long value) {
        Double result = value.doubleValue() / total.doubleValue() * 100.0;
        return result;
    }

    private static void printAbsolutePercentage(Double value) {
        String valStr = String.valueOf(value);
        String valDecimal = valStr.substring(valStr.indexOf(".") + 1, valStr.length());
        Double valDouble = Double.parseDouble(valDecimal);
        if (valDouble == 0.0) {
            System.out.println(String.valueOf(value.intValue()) + "%");
        }
    }

    public static int executeGet(String url, Object[] parameterValues, Object[] parametersName) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        int respCode = 500;
        try {
            HttpClient client = TLSHttpsRequestor.getHttpClient();
            HttpGet httpget = new HttpGet(url);
            logger.info("polling ........." + httpget.getURI());
            int i = 1;
            while (i <= parameterValues.length) {
                parameters.add((NameValuePair)new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                ++i;
            }
            URI uri = new URIBuilder(httpget.getURI()).addParameters(parameters).build();
            httpget.setURI(uri);
            HttpResponse resp = client.execute(httpget);
            HttpEntity entity = resp.getEntity();
            respCode = resp.getStatusLine().getStatusCode();
        }
        catch (Exception exp) {
            TLSHttpsRequestor.sendErrorEmail(exp.getMessage(), url);
            exp.printStackTrace();
            logger.error("Exception: ", (Throwable)exp);
        }
        logger.info("response Code " + respCode);
        return respCode;
    }

    public static void sendErrorEmail(String exp, String url) {
    }

    public static String executePost(String url, List<String> parameterValues, List<String> parametersName) {
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        String responseString = null;
        logger.info("Post request to........." + url);
        try {
            HttpClient client = TLSHttpsRequestor.getHttpClient();
            HttpPost httpPost = new HttpPost(url);
            int i = 1;
            while (i <= parameterValues.size()) {
                postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                ++i;
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
            HttpResponse resp = client.execute(httpPost);
            HttpEntity entity = resp.getEntity();
            logger.info("Data Posted Successfuly.........");
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception exp) {
            exp.printStackTrace();
            logger.error("Exception: ", (Throwable)exp);
        }
        return responseString;
    }

    public static HttpClient getHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, null, new SecureRandom());
        SSLSocketFactory sf = new SSLSocketFactory(sslContext);
        Scheme httpsScheme = new Scheme("https", 443, sf);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(httpsScheme);
        SingleClientConnManager cm = new SingleClientConnManager(schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient(cm);
        return client;
    }
}

