/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.starter;

import com.dvsum.util.ConfigReader;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpsRequestor {
    private static final Logger logger = LogManager.getLogger(HttpsRequestor.class);

    public static boolean isSAWSUAndRunning() {
        logger.info("Ping SAWS....");
        System.out.println("Pinging SAWS");
        String pingUrl = ConfigReader.getPingUrl();
        logger.info("Ping URL: {}", (Object)pingUrl);
        int respCode = HttpsRequestor.pingSAWS(pingUrl);
        return respCode == 200;
    }

    public static int pingSAWS(String url) {
        logger.info("Ping request to {}", (Object)url);
        int respCode = 500;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setConnectionRequestTimeout(30000).build();
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory(sslFactory).build();){
                HttpGet httpGet = new HttpGet(url);
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (CloseableHttpResponse response = httpClient.execute(httpGet);){
                    respCode = response.getStatusLine().getStatusCode();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.error("Error pinging SAWS", (Throwable)e);
        }
        logger.info("Response Code: {}", (Object)respCode);
        return respCode;
    }
}

