/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class JSONDynaClass
implements DynaClass,
Serializable {
    private static final Comparator DynaPropertyComparator = new Comparator(){

        public int compare(Object a, Object b) {
            if (a instanceof DynaProperty && b instanceof DynaProperty) {
                DynaProperty p1 = (DynaProperty)a;
                DynaProperty p2 = (DynaProperty)b;
                return p1.getName().compareTo(p2.getName());
            }
            return -1;
        }
    };
    private static final long serialVersionUID = 3856810283982201386L;
    protected Map attributes;
    protected DynaProperty[] dynaProperties;
    protected transient Class jsonBeanClass;
    protected String name;
    protected Map properties = new HashMap();
    protected Class type;
    static /* synthetic */ Class class$net$sf$json$JSONDynaBean;

    public JSONDynaClass(String name, Class type, Map attributes) {
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.process();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONDynaClass)) {
            return false;
        }
        JSONDynaClass other = (JSONDynaClass)obj;
        EqualsBuilder builder = new EqualsBuilder().append(this.name, other.name).append(this.type, other.type);
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            DynaProperty a = this.dynaProperties[i];
            DynaProperty b = other.dynaProperties[i];
            builder.append(a.getName(), b.getName());
            builder.append(a.getType(), b.getType());
        }
        return builder.isEquals();
    }

    public DynaProperty[] getDynaProperties() {
        return this.dynaProperties;
    }

    public DynaProperty getDynaProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Unnespecified bean property name");
        }
        return (DynaProperty)this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.name).append(this.type);
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            builder.append(this.dynaProperties[i].getName());
            builder.append(this.dynaProperties[i].getType());
        }
        return builder.toHashCode();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        JSONDynaBean dynamicForm = (JSONDynaBean)this.getJsonBeanClass().newInstance();
        dynamicForm.setDynamicFormClass(this);
        Iterator keys = this.attributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dynamicForm.set(key, null);
        }
        return dynamicForm;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("type", this.type).append("attributes", this.attributes).toString();
    }

    protected Class getJsonBeanClass() {
        if (this.jsonBeanClass == null) {
            this.process();
        }
        return this.jsonBeanClass;
    }

    private void process() {
        this.jsonBeanClass = this.type;
        if (!(class$net$sf$json$JSONDynaBean == null ? (class$net$sf$json$JSONDynaBean = JSONDynaClass.class$("net.sf.json.JSONDynaBean")) : class$net$sf$json$JSONDynaBean).isAssignableFrom(this.jsonBeanClass)) {
            throw new IllegalArgumentException("Unnasignable dynaClass " + this.jsonBeanClass);
        }
        try {
            Iterator entries = this.attributes.entrySet().iterator();
            this.dynaProperties = new DynaProperty[this.attributes.size()];
            int i = 0;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String pname = (String)entry.getKey();
                Object pclass = entry.getValue();
                DynaProperty dynaProperty = null;
                if (pclass instanceof String) {
                    dynaProperty = new DynaProperty(pname, Class.forName((String)pclass));
                } else if (pclass instanceof Class) {
                    dynaProperty = new DynaProperty(pname, (Class)pclass);
                } else {
                    throw new IllegalArgumentException("Type must be String or Class");
                }
                this.properties.put(dynaProperty.getName(), dynaProperty);
                this.dynaProperties[i++] = dynaProperty;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        Arrays.sort(this.dynaProperties, 0, this.dynaProperties.length, DynaPropertyComparator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

