/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONTokener;
import net.sf.json.JSONUtils;
import org.apache.commons.lang.ArrayUtils;

public class JSONArray {
    private List elements = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$json$JSONArray;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;

    public static JSONArray fromArray(Object[] array) {
        return new JSONArray(Arrays.asList(array));
    }

    public static JSONArray fromCollection(Collection collection) {
        return new JSONArray(collection);
    }

    public static JSONArray fromJSONTokener(JSONTokener tokener) {
        return new JSONArray(tokener);
    }

    public static JSONArray fromObject(Object object) {
        if (object instanceof Collection) {
            return JSONArray.fromCollection((Collection)object);
        }
        if (object instanceof JSONArray) {
            return new JSONArray((JSONArray)object);
        }
        if (object instanceof JSONTokener) {
            return JSONArray.fromJSONTokener((JSONTokener)object);
        }
        if (object instanceof String) {
            return JSONArray.fromString((String)object);
        }
        if (object != null && object.getClass().isArray()) {
            Class<?> type = object.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return JSONArray.fromArray((Object[])object);
            }
            if (type == Boolean.TYPE) {
                return new JSONArray((boolean[])object);
            }
            if (type == Byte.TYPE) {
                return new JSONArray((byte[])object);
            }
            if (type == Short.TYPE) {
                return new JSONArray((short[])object);
            }
            if (type == Integer.TYPE) {
                return new JSONArray((int[])object);
            }
            if (type == Long.TYPE) {
                return new JSONArray((long[])object);
            }
            if (type == Float.TYPE) {
                return new JSONArray((float[])object);
            }
            if (type == Double.TYPE) {
                return new JSONArray((double[])object);
            }
            if (type == Character.TYPE) {
                return new JSONArray((char[])object);
            }
            throw new IllegalArgumentException("Unsupported type");
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    public static JSONArray fromString(String string) {
        return new JSONArray(string);
    }

    public static Object[] toArray(JSONArray jsonArray) {
        return JSONArray.toArray(jsonArray, null, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toArray(jsonArray, objectClass, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass, Map classMap) {
        int[] dimensions = JSONUtils.getDimensions(jsonArray);
        Object array = Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = JSONArray.class$("java.lang.Object")) : class$java$lang$Object, dimensions);
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            Class<?> type;
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                Array.set(array, i, null);
                continue;
            }
            if ((class$net$sf$json$JSONArray == null ? JSONArray.class$("net.sf.json.JSONArray") : class$net$sf$json$JSONArray).isAssignableFrom(type = value.getClass())) {
                Array.set(array, i, JSONArray.toArray((JSONArray)value, objectClass, classMap));
                continue;
            }
            if ((class$java$lang$String == null ? JSONArray.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONArray.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Byte == null ? JSONArray.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Short == null ? JSONArray.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Integer == null ? JSONArray.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? JSONArray.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Float == null ? JSONArray.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? JSONArray.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? JSONArray.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONArray.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                Array.set(array, i, value);
                continue;
            }
            if (objectClass != null) {
                Array.set(array, i, JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            Array.set(array, i, JSONObject.toBean((JSONObject)value));
        }
        return (Object[])array;
    }

    public static List toList(JSONArray jsonArray) {
        return JSONArray.toList(jsonArray, null, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toList(jsonArray, objectClass, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass, Map classMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            Class<?> type;
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                list.add(null);
                continue;
            }
            if ((class$net$sf$json$JSONArray == null ? JSONArray.class$("net.sf.json.JSONArray") : class$net$sf$json$JSONArray).isAssignableFrom(type = value.getClass())) {
                list.add(JSONArray.toList((JSONArray)value, objectClass, classMap));
                continue;
            }
            if ((class$java$lang$String == null ? JSONArray.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONArray.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Byte == null ? JSONArray.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Short == null ? JSONArray.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Integer == null ? JSONArray.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? JSONArray.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Float == null ? JSONArray.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? JSONArray.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? JSONArray.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONArray.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                list.add(value);
                continue;
            }
            if (objectClass != null) {
                list.add(JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            list.add(JSONObject.toBean((JSONObject)value));
        }
        return list;
    }

    public JSONArray() {
    }

    public JSONArray(boolean[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(byte[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(char[] array) {
        this.elements.addAll(Arrays.asList(JSONUtils.toObject(array)));
    }

    public JSONArray(Collection collection) {
        if (collection != null) {
            Iterator elements = collection.iterator();
            while (elements.hasNext()) {
                Object element = elements.next();
                if (JSONUtils.isArray(element)) {
                    this.elements.add(JSONArray.fromObject(element));
                    continue;
                }
                if (element instanceof JSONArray) {
                    this.elements.add(new JSONArray((JSONArray)element));
                    continue;
                }
                if (JSONUtils.isFunction(element)) {
                    if (element instanceof String) {
                        this.elements.add(JSONFunction.parse((String)element));
                        continue;
                    }
                    this.elements.add(element);
                    continue;
                }
                if (JSONUtils.isObject(element)) {
                    JSONObject jsonObject = JSONObject.fromObject(element);
                    if (jsonObject.isNullObject()) {
                        this.elements.add(JSONNull.getInstance());
                        continue;
                    }
                    this.elements.add(jsonObject);
                    continue;
                }
                this.elements.add(element);
            }
        }
    }

    public JSONArray(double[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(float[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(int[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.elements.addAll(jsonArray.elements);
        }
    }

    public JSONArray(JSONTokener x) {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.elements.add(JSONNull.getInstance());
            } else {
                x.back();
                Object v = x.nextValue();
                if (!JSONUtils.isFunctionHeader(v)) {
                    this.elements.add(v);
                } else {
                    char ch;
                    String params = JSONUtils.getFunctionParams((String)v);
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    while ((ch = x.next()) != '\u0000') {
                        if (ch == '{') {
                            ++i;
                        }
                        if (ch == '}') {
                            --i;
                        }
                        sb.append(ch);
                        if (i != 0) continue;
                        break;
                    }
                    if (i != 0) {
                        throw x.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                    }
                    String text = sb.toString();
                    text = text.substring(1, text.length() - 1).trim();
                    this.elements.add(new JSONFunction(params != null ? params.split(",") : null, text));
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(long[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            if (JSONUtils.isArray(element)) {
                this.elements.add(JSONArray.fromObject(element));
                continue;
            }
            if (element instanceof JSONArray) {
                this.elements.add(new JSONArray((JSONArray)element));
                continue;
            }
            if (JSONUtils.isFunction(element)) {
                if (element instanceof String) {
                    this.elements.add(JSONFunction.parse((String)element));
                    continue;
                }
                this.elements.add(element);
                continue;
            }
            if (JSONUtils.isObject(element)) {
                JSONObject jsonObject = JSONObject.fromObject(element);
                if (jsonObject.isNullObject()) {
                    this.elements.add(JSONNull.getInstance());
                    continue;
                }
                this.elements.add(jsonObject);
                continue;
            }
            this.elements.add(element);
        }
    }

    public JSONArray(short[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject(array)));
    }

    public JSONArray(String string) {
        this(new JSONTokener(string));
    }

    public Object get(int index) {
        Object o = this.opt(index);
        if (o == null) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public String join(String separator) {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONUtils.valueToString(this.elements.get(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.elements.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.elements.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection value) {
        this.put(JSONArray.fromCollection(value));
        return this;
    }

    public JSONArray put(double value) {
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        this.put(d);
        return this;
    }

    public JSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JSONArray put(int index, boolean value) {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index, Collection value) {
        this.put(index, new JSONArray(value));
        return this;
    }

    public JSONArray put(int index, double value) {
        this.put(index, new Double(value));
        return this;
    }

    public JSONArray put(int index, int value) {
        this.put(index, new Integer(value));
        return this;
    }

    public JSONArray put(int index, long value) {
        this.put(index, new Long(value));
        return this;
    }

    public JSONArray put(int index, Map value) {
        this.put(index, new JSONObject(value));
        return this;
    }

    public JSONArray put(int index, Object value) {
        JSONUtils.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.elements.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(JSONNull.getInstance());
            }
            this.put(value);
        }
        return this;
    }

    public JSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public JSONArray put(Map value) {
        this.put(new JSONObject(value));
        return this;
    }

    public JSONArray put(Object value) {
        this.elements.add(value);
        return this;
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JSONUtils.valueToString(this.elements.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.valueToString(this.elements.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.elements.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

