/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.BooleanMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BooleanArrayMorpher
extends AbstractArrayMorpher {
    private static final Class BOOLEAN_ARRAY_CLASS = array$Z == null ? (array$Z = BooleanArrayMorpher.class$("[Z")) : array$Z;
    private boolean defaultValue;
    static /* synthetic */ Class array$Z;

    public BooleanArrayMorpher() {
        super(false);
    }

    public BooleanArrayMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanArrayMorpher)) {
            return false;
        }
        BooleanArrayMorpher other = (BooleanArrayMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BOOLEAN_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (boolean[])array;
        }
        if (array.getClass().isArray()) {
            BooleanMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Boolean.TYPE, dimensions);
            BooleanMorpher booleanMorpher = morpher = this.isUseDefault() ? new BooleanMorpher(this.defaultValue) : new BooleanMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)) ? Boolean.TRUE : Boolean.FALSE);
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    public Class morphsTo() {
        return BOOLEAN_ARRAY_CLASS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

