/*
 * Decompiled with CFR 0.152.
 */
package com.jsontocsv.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.apache.wink.json4j.OrderedJSONObject;

public class JsonFlattener {
    public LinkedHashMap<String, String> parse(OrderedJSONObject jsonObject) {
        LinkedHashMap<String, String> flatJson = new LinkedHashMap<String, String>();
        this.flatten(jsonObject, flatJson, "");
        return flatJson;
    }

    public List<LinkedHashMap<String, String>> parseArray(JSONArray jsonArray) throws JSONException {
        ArrayList<LinkedHashMap<String, String>> flatJson = new ArrayList<LinkedHashMap<String, String>>();
        int length = jsonArray.length();
        int i = 0;
        while (i < length) {
            OrderedJSONObject jsonObject = (OrderedJSONObject)jsonArray.getJSONObject(i);
            LinkedHashMap<String, String> stringMap = this.parse(jsonObject);
            flatJson.add(stringMap);
            ++i;
        }
        return flatJson;
    }

    public List<LinkedHashMap<String, String>> parseJson(String json) throws Exception {
        List<LinkedHashMap<String, String>> flatJson = null;
        try {
            OrderedJSONObject jsonObject = new OrderedJSONObject(json);
            flatJson = new ArrayList<LinkedHashMap<String, String>>();
            flatJson.add(this.parse(jsonObject));
        }
        catch (JSONException je) {
            flatJson = this.handleAsArray(json);
        }
        return flatJson;
    }

    private List<LinkedHashMap<String, String>> handleAsArray(String json) throws Exception {
        List<LinkedHashMap<String, String>> flatJson = null;
        try {
            JSONArray jsonArray = new JSONArray(json);
            flatJson = this.parseArray(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flatJson;
    }

    private void flatten(JSONArray obj, LinkedHashMap<String, String> flatJson, String prefix) throws JSONException {
        int length = obj.length();
        int i = 0;
        while (i < length) {
            if (obj.get(i).getClass() == JSONArray.class) {
                JSONArray jsonArray = (JSONArray)obj.get(i);
                if (jsonArray.length() >= 1) {
                    this.flatten(jsonArray, flatJson, String.valueOf(prefix) + i);
                }
            } else if (obj.get(i).getClass() == JSONObject.class) {
                OrderedJSONObject jsonObject = (OrderedJSONObject)obj.get(i);
                this.flatten(jsonObject, flatJson, String.valueOf(prefix) + (i + 1));
            } else {
                String value = obj.getString(i);
                if (value != null) {
                    flatJson.put(String.valueOf(prefix) + (i + 1), value);
                }
            }
            ++i;
        }
    }

    private void flatten(OrderedJSONObject obj, LinkedHashMap<String, String> flatJson, String prefix) {
        Iterator iterator = obj.getOrder();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            try {
                String value = obj.getString(key);
                if (value == null || value.equals("null")) continue;
                flatJson.put(String.valueOf(prefix) + key, value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

