$(document).ready(function(){
	
	//$("#startTime").html(serverStartTime);
	
	google.load("visualization", "1", {packages:["corechart"]});
    google.setOnLoadCallback(drawChart);
    
    statusRequest = function(){
    	$.ajax({
			url: "/statusDetails",
			 method: "GET",
			//data: {},
			beforeSend : function(){
				//$( "#pagesContainer" ).addClass('page-loading');
			},
			complete : function(){
				//$( "#pagesContainer" ).removeClass('page-loading');
			},
			success : function(response){
				console.log("Success");
				console.log($.parseJSON(response));
				drawStatusCharts($.parseJSON(response));

			},
		});
    }
    statusRequest();
/*    
   var sawsStatus = '{"memory":{"memoryLimit":500,"memoryUsage":"60%","data":[{"limit":500,"used":15},{"limit":500,"used":50},{"limit":500,"used":100},{"limit":500,"used":80},{"limit":500,"used":200},{"limit":500,"used":100},{"limit":500,"used":75},{"limit":500,"used":300},{"limit":500,"used":150},{"limit":500,"used":250}]},"jobs":{"jobLimit":10,"numberOfJobs":"70%","data":[{"limit":20,"used":5},{"limit":20,"used":10},{"limit":20,"used":7},{"limit":20,"used":9},{"limit":20,"used":14},{"limit":20,"used":13},{"limit":20,"used":4},{"limit":20,"used":3},{"limit":20,"used":7},{"limit":20,"used":5}]},"dbConnections":{"connectionLimit":50,"openConnections":"25%","data":[{"limit":50,"used":10},{"limit":50,"used":30},{"limit":50,"used":50},{"limit":50,"used":40},{"limit":50,"used":20},{"limit":50,"used":45},{"limit":50,"used":25},{"limit":50,"used":20},{"limit":50,"used":10},{"limit":50,"used":30}]}}';
         sawsStatus = JSON.parse(sawsStatus);*/
    
	function drawChart(graphFor, graphData, chartId , title) {
		var data = new google.visualization.DataTable();
			data.addColumn('string', '');
			data.addColumn('number', 'Usage');
			data.addColumn('number', 'Limit');
			data.addColumn({type:'string', role:'annotation'});
			if(graphData){
				for(var i = 0; i < graphData.length; i++) {
					data.addRow(['' , graphData[i].used, graphData[i].limit,'']);
					if(graphFor === 'connection')
						$("#usedConnection").css({"height": graphData[i].usedPercent});
					if(graphFor === 'job')
						$("#numberOfjobs").css({"height": graphData[i].runingJobs});
				}	
			}
		
			var options = {
					title: title,
					titleTextStyle:{bold: false},
					vAxis: {minValue: 0},
					backgroundColor: "#F9F9F9"
			};
	
			var chart = new google.visualization.LineChart(document.getElementById(chartId));
			chart.draw(data, options);
	}

    function drawMemoryChart(graph){
    	if($("#memoryChart").length > 0) drawChart('memory', graph, 'memoryChart' , '');
    }
    function drawJobChart(graph){
    	if($("#jobsChart").length > 0) drawChart('job', graph, 'jobsChart' , '');
    }
    function drawDBConnectionChart(graph){
    	if($("#dbConnectionsChart").length > 0) drawChart('connection', graph, 'dbConnectionsChart','');
    }
    function drawStatusCharts(sawsStatus){
        drawMemoryChart(sawsStatus.memory.data);
        drawJobChart(sawsStatus.jobs.data);
        drawDBConnectionChart(sawsStatus.dbConnections.data);
        
        $("#memoryLimit").text(sawsStatus.memory.memoryLimit);
        $("#jobsLimit").text(sawsStatus.jobs.jobLimit);
        $("#connectionLimit").text(sawsStatus.dbConnections.connectionLimit);
        
        $("#usedMemory").css({"height":sawsStatus.memory.memoryUsage});
    }
    
    //drawStatusCharts(sawsStatus);
	$("#refresh").click(function(){
		$("a#status").trigger('click');
	});
	
	function confirmationDialog(){
		
		BootstrapDialog.confirmation('If you reboot SAWS, any rules/jobs which are in execution will be terminated. Are you sure you want to continue?',
				'Warning','Reboot', 'Cancel',
				function(result){
					if(result) {
						rebootRequest();
					} else {
						
					}
				});
	}
	
	function rebootRequest(){
		$.ajax({
			url: "/restart",
			 method: "POST",
			//data: {},
			beforeSend : function(){
				$( "#pagesContainer" ).addClass('page-loading');
			},
			complete : function(){
				setTimeout(function(){
					$( "#pagesContainer" ).removeClass('page-loading');
					//location.reload();
				}, 5000);
				console.log(" complete ... ")
			},
			success : function(response){
				console.log("Success");
				console.log(response);
				setTimeout(function(){
					$( "#pagesContainer" ).removeClass('page-loading');
					//location.reload();
				}, 5000);
			},
			error : function(){
				console.log(" error ... ")
				setTimeout(function(){
					$( "#pagesContainer" ).removeClass('page-loading');
					//location.reload();
				}, 5000);
				
			}
		});
	}
    
    $("#reboot").on('click', function(){
    	confirmationDialog();
    });
        
    statusRequest = function(){
    	$.ajax({
			url: "/statusDetails",
			 method: "GET",
			//data: {},
			beforeSend : function(){
				//$( "#pagesContainer" ).addClass('page-loading');
			},
			complete : function(){
				//$( "#pagesContainer" ).removeClass('page-loading');
			},
			success : function(response){
				var statusJson = $.parseJSON(response)
				drawStatusCharts(statusJson);
				$("#startTime").html(statusJson.serverStartTime);

			},
		});
    }
    

    setInterval(function(){ statusRequest()}, 1000);
    
});