$(document).ready(function(){
	
	$.validator.addMethod(
	        "regex",
	        function(value, element, regexp) {
	            var re = new RegExp(regexp);
	            return this.optional(element) || re.test(value);
	        },
	        "Please check your input."
	); 
	$("#sawsConfigurationForm").validate({
		rules: {
			maxJobs: {
				required : true,
				regex: /^[0-9]*$/,
				range:[1,10]
			},
			maxDatabaseConnAllowed: {
				required : true,
				regex: /^[0-9]*$/,
				range: [1, 50]			
			},
			SawsKey: {
				required : true			
			},

		},
		messages : {		
			maxJobs : {
				required : "This is a required field",
				regex : "Enter numeric value (1-10)",
				range: "Enter numeric value (1-10)"
			},		
			maxDatabaseConnAllowed : {
				required : "This is a required field"	,
				regex : "Enter numeric value (1-50)",
				range: "Enter numeric value (1-50)"
			},
			SawsKey: {
				required : "This is a required field"			
			},

		},
		errorElement: "div",
		wrapper: "div",
		errorPlacement: function(error, element) {
			var position = null;
	        var width = null;
	        var errorElement = null;
	        var errorElementId = null;
	        if(errorElementId != null){
	        	errorElement = $("#"+errorElementId);
	        	error.attr('error-for', errorElementId);
	        }
	        errorElement = element;
	        position = errorElement.position();
	    	width = errorElement.width();
			error.insertAfter(errorElement.parent());
	    	//error.css('left', position.left + width);
	    	//error.css('top', position.top);
	        error.addClass('error-message-overlay col-sm-3');
		}
	});		
	
	$("#maxDatabaseConnAllowed").val(sawsConfiguration.maxDatabaseConnAllowed);
	$("#SawsKey").val(sawsConfiguration.apiKey);
	$("#maxJobs").val(sawsConfiguration.poolSize);
	if(sawsConfiguration.logFilePath){
		$("#logFilePath").val(sawsConfiguration.logFilePath.split('/').join('\\'));
	}
	$("#logLevel").val(sawsConfiguration.logLevel);
	
	
	$("#saveSAWSConf").click(function(){
		if($("#sawsConfigurationForm").valid()){
			$( "#pagesContainer" ).addClass('page-loading');
			updateSawsConfig();
		}
	
	});
	
	$("#resetSAWSConf").click(function(){
		$( "#pagesContainer" ).addClass('page-loading');
		$("#maxDatabaseConnAllowed").val(20);
		$("#maxJobs").val(10);
		$("#logFilePath").val('');
		updateSawsConfig();

	});
	
	var updateSawsConfig = function(){
		$.post("/updateSAWSConfiguration", $("#sawsConfigurationForm").serialize()).then( success, error );
		
		function success(){
			setTimeout(function(){		
				$( "#pagesContainer" ).removeClass('page-loading');
			}, 250);			
		}
		
		function error(){
			$( "#pagesContainer" ).removeClass('page-loading');
		}
	}
});