/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvResources;

public class ZipFileTableReader
implements TableReader {
    private String zipFilename;
    private ZipFile zipFile;
    private String fileExtension;
    private String charset;

    public ZipFileTableReader(String string, String string2) throws IOException {
        this.zipFilename = string;
        this.zipFile = new ZipFile(string);
        this.charset = string2;
    }

    public void setExtension(String string) {
        this.fileExtension = string;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    @Override
    public Reader getReader(Statement statement, String string) throws SQLException {
        try {
            ZipEntry zipEntry = this.zipFile.getEntry(string + this.fileExtension);
            if (zipEntry == null) {
                throw new SQLException(CsvResources.getString("tableNotFound") + ": " + string);
            }
            InputStreamReader inputStreamReader = this.charset != null ? new InputStreamReader(this.zipFile.getInputStream(zipEntry), this.charset) : new InputStreamReader(this.zipFile.getInputStream(zipEntry));
            return inputStreamReader;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    @Override
    public List<String> getTableNames(Connection connection) throws SQLException {
        Vector<String> vector = new Vector<String>();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().getName();
            if (string.endsWith(this.fileExtension)) {
                string = string.substring(0, string.length() - this.fileExtension.length());
            }
            vector.add(string);
        }
        return vector;
    }
}

