/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.ExpressionParser;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.OrderByEntry;
import org.relique.jdbc.csv.ParseException;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedStatement;
import org.relique.jdbc.csv.QueryEnvEntry;

public class SqlParser {
    private String tableName;
    private String tableAlias;
    private ParsedExpression whereClause;
    private List<Object[]> environment;
    private List<Expression> groupByColumns;
    private ParsedExpression havingClause;
    private List<Object[]> orderByColumns;
    private int limit;
    private int offset;
    private boolean isDistinct;

    public void setPlaceholdersValues(Object[] objectArray) {
        if (this.whereClause != null) {
            this.whereClause.setPlaceholdersValues(objectArray);
        }
    }

    public int getPlaceholdersCount() {
        if (this.whereClause != null) {
            return this.whereClause.getPlaceholdersCount();
        }
        return 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public List<Object[]> getColumns() {
        return this.environment;
    }

    public void parse(String string) throws SQLException, ParseException {
        this.tableName = null;
        this.tableAlias = null;
        string = string + "\n";
        ExpressionParser expressionParser = new ExpressionParser(new StringReader(string));
        ParsedStatement parsedStatement = expressionParser.parseSingleStatement();
        this.setParsedStatement(parsedStatement);
    }

    public void setParsedStatement(ParsedStatement parsedStatement) throws SQLException {
        Object object;
        Iterator<ParsedExpression> iterator;
        this.isDistinct = parsedStatement.isDistinct;
        if (!(parsedStatement.whereClause == null || parsedStatement.whereClause.content instanceof LogicalExpression && parsedStatement.whereClause.content.isValid())) {
            throw new SQLException(CsvResources.getString("whereNotLogical"));
        }
        this.whereClause = parsedStatement.whereClause;
        this.limit = parsedStatement.limit;
        this.offset = parsedStatement.offset;
        if (parsedStatement.tableEntries.size() > 1) {
            throw new SQLException(CsvResources.getString("joinNotSupported"));
        }
        if (parsedStatement.tableEntries.size() > 0) {
            this.tableName = parsedStatement.tableEntries.get(0).getTableName();
            this.tableAlias = parsedStatement.tableEntries.get(0).getTableAlias();
        }
        this.environment = new ArrayList<Object[]>();
        for (ParsedExpression iterator22 : parsedStatement.queryEntries) {
            if (iterator22 == null) continue;
            iterator = (QueryEnvEntry)iterator22.content;
            if (((QueryEnvEntry)((Object)iterator)).expression instanceof LogicalExpression || !((QueryEnvEntry)((Object)iterator)).expression.isValid()) {
                throw new SQLException("invalidQueryExpression");
            }
            object = ((QueryEnvEntry)((Object)iterator)).key;
            if (this.tableAlias != null && ((String)object).startsWith(this.tableAlias + ".")) {
                object = ((String)object).substring(this.tableAlias.length() + 1);
            }
            if (this.tableName != null && ((String)object).startsWith(this.tableName.toUpperCase() + ".")) {
                object = ((String)object).substring(this.tableName.length() + 1);
            }
            this.environment.add(new Object[]{object, ((QueryEnvEntry)((Object)iterator)).expression});
        }
        if (this.environment.isEmpty()) {
            throw new SQLException(CsvResources.getString("noColumnsSelected"));
        }
        Iterator<ParsedExpression> iterator2 = parsedStatement.groupByEntries.iterator();
        if (iterator2.hasNext()) {
            this.groupByColumns = new ArrayList<Expression>();
        }
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            this.groupByColumns.add(((ParsedExpression)((Object)iterator)).content);
        }
        if (parsedStatement.havingClause != null && !(parsedStatement.havingClause.content instanceof LogicalExpression) && parsedStatement.havingClause.content.isValid()) {
            throw new SQLException(CsvResources.getString("havingNotLogical"));
        }
        this.havingClause = parsedStatement.havingClause;
        iterator = parsedStatement.orderByEntries.iterator();
        if (iterator.hasNext()) {
            this.orderByColumns = new ArrayList<Object[]>();
        }
        while (iterator.hasNext()) {
            object = (ParsedExpression)iterator.next();
            OrderByEntry orderByEntry = (OrderByEntry)((ParsedExpression)object).content;
            int n = orderByEntry.order.equalsIgnoreCase("ASC") ? 1 : -1;
            this.orderByColumns.add(new Object[]{n, orderByEntry.expression});
        }
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.environment.size()];
        for (int i = 0; i < this.environment.size(); ++i) {
            Object[] objectArray = this.environment.get(i);
            stringArray[i] = (String)objectArray[0];
        }
        return stringArray;
    }

    public LogicalExpression getWhereClause() {
        return this.whereClause;
    }

    public List<Expression> getGroupByColumns() {
        return this.groupByColumns;
    }

    public LogicalExpression getHavingClause() {
        return this.havingClause;
    }

    public List<Object[]> getOrderByColumns() {
        return this.orderByColumns;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getAlias(int n) {
        Object[] objectArray = this.environment.get(n);
        return (String)objectArray[0];
    }

    public Expression getExpression(int n) {
        Object[] objectArray = this.environment.get(n);
        return (Expression)objectArray[1];
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

