/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.RelopExpression;

class SimpleCaseExpression
extends Expression {
    private Expression caseExpression;
    private List<Expression> switches;
    private List<Expression> values;
    private Expression elseExpression;

    public SimpleCaseExpression(Expression expression, List<Expression> list, List<Expression> list2, Expression expression2) {
        this.caseExpression = expression;
        this.switches = list;
        this.values = list2;
        this.elseExpression = expression2;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = this.caseExpression.eval(map);
        for (int i = 0; i < this.switches.size(); ++i) {
            Expression expression = this.switches.get(i);
            Object object2 = expression.eval(map);
            Integer n = RelopExpression.compare((Comparable)object, (Comparable)object2, map);
            if (n != 0) continue;
            return this.values.get(i).eval(map);
        }
        if (this.elseExpression != null) {
            return this.elseExpression.eval(map);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CASE ");
        stringBuilder.append(this.caseExpression.toString());
        for (int i = 0; i < this.switches.size(); ++i) {
            Expression expression = this.switches.get(i);
            stringBuilder.append(" WHEN ").append(expression.toString()).append(" THEN ").append(this.values.get(i));
        }
        if (this.elseExpression != null) {
            stringBuilder.append(" ELSE ").append(this.elseExpression.toString());
        }
        stringBuilder.append(" END");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.caseExpression.usedColumns());
        Iterator<Expression> iterator = this.switches.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().usedColumns());
        }
        iterator = this.values.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().usedColumns());
        }
        if (this.elseExpression != null) {
            linkedList.addAll(this.elseExpression.usedColumns());
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        Iterator<Expression> iterator = this.switches.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().aggregateFunctions());
        }
        iterator = this.values.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().aggregateFunctions());
        }
        if (this.elseExpression != null) {
            linkedList.addAll(this.elseExpression.aggregateFunctions());
        }
        return linkedList;
    }
}

