/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.StringConverter;

class SQLUserFunction
extends Expression {
    String name;
    List<Expression> expressions;

    public SQLUserFunction(String string, List<Expression> list) {
        this.name = string;
        this.expressions = list;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object;
        Object object2;
        Object object3 = null;
        CsvStatement csvStatement = (CsvStatement)map.get("@STATEMENT");
        CsvConnection csvConnection = (CsvConnection)csvStatement.getConnection();
        Method method = csvConnection.getSqlFunctions().get(this.name);
        if (method == null) {
            throw new SQLException(CsvResources.getString("noFunction") + ": " + this.name);
        }
        Class<?>[] classArray = method.getParameterTypes();
        StringConverter stringConverter = (StringConverter)map.get("@STRINGCONVERTER");
        boolean bl = method.isVarArgs();
        Object object4 = null;
        if (bl && this.expressions.size() >= classArray.length) {
            object2 = classArray[classArray.length - 1].getSimpleName();
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            object = this.getParameterClass(stringConverter, (String)object2);
            object4 = Array.newInstance(object, this.expressions.size() - classArray.length + 1);
        } else if (classArray.length != this.expressions.size()) {
            throw new SQLException(CsvResources.getString("functionArgCount") + ": " + this.name);
        }
        object2 = new Object[classArray.length];
        object = null;
        try {
            int n = 0;
            int n2 = 0;
            for (Expression expression : this.expressions) {
                Class<?> clazz;
                Object object5 = expression.eval(map);
                if (object5 == null) continue;
                object = classArray[n].getSimpleName();
                if (bl && n >= classArray.length - 1) {
                    clazz = this.getParameterClass(stringConverter, (String)(object = ((String)object).substring(0, ((String)object).length() - 2)));
                    if (clazz != Object.class) {
                        if (clazz == CharSequence.class) {
                            object5 = object5.toString();
                        } else if (!clazz.equals(object5.getClass())) {
                            object5 = stringConverter.convert((String)object, object5.toString());
                        }
                    }
                    Array.set(object4, n2++, object5);
                    continue;
                }
                clazz = this.getParameterClass(stringConverter, (String)object);
                if (clazz != Object.class) {
                    if (clazz == CharSequence.class) {
                        object5 = object5.toString();
                    } else if (!clazz.equals(object5.getClass())) {
                        object5 = stringConverter.convert((String)object, object5.toString());
                    }
                }
                object2[n++] = object5;
            }
            if (bl) {
                object2[((Object)object2).length - 1] = object4;
            }
            object3 = method.invoke(null, (Object[])object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(this.getInvokeString((Object[])object2), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(this.name + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(this.getInvokeString((Object[])object2), invocationTargetException);
        }
        return object3;
    }

    private Class<?> getParameterClass(StringConverter stringConverter, String string) throws SQLException {
        Class clazz = null;
        clazz = string.equals(Object.class.getSimpleName()) ? Object.class : (string.equals(CharSequence.class.getSimpleName()) ? CharSequence.class : stringConverter.forSQLName(string));
        if (clazz == null) {
            throw new SQLException(CsvResources.getString("functionArgClass") + ": " + string);
        }
        return clazz;
    }

    public String getInvokeString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        String string = "";
        for (Object object : objectArray) {
            stringBuilder.append(string);
            if (object != null) {
                stringBuilder.append(object.toString());
            } else {
                stringBuilder.append("null");
            }
            string = ",";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        String string = "";
        for (Expression expression : this.expressions) {
            stringBuilder.append(string);
            stringBuilder.append(expression.toString());
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Expression expression : this.expressions) {
            linkedList.addAll(expression.usedColumns());
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        for (Expression expression : this.expressions) {
            linkedList.addAll(expression.aggregateFunctions());
        }
        return linkedList;
    }
}

