/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLMinFunction
extends AggregateFunction {
    boolean isDistinct;
    Expression expression;
    Object min = null;

    public SQLMinFunction(boolean bl, Expression expression) {
        this.isDistinct = bl;
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = map.get("@GROUPROWS");
        if (object != null) {
            List list = (List)object;
            Object object2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = this.expression.eval((Map)list.get(i));
                if (object == null || object2 != null && ((Comparable)object2).compareTo(object) <= 0) continue;
                object2 = object;
            }
            return object2;
        }
        return this.min;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MIN(");
        if (this.isDistinct) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.expression);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns() {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns());
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.add(this);
        return linkedList;
    }

    @Override
    public void processRow(Map<String, Object> map) throws SQLException {
        Object object = this.expression.eval(map);
        if (object != null && (this.min == null || ((Comparable)this.min).compareTo(object) > 0)) {
            this.min = object;
        }
    }
}

