/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.StringConverter;

class RelopExpression
extends LogicalExpression {
    String op;
    Expression left;
    Expression right;
    boolean isValid;

    public RelopExpression(String string, Expression expression, Expression expression2) {
        this.isValid = !(expression instanceof LogicalExpression) && !(expression2 instanceof LogicalExpression);
        this.op = string;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public boolean isTrue(Map<String, Object> map) throws SQLException {
        Comparable comparable;
        boolean bl = false;
        Comparable comparable2 = (Comparable)this.left.eval(map);
        Integer n = RelopExpression.compare(comparable2, comparable = (Comparable)this.right.eval(map), map);
        if (n != null) {
            int n2 = n;
            if (comparable2 != null && comparable != null) {
                if (this.op.equals("=")) {
                    bl = n2 == 0;
                } else if (this.op.equals("<>") || this.op.equals("!=")) {
                    bl = n2 != 0;
                } else if (this.op.equals(">")) {
                    bl = n2 > 0;
                } else if (this.op.equals("<")) {
                    bl = n2 < 0;
                } else if (this.op.equals("<=") || this.op.equals("=<")) {
                    bl = n2 <= 0;
                } else if (this.op.equals(">=") || this.op.equals("=>")) {
                    bl = n2 >= 0;
                }
            }
        }
        return bl;
    }

    public static Integer compare(Comparable comparable, Comparable comparable2, Map<String, Object> map) throws SQLException {
        Integer n = null;
        try {
            if (comparable != null && comparable2 != null) {
                n = new Integer(comparable.compareTo(comparable2));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            if (n == null && comparable != null && comparable2 != null) {
                if (comparable instanceof Date) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Date date = stringConverter.parseDate(comparable2.toString());
                    if (date != null) {
                        n = new Integer(comparable.compareTo(date));
                    }
                } else if (comparable2 instanceof Date) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Date date = stringConverter.parseDate(comparable.toString());
                    if (date != null) {
                        n = new Integer(date.compareTo((Date)comparable2));
                    }
                } else if (comparable instanceof Time) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Time time = stringConverter.parseTime(comparable2.toString());
                    if (time != null) {
                        n = new Integer(comparable.compareTo(time));
                    }
                } else if (comparable2 instanceof Time) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Time time = stringConverter.parseTime(comparable.toString());
                    if (time != null) {
                        n = new Integer(time.compareTo((Time)comparable2));
                    }
                } else if (comparable instanceof Timestamp) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Timestamp timestamp = stringConverter.parseTimestamp(comparable2.toString());
                    if (timestamp != null) {
                        n = new Integer(comparable.compareTo(timestamp));
                    }
                } else if (comparable2 instanceof Timestamp) {
                    ColumnName columnName = new ColumnName("@STRINGCONVERTER");
                    StringConverter stringConverter = (StringConverter)((Expression)columnName).eval(map);
                    Timestamp timestamp = stringConverter.parseTimestamp(comparable.toString());
                    if (timestamp != null) {
                        n = new Integer(timestamp.compareTo((Timestamp)comparable2));
                    }
                } else if (comparable instanceof Boolean) {
                    Boolean bl = (Boolean)comparable;
                    Boolean bl2 = Boolean.valueOf(comparable2.toString());
                    n = bl.equals(bl2) ? Integer.valueOf(0) : (!bl.booleanValue() ? Integer.valueOf(-1) : Integer.valueOf(1));
                } else {
                    Double d = new Double(((Number)((Object)comparable)).toString());
                    Double d2 = new Double(((Number)((Object)comparable2)).toString());
                    n = new Integer(d.compareTo(d2));
                }
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String toString() {
        return this.op + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.left.usedColumns());
        linkedList.addAll(this.right.usedColumns());
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.left.aggregateFunctions());
        linkedList.addAll(this.right.aggregateFunctions());
        return linkedList;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

