/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LikePattern;
import org.relique.jdbc.csv.LogicalExpression;

class LikeExpression
extends LogicalExpression {
    Expression arg1;
    Expression arg2;
    Expression escapeArg;

    public LikeExpression(Expression expression, Expression expression2, Expression expression3) {
        this.arg1 = expression;
        this.arg2 = expression2;
        this.escapeArg = expression3;
    }

    @Override
    public boolean isTrue(Map<String, Object> map) throws SQLException {
        Object object = this.arg1.eval(map);
        Object object2 = this.arg2.eval(map);
        String string = "\\";
        if (this.escapeArg != null) {
            String string2;
            string = "";
            Object object3 = this.escapeArg.eval(map);
            if (object3 != null && (string2 = object3.toString()).length() > 0) {
                string = string2.substring(0, 1);
            }
        }
        boolean bl = false;
        if (object != null && object2 != null) {
            bl = LikePattern.matches(object2.toString(), string, object.toString());
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("L ");
        stringBuilder.append(this.arg1);
        stringBuilder.append(" ");
        stringBuilder.append(this.arg2);
        if (this.escapeArg != null) {
            stringBuilder.append(" ESCAPE ");
            stringBuilder.append(this.escapeArg);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.arg1.usedColumns());
        linkedList.addAll(this.arg2.usedColumns());
        if (this.escapeArg != null) {
            linkedList.addAll(this.escapeArg.usedColumns());
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.arg1.aggregateFunctions());
        linkedList.addAll(this.arg2.aggregateFunctions());
        if (this.escapeArg != null) {
            linkedList.addAll(this.escapeArg.aggregateFunctions());
        }
        return linkedList;
    }
}

