/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;

class InExpression
extends LogicalExpression {
    Expression obj;
    List<Expression> inList;

    public InExpression(Expression expression, List<Expression> list) {
        this.obj = expression;
        this.inList = list;
    }

    @Override
    public boolean isTrue(Map<String, Object> map) throws SQLException {
        Comparable comparable = (Comparable)this.obj.eval(map);
        for (Expression expression : this.inList) {
            Comparable comparable2 = (Comparable)expression.eval(map);
            Integer n = RelopExpression.compare(comparable, comparable2, map);
            if (n == null || n != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IN ");
        stringBuilder.append(this.obj.toString());
        stringBuilder.append(" (");
        String string = "";
        for (Expression expression : this.inList) {
            stringBuilder.append(string);
            stringBuilder.append(expression.toString());
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.obj.usedColumns());
        for (Expression expression : this.inList) {
            linkedList.addAll(expression.usedColumns());
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        for (Expression expression : this.inList) {
            linkedList.addAll(expression.aggregateFunctions());
        }
        return linkedList;
    }
}

