/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CsvResultSetMetaData
implements ResultSetMetaData {
    private String[] columnNames;
    private String[] columnLabels;
    private String[] columnTypes;
    private int[] columnDisplaySizes;
    private String tableName;
    private Map<String, Integer> typeNameToTypeCode = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -8819579540085202365L;
        {
            this.put("String", new Integer(12));
            this.put("Boolean", new Integer(16));
            this.put("Byte", new Integer(-6));
            this.put("Short", new Integer(5));
            this.put("Int", new Integer(4));
            this.put("Integer", new Integer(4));
            this.put("Long", new Integer(-5));
            this.put("Float", new Integer(6));
            this.put("Double", new Integer(8));
            this.put("BigDecimal", new Integer(3));
            this.put("Date", new Integer(91));
            this.put("Time", new Integer(92));
            this.put("Timestamp", new Integer(93));
            this.put("Blob", new Integer(2004));
            this.put("Clob", new Integer(2005));
            this.put("expression", new Integer(2004));
        }
    };

    CsvResultSetMetaData(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray) {
        this.tableName = string;
        this.columnNames = stringArray;
        this.columnLabels = stringArray2;
        this.columnTypes = stringArray3;
        this.columnDisplaySizes = nArray;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return this.columnTypes[n - 1];
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnTypes.length;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.columnDisplaySizes[n - 1];
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.columnLabels[n - 1];
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.columnNames[n - 1];
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.tableName;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        String string = this.getColumnTypeName(n);
        Integer n2 = this.typeNameToTypeCode.get(string);
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.columnTypes[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

