/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvResources;

public class CsvRawReader {
    private LineNumberReader input;
    private String tableName;
    private String tableAlias;
    private String[] columnNames;
    private String[] fieldValues;
    private String firstLineBuffer = null;
    private String separator = ",";
    private String headerLine = "";
    private boolean suppressHeaders = false;
    private boolean isHeaderFixedWidth = true;
    private Character quoteChar = Character.valueOf('\"');
    private boolean trimValues = true;
    private String comment = null;
    private boolean ignoreUnparseableLines;
    private String quoteStyle;
    private ArrayList<int[]> fixedWidthColumns;

    public CsvRawReader(LineNumberReader lineNumberReader, String string, String string2, String string3, boolean bl, boolean bl2, Character c, String string4, String string5, boolean bl3, boolean bl4, int n, boolean bl5, boolean bl6, int n2, String string6, ArrayList<int[]> arrayList) throws IOException, SQLException {
        int n3;
        this.tableName = string;
        this.tableAlias = string2;
        this.separator = string3;
        this.suppressHeaders = bl;
        this.isHeaderFixedWidth = bl2;
        this.quoteChar = c;
        this.comment = string4;
        this.headerLine = string5;
        this.trimValues = bl4;
        this.input = lineNumberReader;
        this.ignoreUnparseableLines = bl5;
        this.quoteStyle = string6;
        this.fixedWidthColumns = arrayList;
        for (n3 = 0; n3 < n; ++n3) {
            lineNumberReader.readLine();
        }
        if (this.suppressHeaders) {
            if (this.headerLine != null) {
                this.columnNames = this.parseHeaderLine(this.headerLine, bl3);
            } else {
                this.firstLineBuffer = this.getNextDataLine();
                String[] stringArray = this.parseHeaderLine(this.firstLineBuffer, bl4);
                this.columnNames = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.columnNames[i] = "COLUMN" + String.valueOf(i + 1);
                }
                stringArray = null;
            }
        } else {
            String string7 = this.getNextDataLine();
            this.columnNames = this.parseHeaderLine(string7, bl3);
            if (bl6) {
                this.fixDefectiveHeaders();
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.columnNames.length; ++i) {
                hashSet.add(this.columnNames[i]);
            }
            if (hashSet.size() != this.columnNames.length) {
                throw new SQLException(CsvResources.getString("duplicateColumns"));
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            lineNumberReader.readLine();
        }
    }

    private void fixDefectiveHeaders() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i].length() != 0) continue;
            this.columnNames[i] = "COLUMN" + String.valueOf(i + 1);
        }
    }

    public boolean next() throws SQLException {
        this.fieldValues = new String[this.columnNames.length];
        String string = null;
        try {
            if (this.suppressHeaders && this.firstLineBuffer != null) {
                string = this.firstLineBuffer;
                this.firstLineBuffer = null;
            } else {
                string = this.getNextDataLine();
            }
            if (string == null) {
                this.input.close();
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.toString());
        }
        this.fieldValues = this.parseLine(string, this.trimValues);
        return true;
    }

    public void close() {
        try {
            this.input.close();
            this.firstLineBuffer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNextDataLine() throws IOException {
        String string = this.input.readLine();
        if (this.comment != null && string != null) {
            while (string != null && (string.length() == 0 || string.startsWith(this.comment))) {
                string = this.input.readLine();
            }
            this.comment = null;
        }
        if (!this.ignoreUnparseableLines || string == null) return string;
        try {
            do {
                int n = this.parseLine(string, true).length;
                if (this.columnNames != null && this.columnNames.length == n || this.columnNames == null && n != 1) return string;
                CsvDriver.writeLog("Ignoring row " + this.input.getLineNumber() + " Line=" + string);
            } while ((string = this.input.readLine()) != null);
            return string;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return string;
    }

    public int getLineNumber() {
        return this.input.getLineNumber();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnSizes() {
        int[] nArray;
        if (this.fixedWidthColumns != null) {
            nArray = new int[this.fixedWidthColumns.size()];
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray2 = this.fixedWidthColumns.get(i);
                nArray[i] = nArray2[1] - nArray2[0] + 1;
            }
        } else {
            nArray = new int[this.columnNames.length];
            Arrays.fill(nArray, 20);
        }
        return nArray;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String[] getFieldValues() {
        return this.fieldValues;
    }

    public String getField(int n) throws SQLException {
        if (n >= this.fieldValues.length) {
            return null;
        }
        String string = this.fieldValues[n];
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    protected String[] parseLine(String string, boolean bl) throws SQLException {
        String[] stringArray = this.fixedWidthColumns != null ? this.parseFixedLine(string, bl) : this.parseCsvLine(string, bl);
        return stringArray;
    }

    private String[] parseHeaderLine(String string, boolean bl) throws SQLException {
        String[] stringArray = this.fixedWidthColumns != null && this.isHeaderFixedWidth ? this.parseFixedLine(string, bl) : this.parseCsvLine(string, bl);
        return stringArray;
    }

    private String[] parseFixedLine(String string, boolean bl) throws SQLException {
        String[] stringArray = new String[this.fixedWidthColumns.size()];
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int[] nArray = this.fixedWidthColumns.get(i);
            stringArray[i] = nArray[0] >= string.length() ? "" : (nArray[1] >= string.length() ? string.substring(nArray[0], string.length()) : string.substring(nArray[0], nArray[1] + 1));
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    private String rtrim(String string) {
        int n;
        int n2;
        for (n2 = n = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        if (n2 == n) {
            return string;
        }
        return string.substring(0, n2);
    }

    private boolean isQuoteChar(char c) {
        return this.quoteChar != null && c == this.quoteChar.charValue();
    }

    private String[] parseCsvLine(String string, boolean bl) throws SQLException {
        Vector<String> vector = new Vector<String>();
        boolean bl2 = false;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(32);
        String string2 = string;
        int n2 = 0;
        boolean bl3 = false;
        while (!bl3) {
            string = string + this.separator;
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c;
                char c2 = string.charAt(n2);
                if (stringBuilder.length() == 0 && this.isQuoteChar(c2) && !bl2) {
                    bl2 = true;
                    n = this.input.getLineNumber();
                    continue;
                }
                if (c2 == '\\' && "C".equals(this.quoteStyle)) {
                    c = string.charAt(n2 + 1);
                    stringBuilder.append(c);
                    ++n2;
                    continue;
                }
                if (this.isQuoteChar(c2)) {
                    c = string.charAt(n2 + 1);
                    if (!bl2) {
                        stringBuilder.append(this.quoteChar.charValue());
                        continue;
                    }
                    if (this.isQuoteChar(c)) {
                        stringBuilder.append(this.quoteChar.charValue());
                        if (!"SQL".equals(this.quoteStyle)) continue;
                        ++n2;
                        continue;
                    }
                    while (bl && !this.atSeparator(string, n2 + 1) && Character.isWhitespace(c) && n2 + 2 < string.length()) {
                        c = string.charAt(n2 + 2);
                        ++n2;
                    }
                    if (!this.atSeparator(string, n2 + 1)) {
                        throw new SQLException(CsvResources.getString("expectedSeparator") + ": " + this.input.getLineNumber() + " " + (n2 + 1) + ": " + string2);
                    }
                    vector.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    bl2 = false;
                    n2 += this.separator.length();
                    continue;
                }
                if (this.atSeparator(string, n2)) {
                    if (bl2) {
                        stringBuilder.append(c2);
                        continue;
                    }
                    if (bl) {
                        vector.add(this.rtrim(stringBuilder.toString()));
                    } else {
                        vector.add(stringBuilder.toString());
                    }
                    stringBuilder.setLength(0);
                    if (this.separator.length() <= 1) continue;
                    n2 += this.separator.length() - 1;
                    continue;
                }
                if (bl && Character.isWhitespace(c2) && stringBuilder.length() == 0 && !bl2) continue;
                stringBuilder.append(c2);
            }
            if (bl2) {
                stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
                try {
                    String string3 = this.input.readLine();
                    if (string3 == null) {
                        throw new SQLException(CsvResources.getString("eofInQuotes") + ": " + n);
                    }
                    string = "\n" + string3;
                    if (string2 != this.firstLineBuffer) continue;
                    this.firstLineBuffer = this.firstLineBuffer + "\n" + string3;
                    continue;
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
            bl3 = true;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean atSeparator(String string, int n) {
        boolean bl = this.separator.length() == 1 ? string.charAt(n) == this.separator.charAt(0) : string.regionMatches(n, this.separator, 0, this.separator.length());
        return bl;
    }
}

