/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;

public class CsvMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        Properties properties = null;
        int n = 0;
        try {
            AutoCloseable autoCloseable;
            Class.forName("org.relique.jdbc.csv.CsvDriver");
            int n2 = 0;
            if (n2 + 1 < stringArray.length && stringArray[n2].equals("-p")) {
                properties = new Properties();
                autoCloseable = new FileReader(stringArray[n2 + 1]);
                try {
                    properties.load((Reader)autoCloseable);
                }
                finally {
                    ((Reader)autoCloseable).close();
                }
                n2 += 2;
            } else if (n2 < stringArray.length && stringArray[n2].equals("-h")) {
                n2 = stringArray.length;
            } else if (n2 < stringArray.length && stringArray[n2].startsWith("-")) {
                System.err.println(CsvResources.getString("unknownCommandLine") + ": " + stringArray[n2]);
                System.err.println();
                n2 = stringArray.length;
            }
            if (n2 < stringArray.length) {
                boolean bl;
                BufferedReader bufferedReader;
                connection = properties != null ? DriverManager.getConnection(stringArray[n2], properties) : DriverManager.getConnection(stringArray[n2]);
                autoCloseable = (CsvStatement)connection.createStatement();
                if (++n2 == stringArray.length) {
                    bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    bl = true;
                } else {
                    bufferedReader = new BufferedReader(new FileReader(stringArray[n2]));
                    bl = false;
                    ++n2;
                }
                boolean bl2 = !((CsvConnection)connection).isSuppressHeaders();
                do {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    if (!bl) {
                        bufferedReader.close();
                    }
                    bufferedReader = null;
                    if (((CsvStatement)autoCloseable).execute(stringBuilder.toString())) {
                        ResultSet resultSet = ((CsvStatement)autoCloseable).getResultSet();
                        CsvDriver.writeToCsv(resultSet, System.out, bl2);
                        bl2 = false;
                        while (((CsvStatement)autoCloseable).getMoreResults()) {
                            resultSet = ((CsvStatement)autoCloseable).getResultSet();
                            CsvDriver.writeToCsv(resultSet, System.out, bl2);
                        }
                    }
                    if (n2 >= stringArray.length) continue;
                    bufferedReader = new BufferedReader(new FileReader(stringArray[n2]));
                    ++n2;
                } while (bufferedReader != null);
            } else {
                System.err.println(CsvResources.getString("usage"));
                n = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.exit(n);
    }
}

