/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Properties;
import java.util.logging.Logger;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSet;
import org.relique.jdbc.csv.ZipFileTableReader;

public class CsvDriver
implements Driver {
    public static final String DEFAULT_EXTENSION = ".csv";
    public static final String DEFAULT_SEPARATOR = ",";
    public static final char DEFAULT_QUOTECHAR = '\"';
    public static final String DEFAULT_HEADERLINE = null;
    public static final boolean DEFAULT_SUPPRESS = false;
    public static final boolean DEFAULT_IS_HEADER_FIXED_WIDTH = true;
    public static final boolean DEFAULT_TRIM_HEADERS = true;
    public static final boolean DEFAULT_TRIM_VALUES = false;
    public static final String DEFAULT_COLUMN_TYPES = "String";
    public static final boolean DEFAULT_INDEXED_FILES = false;
    public static final String DEFAULT_TIMESTAMP_FORMAT = null;
    public static final String DEFAULT_DATE_FORMAT = "YYYY-MM-DD";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_COMMENT_CHAR = null;
    public static final String DEFAULT_SKIP_LEADING_LINES = null;
    public static final String DEFAULT_IGNORE_UNPARSEABLE_LINES = "False";
    public static final String DEFAULT_FILE_TAIL_PREPEND = "False";
    public static final String DEFAULT_DEFECTIVE_HEADERS = "False";
    public static final String DEFAULT_SKIP_LEADING_DATA_LINES = "0";
    public static final String FILE_EXTENSION = "fileExtension";
    public static final String SEPARATOR = "separator";
    public static final String QUOTECHAR = "quotechar";
    public static final String HEADERLINE = "headerline";
    public static final String SUPPRESS_HEADERS = "suppressHeaders";
    public static final String IS_HEADER_FIXED_WIDTH = "isHeaderFixedWidth";
    public static final String TRIM_HEADERS = "trimHeaders";
    public static final String TRIM_VALUES = "trimValues";
    public static final String COLUMN_TYPES = "columnTypes";
    public static final String INDEXED_FILES = "indexedFiles";
    public static final String TIMESTAMP_FORMAT = "timestampFormat";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String TIME_FORMAT = "timeFormat";
    public static final String LOCALE = "locale";
    public static final String COMMENT_CHAR = "commentChar";
    public static final String SKIP_LEADING_LINES = "skipLeadingLines";
    public static final String IGNORE_UNPARSEABLE_LINES = "ignoreNonParseableLines";
    public static final String FILE_TAIL_PREPEND = "fileTailPrepend";
    public static final String DEFECTIVE_HEADERS = "defectiveHeaders";
    public static final String SKIP_LEADING_DATA_LINES = "skipLeadingDataLines";
    public static final String TRANSPOSED_LINES = "transposedLines";
    public static final String TRANSPOSED_FIELDS_TO_SKIP = "transposedFieldsToSkip";
    public static final String CHARSET = "charset";
    public static final String URL_PREFIX = "jdbc:relique:csv:";
    public static final String CRYPTO_FILTER_CLASS_NAME = "cryptoFilterClassName";
    public static final String TIME_ZONE_NAME = "timeZoneName";
    public static final String DEFAULT_TIME_ZONE_NAME = "UTC";
    public static final String QUOTE_STYLE = "quoteStyle";
    public static final String DEFAULT_QUOTE_STYLE = "SQL";
    public static final String READER_CLASS_PREFIX = "class:";
    public static final String ZIP_FILE_PREFIX = "zip:";
    public static final String FIXED_WIDTHS = "fixedWidths";
    public static final String FUNCTION = "function";

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        CsvConnection csvConnection;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        CsvDriver.writeLog("CsvDriver:connect() - url=" + string);
        if (!string.startsWith(URL_PREFIX)) {
            return null;
        }
        String string2 = "";
        int n = string.indexOf(63);
        if (n >= 0) {
            properties = new Properties(properties);
            string2 = string.substring(n);
            object4 = string2.substring(1).split("&");
            for (int i = 0; i < ((String[])object4).length; ++i) {
                object3 = object4[i].split("=");
                try {
                    if (((String[])object3).length != 2) {
                        throw new SQLException(CsvResources.getString("invalidProperty") + ": " + object4[i]);
                    }
                    object2 = URLDecoder.decode((String)object3[0], "UTF-8");
                    object = URLDecoder.decode((String)object3[1], "UTF-8");
                    properties.setProperty((String)object2, (String)object);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            string = string.substring(0, n);
        }
        object4 = string.substring(URL_PREFIX.length());
        CsvDriver.writeLog("CsvDriver:connect() - filePath=" + (String)object4);
        if (object4.startsWith(READER_CLASS_PREFIX)) {
            object3 = object4.substring(READER_CLASS_PREFIX.length());
            try {
                object2 = Class.forName((String)object3);
                object = ((Class)object2).getInterfaces();
                boolean bl = false;
                for (int i = 0; i < ((Class<?>[])object).length && !bl; ++i) {
                    if (!object[i].equals(TableReader.class)) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new SQLException(CsvResources.getString("interfaceNotImplemented") + ": " + TableReader.class.getName() + ": " + (String)object3);
                }
                Object t = ((Class)object2).newInstance();
                csvConnection = new CsvConnection((TableReader)t, properties, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException);
            }
        } else if (object4.startsWith(ZIP_FILE_PREFIX)) {
            object3 = object4.substring(ZIP_FILE_PREFIX.length());
            try {
                object2 = new ZipFileTableReader((String)object3, properties.getProperty(CHARSET));
                csvConnection = new CsvConnection((TableReader)object2, properties, string2);
                ((ZipFileTableReader)object2).setExtension(csvConnection.getExtension());
            }
            catch (IOException iOException) {
                throw new SQLException(CsvResources.getString("zipOpenError") + ": " + (String)object3, iOException);
            }
        } else {
            if (!object4.endsWith(File.separator)) {
                object4 = (String)object4 + File.separator;
            }
            if (!((File)(object3 = new File((String)object4))).exists()) {
                throw new SQLException(CsvResources.getString("dirNotFound") + ": " + (String)object4);
            }
            if (!((File)object3).isDirectory()) {
                throw new SQLException(CsvResources.getString("dirNotFound") + ": " + (String)object4);
            }
            csvConnection = new CsvConnection((String)object4, properties, string2);
        }
        return csvConnection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        CsvDriver.writeLog("CsvDriver:accept() - url=" + string);
        return string.startsWith(URL_PREFIX);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": Driver.getParentLogger()");
    }

    public static void writeLog(String string) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            printWriter.println("CsvJdbc: " + string);
        }
    }

    public static void writeToCsv(ResultSet resultSet, PrintStream printStream, boolean bl) throws SQLException {
        int n;
        Wrapper wrapper;
        String string = DEFAULT_SEPARATOR;
        Character c = Character.valueOf('\"');
        String string2 = DEFAULT_QUOTE_STYLE;
        if (resultSet instanceof CsvResultSet) {
            wrapper = (CsvResultSet)resultSet;
            CsvConnection csvConnection = (CsvConnection)((CsvResultSet)wrapper).getStatement().getConnection();
            string = csvConnection.getSeparator();
            c = csvConnection.getQuotechar();
            string2 = csvConnection.getQuoteStyle();
        }
        wrapper = null;
        int n2 = 0;
        while (resultSet.next()) {
            if (wrapper == null) {
                wrapper = resultSet.getMetaData();
                n2 = wrapper.getColumnCount();
                if (bl) {
                    for (n = 1; n <= n2; ++n) {
                        if (n > 1) {
                            printStream.print(string);
                        }
                        printStream.print(wrapper.getColumnName(n));
                    }
                    printStream.println();
                }
            }
            for (n = 1; n <= n2; ++n) {
                String string3;
                if (n > 1) {
                    printStream.print(string);
                }
                if ((string3 = resultSet.getString(n)) == null) continue;
                if (c != null) {
                    string3 = CsvDriver.addQuotes(string3, string, c.charValue(), string2);
                }
                printStream.print(string3);
            }
            printStream.println();
        }
        if (wrapper == null && bl) {
            wrapper = resultSet.getMetaData();
            n2 = wrapper.getColumnCount();
            for (n = 1; n <= n2; ++n) {
                if (n > 1) {
                    printStream.print(string);
                }
                printStream.print(wrapper.getColumnName(n));
            }
            printStream.println();
        }
        printStream.flush();
    }

    private static String addQuotes(String string, String string2, char c, String string3) {
        if (string3.equals("C")) {
            string = string.replace("\\", "\\\\");
            string = string.replace("" + c, "\\" + c);
        } else {
            string = string.replace("" + c, "" + c + c);
        }
        if (string.indexOf(string2) >= 0 || string.indexOf(c) >= 0 || string.indexOf(13) >= 0 || string.indexOf(10) >= 0) {
            string = c + string + c;
        }
        return string;
    }

    static {
        try {
            DriverManager.registerDriver(new CsvDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(CsvResources.getString("initFailed") + ": " + sQLException.getMessage());
        }
    }
}

