/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.relique.io.CryptoFilter;
import org.relique.io.EncryptedFileInputStream;
import org.relique.jdbc.csv.CsvResources;

public class FileSetInputStream
extends InputStream {
    private String dirName;
    private List<String> fileNames;
    private EncryptedFileInputStream currentFile;
    private boolean readingHeader;
    private String tail;
    private int pos;
    private Pattern fileNameRE;
    private String separator;
    private String dataTail;
    private boolean prepend;
    private int lookahead = 10;
    private boolean doingTail;
    private int currentLineLength;
    private CryptoFilter filter;
    private int skipLeadingDataLines;
    private boolean isClosed = false;

    public FileSetInputStream(String string, String string2, String[] stringArray, String string3, boolean bl, boolean bl2, CryptoFilter cryptoFilter, int n) throws IOException {
        this.dirName = string;
        this.filter = cryptoFilter;
        this.skipLeadingDataLines = n;
        if (!bl2) {
            ++this.skipLeadingDataLines;
        }
        this.prepend = bl;
        this.separator = string3;
        this.tail = "";
        if (bl) {
            this.tail = this.tail + '\n';
        } else if (stringArray != null) {
            this.tail = this.tail + string3;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.tail = this.tail + stringArray[i];
                if (i + 1 >= stringArray.length) continue;
                this.tail = this.tail + string3;
            }
        }
        if (bl) {
            if (stringArray != null) {
                this.tail = this.tail + string3;
            }
        } else {
            this.tail = this.tail + '\n';
        }
        this.fileNames = new ArrayList<String>();
        File file = new File(string);
        String[] stringArray2 = file.list();
        this.fileNameRE = Pattern.compile(string2);
        for (int i = 0; i < stringArray2.length; ++i) {
            Matcher matcher = this.fileNameRE.matcher(stringArray2[i]);
            if (!matcher.matches()) continue;
            this.fileNames.add(stringArray2[i]);
        }
        Collections.sort(this.fileNames);
        if (this.fileNames.isEmpty()) {
            return;
        }
        this.fileNameRE = Pattern.compile(".*" + string2);
        this.readingHeader = true;
        String string4 = this.fileNames.remove(0);
        this.dataTail = this.getTailFromName(string + string4);
        if (bl2) {
            this.tail = this.dataTail;
        }
        this.currentFile = new EncryptedFileInputStream(string + string4, cryptoFilter);
        this.lookahead = this.currentFile.read();
        this.doingTail = bl;
        if (this.doingTail) {
            this.pos = 1;
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.currentFile != null) {
            this.currentFile.close();
            this.currentFile = null;
        }
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.isClosed) {
            throw new IOException(CsvResources.getString("streamClosed"));
        }
        if (this.currentFile == null) {
            return -1;
        }
        if (this.doingTail) {
            n = this.readFromTail();
            if (n != -1) {
                return n;
            }
            this.doingTail = false;
            this.currentLineLength = 0;
        }
        n = this.lookahead;
        do {
            this.lookahead = this.currentFile.read();
        } while (this.lookahead == 13);
        if (this.prepend) {
            if (n == 10 && this.lookahead != 10 && this.lookahead != -1) {
                this.doingTail = true;
                return this.readFromTail();
            }
        } else if (this.currentLineLength > 0 && (n == 10 || n == -1)) {
            this.doingTail = true;
            return this.readFromTail();
        }
        if (n < 0) {
            this.currentFile.close();
            this.pos = 0;
            if (this.fileNames.size() <= 0) {
                this.currentFile = null;
                return -1;
            }
            String string = this.fileNames.remove(0);
            this.tail = this.getTailFromName(this.dirName + string);
            this.currentFile = new EncryptedFileInputStream(this.dirName + string, this.filter);
            for (int i = 0; i < this.skipLeadingDataLines; ++i) {
                int n2;
                while ((n2 = this.currentFile.read()) != 10 && n2 != -1) {
                }
            }
            this.doingTail = this.prepend;
            if (this.doingTail) {
                this.pos = 1;
            }
            this.lookahead = this.currentFile.read();
            return this.read();
        }
        ++this.currentLineLength;
        return n;
    }

    private String getTailFromName(String string) {
        Matcher matcher = this.fileNameRE.matcher(string);
        matcher.matches();
        String string2 = "";
        int n = matcher.groupCount();
        if (this.prepend) {
            string2 = string2 + '\n';
        } else if (n > 0) {
            string2 = string2 + this.separator;
        }
        for (int i = 1; i <= n; ++i) {
            string2 = string2 + matcher.group(i);
            if (i >= n) continue;
            string2 = string2 + this.separator;
        }
        if (this.prepend) {
            if (n > 0) {
                string2 = string2 + this.separator;
            }
        } else {
            string2 = string2 + '\n';
        }
        return string2;
    }

    private int readFromTail() {
        if (this.pos < this.tail.length()) {
            return this.tail.charAt(this.pos++);
        }
        this.pos = 0;
        if (this.readingHeader) {
            this.readingHeader = false;
            this.tail = this.dataTail;
        }
        return -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }
}

