/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.relique.io.CryptoFilter;

public class EncryptedFileInputStream
extends InputStream {
    private InputStream in;
    private CryptoFilter filter;

    public EncryptedFileInputStream(String string, CryptoFilter cryptoFilter) throws FileNotFoundException {
        this.filter = cryptoFilter;
        this.in = new BufferedInputStream(new FileInputStream(string));
    }

    @Override
    public int read() throws IOException {
        if (this.filter != null) {
            return this.filter.read(this.in);
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.filter != null) {
            return this.filter.read(this.in, byArray, n, n2);
        }
        return this.in.read(byArray, n, n2);
    }

    public int read(InputStream inputStream, byte[] byArray) throws IOException {
        if (this.filter != null) {
            return this.filter.read(inputStream, byArray);
        }
        return inputStream.read(byArray);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
    }
}

