/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netezza.core.Encoding;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzMethodNotImplementedException;
import org.netezza.error.NzSQLException;
import org.netezza.internal.ColumnMetadata;
import org.netezza.internal.NzNumeric;
import org.netezza.internal.NzQuery;
import org.netezza.internal.NzType;
import org.netezza.internal.PgType;
import org.netezza.internal.Tuple;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzResultSetMetadata;
import org.netezza.sql.NzStatement;

public class NzResultSet
implements ResultSet {
    public static final int PG_RESULTSET = 0;
    public static final int DBOS_RESULTSET = 1;
    private NzConnection connection;
    private final NzResultSetMetadata metadata;
    private int type = 0;
    private final List<Tuple> rows = new ArrayList<Tuple>();
    private int rowPointer = 0;
    private Tuple currentRow;
    private final NzStatement statement;
    private boolean wasNull;
    private boolean isClosed;
    private SQLWarning warnings = null;
    private int curentRowNumber = 0;
    private boolean isAfterLast = false;
    private static final int USE_ISO_DATES = 1;
    private HashMap<String, Integer> columnMap;
    protected int fetchSizeToCompare = 0;

    public NzResultSet(NzStatement statement, NzResultSetMetadata metadata) {
        this.statement = statement;
        this.metadata = metadata;
        this.connection = metadata.getConnection();
        String method = "*CSTR*";
        this.connection.LOGGER.entry(this.getClass(), method);
        switch (this.type) {
            case 1: {
                this.connection.LOGGER.debug(this.getClass(), method, "DBOS");
                break;
            }
            case 0: {
                this.connection.LOGGER.debug(this.getClass(), method, "PG");
                break;
            }
            default: {
                this.connection.LOGGER.debug(this.getClass(), method, "UNKNOWN");
            }
        }
        this.fetchSizeToCompare = this.connection.getDatasource().getBatchSize();
        this.connection.LOGGER.exit(this.getClass(), "*CSTR*");
        this.isClosed = false;
    }

    public void addRow(Tuple tuple) {
        try {
            if (this.statement != null && this.statement.getMaxRows() > 0) {
                if (this.rows.size() < this.statement.getMaxRows()) {
                    this.rows.add(tuple);
                }
            } else {
                this.rows.add(tuple);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "absolute", "This method is not supported");
        throw new NzResultSetNotScrollableException();
    }

    @Override
    public void afterLast() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "afterLast", "This method is not supported");
        throw new NzResultSetNotScrollableException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "beforeFirst", "This method is not supported");
        throw new NzResultSetNotScrollableException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "cancelRowUpdates", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "cancelRowUpdates()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        String method = "close";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.connection.STATE == 3) {
            this.connection.clearSocket();
            this.connection.STATE = 1;
        }
        this.isClosed = true;
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "deleteRow", "This method is not supported");
        throw new NzResultSetNotUpdatableException();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer columnIdx;
        String method = "close";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        if (this.columnMap == null) {
            int len = this.metadata.getColumnCount();
            this.columnMap = new HashMap(len);
            for (int idx = 1; idx <= len; ++idx) {
                this.columnMap.put(this.metadata.getColumnMetadata(idx).getName().toUpperCase(), idx);
            }
        }
        if ((columnIdx = this.columnMap.get(columnName.toUpperCase())) != null) {
            this.connection.LOGGER.exit(this.getClass(), method, columnIdx);
            return columnIdx;
        }
        NzSQLException etothrow = new NzSQLException("netezza.col.name.not.found", "42S22", 114226, columnName);
        this.connection.LOGGER.fatal(this.getClass(), "findColumn", etothrow);
        throw etothrow;
    }

    @Override
    public boolean first() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "first", "This method is not supported");
        throw new NzResultSetNotScrollableException();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getArray", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getArray(int)");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getArray", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getArray(String)");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String method = "getAsciiStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        InputStream value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgAsciiStream(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosAsciiStream(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 1100, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getAsciiStream", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        String method = "getAsciiStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        InputStream iStream = this.getAsciiStream(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, iStream);
        return iStream;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        BigDecimal value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgBigDecimal(columnIndex, -1);
                break;
            }
            case 1: {
                value = this.getDbosBigDecimal(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getBigDecimal", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        BigDecimal bigDec = this.getBigDecimal(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, bigDec);
        return bigDec;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex, scale);
        BigDecimal value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgBigDecimal(columnIndex, scale);
                break;
            }
            case 1: {
                value = this.getDbosBigDecimal(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getBigDecimal", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, columnName, scale);
        BigDecimal bigDec = this.getBigDecimal(this.findColumn(columnName), scale);
        this.connection.LOGGER.exit(this.getClass(), method, bigDec);
        return bigDec;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String method = "getBinaryStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        InputStream value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgBinaryStream(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosBinaryStream(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getBinaryStream", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        String method = "getBinaryStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        InputStream iStream = this.getBinaryStream(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, iStream);
        return iStream;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getBlob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getBlob(int)");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getBlob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getBlob(String)");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String method = "getBoolean";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        boolean value = false;
        switch (this.type) {
            case 0: {
                value = this.getPgBoolean(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosBoolean(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getBoolean", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        String method = "getBoolean";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        boolean bool = this.getBoolean(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, bool);
        return bool;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String method = "getByte";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        byte value = 0;
        switch (this.type) {
            case 0: {
                value = this.getPgByte(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosByte(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getByte", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        String method = "getByte";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        byte b = this.getByte(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, b);
        return b;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String method = "getBytes";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        byte[] value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgBytes(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosBytes(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getBytes", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        String method = "getBytes";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        byte[] bytes = this.getBytes(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, bytes);
        return bytes;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String method = "getCharacterStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        Reader value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgCharacterStream(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosCharacterStream(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getCharacterStream", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        String method = "getCharacterStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        Reader reader = this.getCharacterStream(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, reader);
        return reader;
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getClob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getClob(int)");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getClob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getClob(String)");
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        String method = "getCursorName";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.info(this.getClass(), method, "The cursor name returned is an empty string since the database does not support positioned updates/deletes");
        this.addWarnings(new SQLWarning("Scrollable Cursor not supported", "0A000", 11420));
        this.connection.LOGGER.exit(this.getClass(), method);
        return "";
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        Calendar cal = Calendar.getInstance();
        Date value = this.getDate(columnIndex, cal);
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        Date date = this.getDate(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, date);
        return date;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex, cal);
        Date value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgDate(columnIndex, cal);
                break;
            }
            case 1: {
                value = this.getDbosDate(columnIndex, cal);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getDate", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, columnName, cal);
        Date date = this.getDate(this.findColumn(columnName), cal);
        this.connection.LOGGER.exit(this.getClass(), method, date);
        return date;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String method = "getDouble";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        double value = 0.0;
        switch (this.type) {
            case 0: {
                value = this.getPgDouble(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosDouble(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getDate", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        String method = "getDouble";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        double d = this.getDouble(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, d);
        return d;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement == null ? 0 : this.statement.getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String method = "getFloat";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        float value = 0.0f;
        switch (this.type) {
            case 0: {
                value = this.getPgFloat(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosFloat(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getFloat", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, Float.valueOf(value));
        return value;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        String method = "getFloat";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        float f = this.getFloat(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, Float.valueOf(f));
        return f;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String method = "getInt";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        int value = 0;
        switch (this.type) {
            case 0: {
                value = this.getPgInt(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosInt(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getLong", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        String method = "getInt";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        int i = this.getInt(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, i);
        return i;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String method = "getLong";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        long value = 0L;
        switch (this.type) {
            case 0: {
                value = this.getPgLong(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosLong(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getLong", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        String method = "getLong";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        long l = this.getLong(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, l);
        return l;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String method = "getObject";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        Object value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgObject(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosObject(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getLong", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        String method = "getObject";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        Object obj = this.getObject(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, obj);
        return obj;
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getObject(int, Map)");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getObject(String, Map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getRef", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getRef(int)");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getRef", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getRef(String)");
    }

    @Override
    public int getRow() throws SQLException {
        return this.curentRowNumber;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String method = "getShort";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        short value = 0;
        switch (this.type) {
            case 0: {
                value = this.getPgShort(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosShort(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getLong", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        String method = "getShort";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        short s = this.getShort(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, s);
        return s;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String method = "getString";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        String value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgString(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosString(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        String method = "getString";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        String string = this.getString(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, string);
        return string;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        Calendar cal = Calendar.getInstance();
        Time value = this.getTime(columnIndex, cal);
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        Time time = this.getTime(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, time);
        return time;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex, cal);
        Time value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgTime(columnIndex, cal);
                break;
            }
            case 1: {
                value = this.getDbosTime(columnIndex, cal);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getTime", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, columnName, cal);
        Time time = this.getTime(this.findColumn(columnName), cal);
        this.connection.LOGGER.exit(this.getClass(), method, time);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        Calendar cal = Calendar.getInstance();
        Timestamp value = this.getTimestamp(columnIndex, cal);
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        Timestamp tStamp = this.getTimestamp(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, tStamp);
        return tStamp;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex, cal);
        Timestamp value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgTimestamp(columnIndex, cal);
                break;
            }
            case 1: {
                value = this.getDbosTimestamp(columnIndex, cal);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getTime", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, columnName, cal);
        Timestamp tStamp = this.getTimestamp(this.findColumn(columnName), cal);
        this.connection.LOGGER.exit(this.getClass(), method, tStamp);
        return tStamp;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getURL", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "getURL", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "getURL(String)");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String method = "getUnicodeStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        InputStream value = null;
        switch (this.type) {
            case 0: 
            case 1: {
                value = this.getPgUnicodeStream(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), "getAsciiStream", etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        String method = "getUnicodeStream";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        InputStream iStream = this.getUnicodeStream(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, iStream);
        return iStream;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void addWarnings(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        NzResultSetNotUpdatableException etothrow = new NzResultSetNotUpdatableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.curentRowNumber == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.curentRowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rows.size() < this.getFetchSize() && this.rowPointer == this.rows.size();
    }

    @Override
    public boolean last() throws SQLException {
        NzResultSetNotScrollableException etothrow = new NzResultSetNotScrollableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        NzResultSetNotUpdatableException etothrow = new NzResultSetNotUpdatableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        NzResultSetNotUpdatableException etothrow = new NzResultSetNotUpdatableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public boolean next() throws SQLException {
        String method = "next";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.rows.size() == 0) {
            this.isAfterLast = true;
            this.connection.LOGGER.debug(this.getClass(), method, "rows.size() == 0");
            this.connection.LOGGER.exit(this.getClass(), method, false);
            return false;
        }
        if (this.rowPointer == this.rows.size()) {
            if (this.getFetchSize() == 0 || this.rowPointer < this.fetchSizeToCompare) {
                this.connection.LOGGER.debug(this.getClass(), method, "Last Row is fetched");
                this.isAfterLast = true;
                this.connection.LOGGER.exit(this.getClass(), method, false);
                return false;
            }
            this.fetchSizeToCompare = this.getFetchSize();
            this.connection.updateResultSet(this);
            if ((this.statement.query.getQueryType() == NzQuery.QueryType.BATCH && this.connection.STATE == 2 || this.connection.STATE == 1) && this.rows.size() == 0) {
                this.isAfterLast = true;
                this.connection.LOGGER.exit(this.getClass(), method, false);
                return false;
            }
            this.rowPointer = 0;
        }
        this.currentRow = this.rows.get(this.rowPointer++);
        ++this.curentRowNumber;
        this.connection.LOGGER.exit(this.getClass(), method, true);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "previous", "This method is not supported");
        throw new NzResultSetNotScrollableException();
    }

    @Override
    public void refreshRow() throws SQLException {
        NzResultSetNotUpdatableException etothrow = new NzResultSetNotUpdatableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        NzResultSetNotScrollableException etothrow = new NzResultSetNotScrollableException();
        this.connection.LOGGER.fatal(this.getClass(), "insertRow", etothrow);
        throw etothrow;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "rowDeleted", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "rowDeleted()");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "rowInserted", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "rowInserted()");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "rowUpdated", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "rowUpdated()");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String method = "setFetchDirection";
        this.connection.LOGGER.entry(this.getClass(), method, direction);
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                NzResultSetNotScrollableException etothrow = new NzResultSetNotScrollableException();
                this.connection.LOGGER.fatal(this.getClass(), "setFetchDirection", etothrow);
                throw etothrow;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.invalid.fetch.direction", "HY000", 11427, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), "setFetchDirection", etothrow);
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String method = "setFetchSize";
        this.connection.LOGGER.entry(this.getClass(), method, rows);
        if (rows < 0) {
            NzSQLException etothrow = new NzSQLException("netezza.invalid.fetch.size", "HY000", 11424, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setFetchSize", etothrow);
            throw etothrow;
        }
        if (this.statement != null && this.statement.getMaxRows() > 0 && rows > this.statement.getMaxRows()) {
            NzSQLException etothrow = new NzSQLException("netezza.invalid.fetch.size", "HY000", 11425, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setFetchSize", etothrow);
            throw etothrow;
        }
        int n = rows = rows == 0 ? 256 : rows;
        if (this.statement != null) {
            this.statement.setFetchSize(rows);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateArray", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateArray(int,Array)");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateArray", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateArray(String,Array)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateAsciiStream(int,Array)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateAsciiStream(String,Array)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBigDecimal", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBigDecimal(int,BigDecimal)");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBigDecimal", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBigDecimal(int,BigDecimal)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBigDecimal(int,InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBigDecimal(String,InputStream)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBlob(int,InputStream)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBlob(String,InputStream)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBoolean", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBoolean(int,boolean)");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBoolean", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBoolean(String,boolean)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateByte", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateByte(int,byte)");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateByte", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateByte(String,byte)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBytes", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBytes(int,byte[])");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateBytes", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateBytes(String,byte[])");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateCharacterStream(int,Reader,int)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateCharacterStream(String,Reader,int)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateClob(String,Clob)");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateDate", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateDate(int,Date)");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateDate", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateDate(String,Date)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateDouble", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateDouble(int,double)");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateDouble", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateDouble(String,double)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateFloat", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateFloat(int,float)");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateFloat", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateFloat(String,float)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateInt", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateInt(int,int)");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateInt", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateInt(String,int)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateLong", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateLong(int,long)");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateLong", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateLong(String,long))");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateNull", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateNull(int)");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateNull", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateNull(String)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateObject(int,Object)");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateObject(String,Object)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateObject(int,Object,scale))");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateObject", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateObject(String,Object,scale)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateRef", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateRef", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateRef(String,Ref)");
    }

    @Override
    public void updateRow() throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateRow", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateRow()");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateShort", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateShort(int,short)");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateShort", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateShort(String,short)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateString", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateString(int,String)");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateString", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateString(String,String)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateTime", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateTime(int,Time)");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateTime", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateTime(String,Time)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateTimestamp", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateTimestamp(int,Timestamp)");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.connection.LOGGER.fatal(this.getClass(), "updateTimestamp", "This method is not supported");
        throw new NzMethodNotImplementedException("NzResultSet", "updateTimestamp(String,Timestamp)");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public void clean() {
        this.curentRowNumber = 0;
        this.rows.clear();
    }

    private void checkResultSet() throws SQLException {
        if (this.isClosed) {
            NzSQLException etothrow = new NzSQLException("netezza.res.closed", "HY008", 11428, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "checkResultSet", etothrow);
            throw etothrow;
        }
        if (this.rowPointer == -1) {
            NzSQLException etothrow = new NzSQLException("netezza.res.invalid.cur.state", "HY008", 11422, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "checkResultSet", etothrow);
            throw etothrow;
        }
    }

    private Date getJulianDate(int year, int month, int date, int data, Calendar calendar) {
        int m12 = (month - 14) / 12;
        int julianDate = 1461 * (year + 4800 + m12) / 4 + 367 * (month - 2 - 12 * m12) / 12 - 3 * ((year + 4900 + m12) / 100) / 4 + date - 32075;
        int finalDate = julianDate + data;
        int l = finalDate + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        int j = 80 * (l += 31 - 1461 * i / 4) / 2447;
        int d = l - 2447 * j / 80;
        l = j / 11;
        int m = j + 2 - 12 * l;
        int y = 100 * (n - 49) + i + l;
        calendar.setTimeInMillis(0L);
        calendar.set(y, m - 1, d, 0, 0, 0);
        this.connection.LOGGER.debug(this.getClass(), "getJulianTimestamp", "Year=" + y + " Month=" + m + " Date=" + d + " \nTime in millisec=" + calendar.getTimeInMillis());
        return new Date(calendar.getTimeInMillis());
    }

    private Timestamp getJulianTimestamp(int year, int month, int date, long data, Calendar calendar) throws SQLException {
        long _date = data / 86400000000L;
        int m12 = (month - 14) / 12;
        int julianDate = 1461 * (year + 4800 + m12) / 4 + 367 * (month - 2 - 12 * m12) / 12 - 3 * ((year + 4900 + m12) / 100) / 4 + date - 32075;
        long _time = data % 86400000000L;
        if (_time < 0L) {
            _time += 86400000000L;
            --_date;
        }
        if (date < -julianDate) {
            throw new NzSQLException("netezza.neg.julian.dayz", "HY000", 1100, new Object[0]);
        }
        int finalDate = (int)((long)julianDate + _date);
        calendar.setTimeInMillis(0L);
        int l = finalDate + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        int j = 80 * (l += 31 - 1461 * i / 4) / 2447;
        int d = l - 2447 * j / 80;
        l = j / 11;
        int m = j + 2 - 12 * l;
        int y = 100 * (n - 49) + i + l;
        int fraction = (int)(_time % 1000000L) * 1000;
        int hours = (int)((_time /= 1000000L) / 3600L);
        int min = (int)((_time -= (long)(hours * 3600)) / 60L);
        int sec = (int)(_time - (long)(min * 60));
        calendar.set(y, m - 1, d, hours, min, sec);
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos(fraction);
        this.connection.LOGGER.debug(this.getClass(), "getJulianTimestamp", "Year=" + y + " Month=" + m + " Date=" + d + " Hour=" + hours + " Mins=" + min + " sec=" + sec + " \nTime in millisec=" + calendar.getTimeInMillis() + "  Timestamp=" + ts);
        return ts;
    }

    private String IntervaltoText(long time, int month, int DateStyle) {
        int[] ymdhms = new int[6];
        StringBuffer sb = new StringBuffer(50);
        double[] fs = new double[1];
        if (this.interval2tm(time, month, ymdhms, fs) != 0) {
            return null;
        }
        if (this.encodeTimeSpan(ymdhms, fs[0], DateStyle, sb) != 0) {
            return null;
        }
        return sb.toString();
    }

    private int encodeTimeSpan(int[] ymdhms, double fsec, int style, StringBuffer sb) {
        boolean is_before = false;
        boolean is_nonzero = false;
        switch (style) {
            case 1: {
                boolean minus;
                if (ymdhms[0] != 0) {
                    sb.append(ymdhms[0]).append(" year");
                    if (ymdhms[0] != 1 && ymdhms[0] != -1) {
                        sb.append("s");
                    }
                    is_before = ymdhms[0] < 0;
                    is_nonzero = true;
                }
                if (ymdhms[1] != 0) {
                    if (is_nonzero) {
                        sb.append(" ");
                    }
                    if (is_before && ymdhms[1] > 0) {
                        sb.append("+");
                    }
                    sb.append(ymdhms[1]).append(" mon");
                    if (ymdhms[1] != 1 && ymdhms[1] != -1) {
                        sb.append("s");
                    }
                    is_before = ymdhms[1] < 0;
                    is_nonzero = true;
                }
                if (ymdhms[2] != 0) {
                    if (is_nonzero) {
                        sb.append(" ");
                    }
                    if (is_before && ymdhms[2] > 0) {
                        sb.append("+");
                    }
                    sb.append(ymdhms[2]).append(" day");
                    if (ymdhms[2] != 1 && ymdhms[2] != -1) {
                        sb.append("s");
                    }
                    is_before = ymdhms[2] < 0;
                    is_nonzero = true;
                }
                if (is_nonzero && ymdhms[3] == 0 && ymdhms[4] == 0 && ymdhms[5] == 0 && fsec == 0.0) break;
                boolean bl = minus = ymdhms[4] < 0 || ymdhms[5] < 0 || fsec < 0.0;
                if (is_nonzero) {
                    sb.append(" ");
                }
                if (minus) {
                    sb.append("-");
                } else if (is_before) {
                    sb.append("+");
                }
                if (ymdhms[3] != 0) {
                    if (ymdhms[3] / 10 != 0) {
                        sb.append(Math.abs(ymdhms[3]));
                    } else {
                        sb.append("0");
                        sb.append(Math.abs(ymdhms[3]));
                    }
                } else {
                    sb.append("00");
                }
                sb.append(":");
                if (ymdhms[4] != 0) {
                    if (ymdhms[4] / 10 != 0) {
                        sb.append(Math.abs(ymdhms[4]));
                    } else {
                        sb.append("0");
                        sb.append(Math.abs(ymdhms[4]));
                    }
                } else {
                    sb.append("00");
                }
                is_nonzero = true;
                if (ymdhms[5] != 0) {
                    if (ymdhms[5] / 10 != 0) {
                        sb.append(":").append(Math.abs(ymdhms[5]));
                    } else {
                        sb.append(":0");
                        sb.append(Math.abs(ymdhms[5]));
                    }
                } else {
                    sb.append(":00");
                }
                if (fsec == 0.0) break;
                StringBuffer fraction_part = new StringBuffer();
                Double frac = new Double(fsec);
                fraction_part.append(frac.toString().substring(0, frac.toString().indexOf(46)));
                while (fraction_part.length() < 6) {
                    fraction_part.insert(0, '0');
                }
                sb.append(".").append(fraction_part);
            }
        }
        if (!is_nonzero) {
            sb.append("0");
        }
        return 0;
    }

    private int interval2tm(long time1, int month, int[] ymdhms, double[] fsec) {
        ymdhms[0] = month / 12;
        ymdhms[1] = month % 12;
        double time = time1;
        time = this.timecheck(time, 8.64E10, ymdhms, 2);
        time = this.timecheck(time, 3.6E9, ymdhms, 3);
        time = this.timecheck(time, 6.0E7, ymdhms, 4);
        fsec[0] = time = this.timecheck(time, 1000000.0, ymdhms, 5);
        return 0;
    }

    private double timecheck(double time, double cnst, int[] ymdhms, int index) {
        double tmpvalue = 0.0;
        double d = tmpvalue = time < 0.0 ? Math.ceil(time / cnst) : Math.floor(time / cnst);
        if (tmpvalue != 0.0) {
            time -= Math.rint(tmpvalue * cnst);
        }
        ymdhms[index] = (int)tmpvalue;
        return time;
    }

    private String tzValue(int value) {
        int hour = Math.abs(value) / 3600;
        int minute = Math.abs(value) / 60 % 60;
        StringBuffer t = new StringBuffer(16);
        if (hour != 0) {
            if (hour / 10 != 0) {
                t.append(hour);
            } else {
                t.append("0");
                t.append(hour);
            }
        } else {
            t.append("00");
        }
        if (minute != 0) {
            if (minute / 10 != 0) {
                t.append(":");
                t.append(minute);
            } else {
                t.append(":0");
                t.append(minute);
            }
        }
        if (value <= 0) {
            t.insert(0, '+');
        } else {
            t.insert(0, '-');
        }
        return new String(t);
    }

    private String getPgString(int columnIndex) throws SQLException {
        String method = "getPgString";
        this.checkResultSet();
        if (columnIndex < 1 || columnIndex > this.metadata.getColumnCount()) {
            NzSQLException ex = new NzSQLException("netezza.col.idx.out.of.range", "07009", 11430, columnIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        this.metadata.getColumnMetadata(columnIndex);
        byte[] data = this.currentRow.data[columnIndex - 1];
        this.wasNull = data == null;
        String value = data == null ? null : Encoding.UNICODE.decode(data);
        return value;
    }

    private long getPgLong(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        long value = 0L;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_FLOAT: 
                    case PG_REAL: {
                        value = Float.valueOf(str).intValue();
                        break;
                    }
                    case PG_DOUBLE: {
                        value = Double.valueOf(str).intValue();
                        break;
                    }
                    case PG_NUMERIC: 
                    case PG_DECIMAL: {
                        int index = str.indexOf(46);
                        value = Long.parseLong(index < 0 ? str : str.substring(index));
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    default: {
                        value = Long.parseLong(str);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.num", "HY000", 1013, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgLong", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private int getPgInt(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        int value = 0;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_FLOAT: 
                    case PG_REAL: {
                        value = Float.valueOf(str).intValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_DOUBLE: {
                        value = Double.valueOf(str).intValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_NUMERIC: 
                    case PG_DECIMAL: {
                        int index = str.indexOf(46);
                        value = Integer.parseInt(index < 0 ? str : str.substring(index));
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    default: {
                        value = Integer.parseInt(str);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.num", "HY000", 1012, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgInt", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private InputStream getPgAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        ByteArrayInputStream value = null;
        byte[] data = this.currentRow.data[columnIndex - 1];
        this.wasNull = data == null;
        try {
            if (data != null) {
                value = new ByteArrayInputStream(new String(data).getBytes("ASCII"));
            }
        }
        catch (UnsupportedEncodingException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "getPgAsciiStream", etothrow);
            throw etothrow;
        }
        return value;
    }

    private BigDecimal getPgBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = null;
        String str = this.getPgString(columnIndex);
        try {
            if (str != null) {
                value = new BigDecimal(str);
                value = scale == -1 ? value : value.setScale(scale);
            }
        }
        catch (NumberFormatException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1010, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "getPgBigDecimal", etothrow);
            throw etothrow;
        }
        return value;
    }

    private InputStream getPgBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        this.wasNull = data == null;
        ByteArrayInputStream value = data == null ? null : new ByteArrayInputStream(data);
        return value;
    }

    private boolean getPgBoolean(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        boolean value = false;
        if (str != null) {
            char c = str.charAt(0);
            value = c == 't' || c == 'T' || c == '1';
        }
        return value;
    }

    private byte getPgByte(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        byte value = 0;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_FLOAT: 
                    case PG_REAL: {
                        value = Float.valueOf(str).byteValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_DOUBLE: {
                        value = Double.valueOf(str).byteValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_NUMERIC: 
                    case PG_DECIMAL: {
                        int index = str.indexOf(46);
                        value = Byte.parseByte(index < 0 ? str : str.substring(index));
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    default: {
                        value = Byte.parseByte(str);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.num", "HY000", 1011, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgByte", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private byte[] getPgBytes(int columnIndex) throws SQLException {
        String method = "getPgBytes";
        this.checkResultSet();
        if (columnIndex < 1 || columnIndex > this.metadata.getColumnCount()) {
            NzSQLException ex = new NzSQLException("netezza.col.idx.out.of.range", "07009", 11430, columnIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        byte[] data = this.currentRow.data[columnIndex - 1];
        this.wasNull = data == null;
        byte[] value = data == null ? null : NzType.hexStringToByteArr(new String(data, 0, data.length));
        return value;
    }

    private Reader getPgCharacterStream(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        CharArrayReader value = str == null ? null : new CharArrayReader(str.toCharArray());
        return value;
    }

    private Date getPgDate(int columnIndex, Calendar cal) throws SQLException {
        String str = this.getPgString(columnIndex);
        Date value = null;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_TIMESTAMP: {
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        Timestamp timestamp = Timestamp.valueOf(str);
                        cal.setTimeInMillis(timestamp.getTime());
                        value = new Date(cal.getTimeInMillis());
                        break;
                    }
                    default: {
                        value = Date.valueOf(str);
                        cal.setTime(value);
                        value = new Date(cal.getTimeInMillis());
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.date", "HY000", 1017, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgDate", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private double getPgDouble(int columnIndex) throws SQLException {
        double value;
        String str = this.getPgString(columnIndex);
        try {
            value = str == null ? 0.0 : Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            NzSQLException etothrow = new NzSQLException("netezza.res.bad.date", "HY000", 1015, str);
            this.connection.LOGGER.fatal(this.getClass(), "getPgDouble", etothrow);
            throw etothrow;
        }
        return value;
    }

    private float getPgFloat(int columnIndex) throws SQLException {
        float value;
        String str = this.getPgString(columnIndex);
        try {
            value = str == null ? 0.0f : Float.valueOf(str).floatValue();
        }
        catch (NumberFormatException e) {
            NzSQLException etothrow = new NzSQLException("netezza.res.bad.num", "HY000", 1016, str);
            this.connection.LOGGER.fatal(this.getClass(), "getPgFloat", etothrow);
            throw etothrow;
        }
        return value;
    }

    private Object getPgObject(int columnIndex) throws SQLException {
        Calendar cal = null;
        Object value = null;
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        PgType pgType = columnMetadata.getPgType();
        if (pgType != PgType.PG_UNKNOWN && pgType != PgType.PG_BPCHAR && this.getPgString(columnIndex) == null) {
            return null;
        }
        switch (pgType) {
            case PG_BOOLEAN: {
                value = this.getPgBoolean(columnIndex);
                break;
            }
            case PG_NAME: 
            case PG_CHAR: 
            case PG_VARCHAR: 
            case PG_INT2VECTOR: 
            case PG_REG_PROCEDURE: 
            case PG_TEXT: 
            case PG_NCHAR: 
            case PG_NVARCHAR: 
            case PG_JSON: 
            case PG_JSONB: 
            case PG_JSONPATH: {
                value = this.getPgString(columnIndex);
                break;
            }
            case PG_GEOMETRY: 
            case PG_VARBINARY: {
                value = this.getPgBytes(columnIndex);
                break;
            }
            case PG_BYTEINT: {
                value = this.getPgByte(columnIndex);
                break;
            }
            case PG_SMALLINT: {
                value = this.getPgShort(columnIndex);
                break;
            }
            case PG_INTEGER: 
            case PG_OID: {
                value = this.getPgInt(columnIndex);
                break;
            }
            case PG_BIGINT: {
                value = this.getPgLong(columnIndex);
                break;
            }
            case PG_FLOAT: 
            case PG_REAL: {
                value = Float.valueOf(this.getPgFloat(columnIndex));
                break;
            }
            case PG_DOUBLE: {
                value = this.getPgDouble(columnIndex);
                break;
            }
            case PG_NUMERIC: 
            case PG_DECIMAL: {
                value = this.getPgBigDecimal(columnIndex, -1);
                break;
            }
            case PG_DATE: {
                cal = Calendar.getInstance();
                value = this.getPgDate(columnIndex, cal);
                break;
            }
            case PG_TIME: {
                cal = Calendar.getInstance();
                value = this.getPgTime(columnIndex, cal);
                break;
            }
            case PG_TIMESTAMP: 
            case PG_ABSTIME: {
                cal = Calendar.getInstance();
                value = this.getPgTimestamp(columnIndex, cal);
                break;
            }
            case PG_INTERVAL: 
            case PG_TIMETZ: {
                value = this.getString(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.data.type.not.supported", "HY000", 11429, new Object[]{pgType});
                this.connection.LOGGER.fatal(this.getClass(), "getPgObject", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private short getPgShort(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        short value = 0;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_FLOAT: 
                    case PG_REAL: {
                        value = Float.valueOf(str).shortValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_DOUBLE: {
                        value = Double.valueOf(str).shortValue();
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    case PG_NUMERIC: 
                    case PG_DECIMAL: {
                        int index = str.indexOf(46);
                        value = Short.parseShort(index < 0 ? str : str.substring(index));
                        this.addWarnings(new SQLWarning("The operation may lead to loss of data"));
                        break;
                    }
                    default: {
                        value = Short.parseShort(str);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.num", "HY000", 1014, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgShort", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Time getPgTime(int columnIndex, Calendar cal) throws SQLException {
        String str = this.getPgString(columnIndex);
        Time value = null;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_TIMESTAMP: {
                        cal.setTimeInMillis(Timestamp.valueOf(str).getTime());
                        value = new Time(cal.getTimeInMillis());
                        break;
                    }
                    default: {
                        cal.setTimeInMillis(Time.valueOf(str).getTime());
                        value = new Time(cal.getTimeInMillis());
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.time", "HY000", 1018, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgTime", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Timestamp getPgTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String str = this.getPgString(columnIndex);
        Timestamp value = null;
        if (str != null) {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            PgType pgType = columnMetadata.getPgType();
            try {
                switch (pgType) {
                    case PG_DATE: {
                        Date date = Date.valueOf(str);
                        cal.setTime(date);
                        value = new Timestamp(cal.getTimeInMillis());
                        break;
                    }
                    default: {
                        value = Timestamp.valueOf(str);
                        int fraction = value.getNanos();
                        cal.setTimeInMillis(value.getTime());
                        value = new Timestamp(cal.getTimeInMillis());
                        value.setNanos(fraction);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                NzSQLException etothrow = new NzSQLException("netezza.res.bad.timestamp", "HY000", 1019, str);
                this.connection.LOGGER.fatal(this.getClass(), "getPgTimestamp", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private InputStream getPgUnicodeStream(int columnIndex) throws SQLException {
        String str = this.getPgString(columnIndex);
        return str != null ? new ByteArrayInputStream(str.getBytes()) : null;
    }

    private String getDbosString(int columnIndex) throws SQLException {
        Calendar cal = null;
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        String value = null;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = String.valueOf(data[0]);
                break;
            }
            case NZ_SMALLINT: {
                value = String.valueOf(NzType.byteArrToInt16(data));
                break;
            }
            case NZ_INTEGER: {
                value = String.valueOf(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_BIGINT: {
                value = String.valueOf(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_FLOAT: {
                value = String.valueOf(Float.intBitsToFloat(NzType.byteArrToInt32(data)));
                break;
            }
            case NZ_DOUBLE: {
                value = String.valueOf(Double.longBitsToDouble(NzType.byteArrToInt64(data)));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                value = NzNumeric.decodeNumeric(data, prec, scale, count);
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Encoding.LATIN9.decode(data);
                break;
            }
            case NZ_NVARCHAR: 
            case NZ_NCHAR: 
            case NZ_JSON: 
            case NZ_JSONB: 
            case NZ_JSONPATH: {
                value = Encoding.UNICODE.decode(data);
                break;
            }
            case NZ_DATE: {
                cal = Calendar.getInstance();
                value = this.getDbosDate(columnIndex, cal).toString();
                break;
            }
            case NZ_TIME: {
                cal = Calendar.getInstance();
                value = this.getDbosTime(columnIndex, cal).toString();
                int fractionSeconds = (int)(NzType.byteArrToInt64(data) % 1000000L);
                if (fractionSeconds <= 0) break;
                DecimalFormat fractionPattern = new DecimalFormat(".######");
                double fractionValue = (double)fractionSeconds / 1000000.0;
                value = value + fractionPattern.format(fractionValue);
                break;
            }
            case NZ_TIMESTAMP: {
                cal = Calendar.getInstance();
                value = this.getDbosTimestamp(columnIndex, cal).toString();
                break;
            }
            case NZ_INTERVAL: {
                value = this.getDbosInterval(columnIndex);
                break;
            }
            case NZ_TIMEZONE: {
                value = this.getDbosTimezone(columnIndex);
                break;
            }
            case NZ_GEOMETRY: 
            case NZ_VARBINARY: {
                value = NzType.byteArrToHexString(data);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosString", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private int getDbosInt(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        int value = 0;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = (int)NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = (int)Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = (int)Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Integer.parseInt(val.indexOf(46) == -1 ? val : val.substring(0, val.indexOf(46)));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Integer.parseInt(new String(data).trim());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosInt", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private float getDbosFloat(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0.0f;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        float value = 0.0f;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = (float)Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Float.valueOf(NzNumeric.decodeNumeric(data, prec, scale, count)).floatValue();
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Float.valueOf(new String(data).trim()).floatValue();
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosFloat", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private double getDbosDouble(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0.0;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        double value = 0.0;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Double.valueOf(NzNumeric.decodeNumeric(data, prec, scale, count));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Float.valueOf(new String(data).trim()).floatValue();
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosDouble", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private byte getDbosByte(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        byte value = 0;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = (byte)NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = (byte)NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = (byte)NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = (byte)Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = (byte)Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Byte.parseByte(val.indexOf(46) == -1 ? val : val.substring(0, val.indexOf(46)));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Byte.parseByte(new String(data).trim());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosByte", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private short getDbosShort(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        short value = 0;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = (short)NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = (short)NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = (short)Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = (short)Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Short.parseShort(val.indexOf(46) == -1 ? val : val.substring(0, val.indexOf(46)));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Short.parseShort(new String(data).trim());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosShort", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private long getDbosLong(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return 0L;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        long value = 0L;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = (long)Float.intBitsToFloat(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_DOUBLE: {
                value = (long)Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Long.parseLong(val.indexOf(46) == -1 ? val : val.substring(0, val.indexOf(46)));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Long.parseLong(new String(data).trim());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosLong", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private BigDecimal getDbosBigDecimal(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        BigDecimal value = null;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = new BigDecimal(data[0]);
                break;
            }
            case NZ_SMALLINT: {
                value = new BigDecimal(NzType.byteArrToInt16(data));
                break;
            }
            case NZ_INTEGER: {
                value = new BigDecimal(NzType.byteArrToInt32(data));
                break;
            }
            case NZ_BIGINT: {
                value = new BigDecimal(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_FLOAT: {
                value = new BigDecimal(Float.intBitsToFloat(NzType.byteArrToInt32(data)));
                break;
            }
            case NZ_DOUBLE: {
                value = new BigDecimal(Double.longBitsToDouble(NzType.byteArrToInt64(data)));
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = new BigDecimal(val);
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = new BigDecimal(new String(data).trim());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosBigDecimal", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Date getDbosDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Date value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                String str = new String(data);
                try {
                    value = Date.valueOf(str.trim());
                    cal.setTime(value);
                    value = new Date(cal.getTimeInMillis());
                    break;
                }
                catch (Exception e) {
                    try {
                        Timestamp timestamp = Timestamp.valueOf(str.trim());
                        cal.setTimeInMillis(timestamp.getTime());
                        value = new Date(cal.getTimeInMillis());
                        break;
                    }
                    catch (Exception e2) {
                        NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                        this.connection.LOGGER.fatal(this.getClass(), "getDbosDate", etothrow);
                        throw etothrow;
                    }
                }
            }
            case NZ_DATE: {
                int val = NzType.byteArrToInt32(data);
                value = this.getJulianDate(2000, 1, 1, val, cal);
                break;
            }
            case NZ_TIMESTAMP: {
                value = new Date(this.getTimestamp(columnIndex, cal).getTime());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosDate", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Time getDbosTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Time value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                String str = new String(data);
                try {
                    String local = str.trim();
                    if (local.indexOf(46) == 8) {
                        local = local.substring(0, 8);
                    }
                    cal.setTimeInMillis(Time.valueOf(local).getTime());
                    value = new Time(cal.getTimeInMillis());
                    break;
                }
                catch (Exception ex) {
                    try {
                        cal.setTimeInMillis(Timestamp.valueOf(str.trim()).getTime());
                        value = new Time(cal.getTimeInMillis());
                        break;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
            }
            case NZ_TIME: {
                int millis = (int)(NzType.byteArrToInt64(data) % 1000000L / 1000L);
                int time = (int)(NzType.byteArrToInt64(data) / 1000000L);
                cal.setTimeInMillis(0L);
                int hours = time / 3600;
                int min = (time -= hours * 3600) / 60;
                int sec = time - min * 60;
                cal.set(1970, 0, 1, hours, min, sec);
                value = new Time(cal.getTimeInMillis() + (long)millis);
                break;
            }
            case NZ_TIMESTAMP: {
                value = new Time(this.getTimestamp(columnIndex, cal).getTime());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosTime", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Timestamp getDbosTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Timestamp value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                String str = new String(data);
                try {
                    value = Timestamp.valueOf(str);
                    calendar.setTimeInMillis(value.getTime());
                    value = new Timestamp(calendar.getTimeInMillis());
                    break;
                }
                catch (Exception ex) {
                    try {
                        Date date = Date.valueOf(str.trim());
                        calendar.setTime(date);
                        value = new Timestamp(calendar.getTimeInMillis());
                        break;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
            }
            case NZ_DATE: {
                value = new Timestamp(this.getDate(columnIndex, calendar).getTime());
                break;
            }
            case NZ_TIMESTAMP: {
                long val = NzType.byteArrToInt64(data);
                if (this.metadata.getEnableTime24() == 1) {
                    val = (val + 1L) % 86400000000L == 0L ? val + 1L : val;
                }
                value = this.getJulianTimestamp(2000, 1, 1, val, calendar);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosTimestamp", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private Object getDbosObject(int columnIndex) throws SQLException {
        this.checkResultSet();
        Calendar cal = null;
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Object value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: 
            case NZ_NVARCHAR: 
            case NZ_NCHAR: 
            case NZ_JSON: 
            case NZ_JSONB: 
            case NZ_JSONPATH: {
                value = this.getDbosString(columnIndex);
                break;
            }
            case NZ_GEOMETRY: 
            case NZ_VARBINARY: {
                value = this.getDbosBytes(columnIndex);
                break;
            }
            case NZ_BYTEINT: {
                value = data[0];
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data);
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data);
                break;
            }
            case NZ_BIGINT: {
                value = NzType.byteArrToInt64(data);
                break;
            }
            case NZ_FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(NzType.byteArrToInt32(data)));
                break;
            }
            case NZ_DOUBLE: {
                value = Double.longBitsToDouble(NzType.byteArrToInt64(data));
                break;
            }
            case NZ_TIME: {
                cal = Calendar.getInstance();
                value = this.getDbosTime(columnIndex, cal);
                break;
            }
            case NZ_TIMEZONE: {
                value = this.getDbosTimezone(columnIndex);
                break;
            }
            case NZ_DATE: {
                cal = Calendar.getInstance();
                value = this.getDbosDate(columnIndex, cal);
                break;
            }
            case NZ_TIMESTAMP: {
                cal = Calendar.getInstance();
                value = this.getDbosTimestamp(columnIndex, cal);
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                value = new BigDecimal(NzNumeric.decodeNumeric(data, prec, scale, count));
                break;
            }
            case NZ_INTERVAL: {
                value = this.getDbosInterval(columnIndex);
                break;
            }
            case NZ_BOOL: {
                value = data[0] == 1;
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.data.type.not.supported", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosObject", etothrow);
                value = etothrow;
            }
        }
        return value;
    }

    private String getDbosInterval(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Object value = null;
        switch (nzType) {
            case NZ_INTERVAL: {
                long time = NzType.byteArrToInt64(data);
                byte[] arrTz = new byte[4];
                System.arraycopy(data, 8, arrTz, 0, 4);
                int month = NzType.byteArrToInt32(arrTz);
                int[] ymdhms = new int[6];
                StringBuffer sb = new StringBuffer(50);
                double[] fs = new double[1];
                if (this.interval2tm(time, month, ymdhms, fs) != 0) {
                    return null;
                }
                if (this.encodeTimeSpan(ymdhms, fs[0], 1, sb) != 0) {
                    return null;
                }
                return sb.toString();
            }
        }
        NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
        this.connection.LOGGER.fatal(this.getClass(), "getDbosInterval", etothrow);
        throw etothrow;
    }

    private String getDbosTimezone(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        Object value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                return new String(data);
            }
            case NZ_TIMEZONE: {
                int time = (int)(NzType.byteArrToInt64(data) / 1000000L);
                Calendar calendar = Calendar.getInstance();
                int hours = time / 3600;
                int min = (time -= hours * 3600) / 60;
                int sec = time - min * 60;
                calendar.set(1970, 0, 1, hours, min, sec);
                String tmValue = new Time(calendar.getTimeInMillis()).toString();
                byte[] arrTz = new byte[4];
                System.arraycopy(data, 8, arrTz, 0, 4);
                return tmValue + this.tzValue(NzType.byteArrToInt32(arrTz));
            }
        }
        NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
        this.connection.LOGGER.fatal(this.getClass(), "getDbosTimezone", etothrow);
        throw etothrow;
    }

    private boolean getDbosBoolean(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return false;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        boolean value = false;
        switch (nzType) {
            case NZ_BOOL: 
            case NZ_BYTEINT: {
                value = data[0] != 0;
                break;
            }
            case NZ_SMALLINT: {
                value = NzType.byteArrToInt16(data) != 0;
                break;
            }
            case NZ_INTEGER: {
                value = NzType.byteArrToInt32(data) != 0;
                break;
            }
            case NZ_BIGINT: {
                value = NzType.byteArrToInt64(data) != 0L;
                break;
            }
            case NZ_FLOAT: {
                value = Float.intBitsToFloat(NzType.byteArrToInt32(data)) != 0.0f;
                break;
            }
            case NZ_DOUBLE: {
                value = Double.longBitsToDouble(NzType.byteArrToInt64(data)) != 0.0;
                break;
            }
            case NZ_NUMERIC: {
                int prec = columnMetadata.getSize() >> 8 & 0x7F;
                int scale = columnMetadata.getSize() & 0xFF;
                int count = columnMetadata.getTrueSize() / 4;
                String val = NzNumeric.decodeNumeric(data, prec, scale, count);
                value = Long.parseLong(val.indexOf(46) == -1 ? val : val.substring(0, val.indexOf(46))) != 0L;
                break;
            }
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: {
                value = Long.parseLong(new String(data).trim()) != 0L;
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosBoolean", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private InputStream getDbosAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        ByteArrayInputStream value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: 
            case NZ_BINARY: {
                try {
                    value = new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
                    this.connection.LOGGER.fatal(this.getClass(), "getDbosAsciiStream", etothrow);
                    throw etothrow;
                }
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosAsciiStream", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private InputStream getDbosBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        ByteArrayInputStream value = null;
        switch (nzType) {
            case NZ_GEOMETRY: 
            case NZ_VARBINARY: 
            case NZ_BINARY: {
                value = new ByteArrayInputStream(data);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosBinaryStream", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    private byte[] getDbosBytes(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        byte[] newData = new byte[data.length];
        System.arraycopy(data, 0, newData, 0, newData.length);
        return newData;
    }

    private Reader getDbosCharacterStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        byte[] data = this.currentRow.data[columnIndex - 1];
        boolean bl = this.wasNull = data == null;
        if (this.wasNull) {
            return null;
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        NzType nzType = columnMetadata.getType();
        CharArrayReader value = null;
        switch (nzType) {
            case NZ_CHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_VARCHAR: 
            case NZ_NVARCHAR: 
            case NZ_NCHAR: 
            case NZ_JSON: 
            case NZ_JSONB: 
            case NZ_JSONPATH: 
            case NZ_BINARY: {
                value = new CharArrayReader(this.getString(columnIndex).toCharArray());
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.bad.value", "HY000", 11429, new Object[]{nzType});
                this.connection.LOGGER.fatal(this.getClass(), "getDbosAsciiStream", etothrow);
                throw etothrow;
            }
        }
        return value;
    }

    public void makeItDbos() {
        this.type = 1;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNClob");
        this.connection.LOGGER.fatal(this.getClass(), "getNClob", etothrow);
        throw etothrow;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNClob");
        this.connection.LOGGER.fatal(this.getClass(), "getNClob", etothrow);
        throw etothrow;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        String method = "getNString";
        this.connection.LOGGER.entry(this.getClass(), method, columnIndex);
        String value = null;
        switch (this.type) {
            case 0: {
                value = this.getPgString(columnIndex);
                break;
            }
            case 1: {
                value = this.getDbosString(columnIndex);
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.type.unknown", "HY000", 11423, this.type);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        String method = "getNString";
        this.connection.LOGGER.entry(this.getClass(), method, columnName);
        String string = this.getNString(this.findColumn(columnName));
        this.connection.LOGGER.exit(this.getClass(), method, string);
        return string;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getObject");
        this.connection.LOGGER.fatal(this.getClass(), "getObject", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getObject");
        this.connection.LOGGER.fatal(this.getClass(), "getObject", etothrow);
        throw etothrow;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getRowId");
        this.connection.LOGGER.fatal(this.getClass(), "getRowId", etothrow);
        throw etothrow;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getRowId");
        this.connection.LOGGER.fatal(this.getClass(), "getRowId", etothrow);
        throw etothrow;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "getSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "getSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBlob");
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBlob");
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBlob");
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateBlob");
        this.connection.LOGGER.fatal(this.getClass(), "updateBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "updateNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNClob");
        this.connection.LOGGER.fatal(this.getClass(), "updateNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNString");
        this.connection.LOGGER.fatal(this.getClass(), "updateNString", etothrow);
        throw etothrow;
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateNString");
        this.connection.LOGGER.fatal(this.getClass(), "updateNString", etothrow);
        throw etothrow;
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowID) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateRowId");
        this.connection.LOGGER.fatal(this.getClass(), "updateRowId", etothrow);
        throw etothrow;
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowID) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateRowId");
        this.connection.LOGGER.fatal(this.getClass(), "updateRowId", etothrow);
        throw etothrow;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "updateSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("updateSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "updateSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        this.connection.LOGGER.fatal(this.getClass(), "isWrapperFor", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        this.connection.LOGGER.fatal(this.getClass(), "unwrap", etothrow);
        throw etothrow;
    }

    private class NzResultSetNotUpdatableException
    extends NzSQLException {
        private static final String key = "netezza.res.not.updatable";
        private static final String state = "HY000";
        private static final int errorCode = 11421;

        public NzResultSetNotUpdatableException() {
            super(key, state, 11421, new Object[0]);
        }
    }

    private class NzResultSetNotScrollableException
    extends NzSQLException {
        private static final String key = "netezza.res.not.scrollable";
        private static final String state = "HY000";
        private static final int errorCode = 11420;

        public NzResultSetNotScrollableException() {
            super(key, state, 11420, new Object[0]);
        }
    }
}

