/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.netezza.core.Encoding;
import org.netezza.core.NzConstants;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzMethodNotImplementedException;
import org.netezza.error.NzSQLException;
import org.netezza.externaltable.Loader;
import org.netezza.externaltable.NzLoad;
import org.netezza.internal.NzPreparedQuery;
import org.netezza.internal.NzQuery;
import org.netezza.internal.NzSimpleQuery;
import org.netezza.internal.NzType;
import org.netezza.internal.ParseException;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzParameterMetadata;
import org.netezza.sql.NzStatement;

public class NzPreparedStatament
extends NzStatement
implements PreparedStatement {
    private final StringBuilder bindBuffer = new StringBuilder();
    private NzParameterMetadata parameterMetadata;
    private int bulkLoadNumber;
    private final Loader loader = new NzBulkLoad();

    public NzPreparedStatament(NzConnection connection, String sql) throws SQLException {
        super(connection);
        this.query = new NzPreparedQuery(sql);
        this.query.setAnalyzeFlg(connection.isAnalyze());
        this.query = this.query.parse();
        this.prepare();
    }

    public NzPreparedStatament(NzConnection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void addBatch() throws SQLException {
        ((NzPreparedQuery)this.query).addBatch();
    }

    @Override
    public void clearBatch() throws SQLException {
        ((NzPreparedQuery)this.query).clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        String method = "clearParameters";
        this.connection.LOGGER.entry(this.getClass(), method);
        ((NzPreparedQuery)this.query).clearParameters();
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public boolean execute() throws SQLException {
        String method = "execute";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        boolean value = this._execute();
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String method = "executeQuery";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        if (this._execute()) {
            this.connection.LOGGER.exit(this.getClass(), method, this.set);
            return this.set;
        }
        NzSQLException etothrow = new NzSQLException("netezza.bad.query.result", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
        throw etothrow;
    }

    @Override
    public int executeUpdate() throws SQLException {
        String method = "executeUpdate";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        if (this._execute()) {
            NzSQLException etothrow = new NzSQLException("netezza.bad.update.result", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.connection.LOGGER.exit(this.getClass(), method, this.updateCount);
        return this.updateCount;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.set == null ? null : this.set.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetadata;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new NzMethodNotImplementedException("NzPreparedStatement", "setArray(int, Array)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String method = "setAsciiStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        this.bind(parameterIndex, x, NzType.NZ_BINARY, "ASCII", length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String method = "setBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_NUMERIC);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int bytesRead;
        String method = "setBinaryStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        byte[] bytes = new byte[length];
        try {
            bytesRead = x.read(bytes, 0, length);
        }
        catch (IOException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, e);
            throw etothrow;
        }
        if (bytesRead == length) {
            this.bind(parameterIndex, bytes, NzType.NZ_VARBINARY);
        } else {
            byte[] bytes2 = new byte[bytesRead];
            System.arraycopy(bytes, 0, bytes2, 0, bytesRead);
            this.bind(parameterIndex, bytes2, NzType.NZ_VARBINARY);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new NzMethodNotImplementedException("NzPreparedStatement", "setBlob(int, Blob)");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        String method = "setBolean";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, Boolean.toString(x), NzType.NZ_BOOL);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        String method = "setByte";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, Integer.toString(x), NzType.NZ_BYTEINT);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        String method = "setBytes";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_VARBINARY);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String method = "setCharacterStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, length);
        this.bind(parameterIndex, reader, NzType.NZ_BINARY, null, length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw new NzMethodNotImplementedException("NzPreparedStatement", "setClob(int, Clob)");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        String method = "setDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_DATE);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String method = "setDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (cal != null) {
            cal.setTime(x);
            x = new Date(cal.getTime().getTime());
        }
        this.bind(parameterIndex, x, NzType.NZ_DATE);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String method = "setDouble";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_DOUBLE);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        String method = "setFloat";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, Float.valueOf(x));
        this.bind(parameterIndex, Float.valueOf(x), NzType.NZ_FLOAT);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        String method = "setInt";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_INTEGER);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        String method = "setLong";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_BIGINT);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String method = "setNull";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType);
        if (sqlType == -3) {
            this.bind(parameterIndex, null, NzType.NZ_VARBINARY);
        } else {
            this.bind(parameterIndex, null, NzType.NZ_UNKNOWN);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        String method = "setNull";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType, typeName);
        if (sqlType == -3) {
            this.bind(parameterIndex, null, NzType.NZ_VARBINARY);
        } else {
            this.bind(parameterIndex, null, NzType.NZ_UNKNOWN);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        JavaTypes type = JavaTypes.getJavaType(x);
        this.setObject(parameterIndex, x, type.getSqlType(), 0);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, targetSqlType);
        this.setObject(parameterIndex, x, targetSqlType, 0);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, targetSqlType, scale);
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            this.connection.LOGGER.exit(this.getClass(), method);
            return;
        }
        JavaTypes type = JavaTypes.getJavaType(x);
        if (!type.isValidMapping(targetSqlType)) {
            NzSQLException etothrow = new NzSQLException("netezza.type.mismatch", "HY000", 1100, new Object[]{type, targetSqlType});
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        try {
            block1 : switch (targetSqlType) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (type == JavaTypes.Boolean) {
                        this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", NzType.NZ_NUMERIC);
                        break;
                    }
                    this.bind(parameterIndex, x, NzType.NZ_NUMERIC);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case -7: 
                case 16: {
                    if (type == JavaTypes.String || type == JavaTypes.Boolean) {
                        this.setBoolean(parameterIndex, new Boolean(x.toString()));
                        break;
                    }
                    this.setBoolean(parameterIndex, new Boolean(((Number)x).intValue() != 0));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(parameterIndex, x instanceof String ? ((String)x).getBytes() : (byte[])x);
                    break;
                }
                case 91: {
                    switch (type) {
                        case Date: {
                            this.setDate(parameterIndex, (Date)x);
                            break block1;
                        }
                        case Timestamp: {
                            this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                        }
                        case String: {
                            this.setDate(parameterIndex, this.toDate(x.toString()));
                        }
                    }
                    break;
                }
                case 92: {
                    switch (type) {
                        case Time: {
                            this.setTime(parameterIndex, (Time)x);
                            break block1;
                        }
                        case Timestamp: {
                            this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                        }
                        case String: {
                            this.setTime(parameterIndex, this.toTime(x.toString()));
                        }
                    }
                    break;
                }
                case 93: {
                    switch (type) {
                        case Date: {
                            this.setTimestamp(parameterIndex, new Timestamp(((Date)x).getTime()));
                            break block1;
                        }
                        case Timestamp: {
                            this.setTimestamp(parameterIndex, (Timestamp)x);
                        }
                        case String: {
                            this.setTimestamp(parameterIndex, this.toTimestamp(x.toString()));
                        }
                    }
                    break;
                }
                case 2003: {
                    this.setArray(parameterIndex, (Array)x);
                    break;
                }
                case 2004: {
                    this.setBlob(parameterIndex, (Blob)x);
                    break;
                }
                case 2005: {
                    this.setClob(parameterIndex, (Clob)x);
                    break;
                }
                case 2006: {
                    this.setRef(parameterIndex, (Ref)x);
                    break;
                }
                case 70: {
                    this.setURL(parameterIndex, (URL)x);
                    break;
                }
                case 1111: 
                case 2000: {
                    this.bind(parameterIndex, x, NzType.NZ_UNKNOWN);
                    break;
                }
                default: {
                    NzSQLException e = new NzSQLException("netezza.prep.type", "07006", 1100, new Object[0]);
                    this.connection.LOGGER.fatal(this.getClass(), method, e);
                    throw e;
                }
            }
        }
        catch (ClassCastException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new NzMethodNotImplementedException("NzPreparedStatement", "setRef(int, Ref)");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        String method = "setShort";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, Short.toString(x), NzType.NZ_SMALLINT);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        String method = "setString";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_VARCHAR);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        String method = "setTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_TIME);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String method = "setTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (cal != null) {
            this.bind(parameterIndex, x, NzType.NZ_TIME);
        } else {
            cal.setTime(x);
            x = new Time(cal.getTime().getTime());
            this.bind(parameterIndex, x, NzType.NZ_TIME);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String method = "setTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        this.bind(parameterIndex, x, NzType.NZ_TIMESTAMP);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String method = "setTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (cal != null) {
            this.bind(parameterIndex, x, NzType.NZ_TIMESTAMP);
        } else {
            cal.setTime(x);
            this.bind(parameterIndex, cal.getTime().getTime(), NzType.NZ_TIMESTAMP);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new NzMethodNotImplementedException("NzPreparedStatement", "setURL(int, URL)");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String method = "setUnicodeStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        this.bind(parameterIndex, x, NzType.NZ_BINARY, "UTF-8", length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] val;
        String method = "executeBatch";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        NzPreparedQuery query = (NzPreparedQuery)this.query;
        int size = query.batchSize();
        if (size < 2) {
            val = new int[1];
            this.connection.LOGGER.info(this.getClass(), method, "Batch execution with old way...");
            val[0] = this._executeUpdate();
        } else if (query.getQueryType() == NzQuery.QueryType.OTHER) {
            val = new int[size];
            for (int i = 0; i < size; ++i) {
                int numOfParam = query.getNumberOfParameters();
                String[] _params = new String[numOfParam];
                _params = query.get(i);
                String tempInsertSQL = query.toString();
                StringBuilder readyToExec = new StringBuilder();
                int currParamCount = 0;
                block11: for (int index = 0; index < tempInsertSQL.length(); ++index) {
                    char ch = tempInsertSQL.charAt(index);
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            char quote = ch;
                            readyToExec.append(ch);
                            while (index < tempInsertSQL.length() - 1) {
                                ch = tempInsertSQL.charAt(++index);
                                readyToExec.append(ch);
                                if (ch != quote) continue;
                                continue block11;
                            }
                            continue block11;
                        }
                        case '?': {
                            if (currParamCount < numOfParam && _params[currParamCount] != null) {
                                readyToExec.append(_params[currParamCount]);
                                ++currParamCount;
                                continue block11;
                            }
                            throw new NzSQLException("netezza.prep.param", "HY010", 11410, new Integer(currParamCount + 1));
                        }
                        default: {
                            readyToExec.append(ch);
                        }
                    }
                }
                this.execute(readyToExec.toString());
                val[i] = -2;
            }
        } else {
            int i;
            val = new int[size];
            this.connection.LOGGER.info(this.getClass(), method, "Batch execution with bulk load...");
            this.connection.setBulkLoad(true);
            String tableName = "bulkETL_" + this.connection.pid + "_" + this.bulkLoadNumber++;
            try {
                this.connection.execute(new BulkExtTableDefinitionQuery(tableName, query.getNumberOfParameters()));
            }
            catch (Exception e) {
                this.connection.setBulkLoad(false);
                NzSQLException etothrow = new NzSQLException("netezza.ext.table.create.failed", "HY000", 1100, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
            for (i = 0; i < query.getNumberOfParameters(); ++i) {
                if (query.getParamBinary(i + 1) == 1) {
                    query.setParameter(i + 1, "to_unkbinary(" + tableName + ".c" + i + ")");
                    continue;
                }
                query.setParameter(i + 1, tableName + ".c" + i);
            }
            try {
                this._executeUpdate();
            }
            catch (SQLException e) {
                if (this.connection.getAutoCommit()) {
                    this.connection.execute(new NzSimpleQuery("drop table " + tableName));
                }
                this.connection.setBulkLoad(false);
                throw e;
            }
            for (i = 0; i < val.length; ++i) {
                val[i] = -2;
            }
            this.connection.setBulkLoad(false);
            try {
                this.connection.execute(new NzSimpleQuery("drop table " + tableName));
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        query.clearBatch();
        query.clearParameters();
        return val;
    }

    protected boolean _execute(NzQuery query) throws SQLException {
        if (query == null) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.nullquery", "HY009", 11450, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "_execute", etothrow);
            throw etothrow;
        }
        this.set = this.connection.execute(this, query);
        return this.set != null;
    }

    protected void prepare() throws SQLException {
        String method = "prepare";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.debug(this.getClass(), method, (Object)this.query.getQueryType());
        this.parameterMetadata = new NzParameterMetadata(((NzPreparedQuery)this.query).getNumberOfParameters());
        switch (this.query.getQueryType()) {
            case SELECT: 
            case WITH: 
            case SELECT_LIMIT: {
                this._execute(((NzPreparedQuery)this.query).toPreparedQuery());
                break;
            }
            case BATCH: {
                if (((NzPreparedQuery)this.query).getNumberOfParameters() <= 0) break;
                NzSQLException etothrow = new NzSQLException("netezza.stmt.batch.param.marker", "42000", 11411, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    protected void bind(int index, Object parameter, NzType type) throws SQLException {
        this.bind(index, parameter, type, null, 0);
    }

    protected synchronized void bind(int index, Object parameter, NzType type, String encoding, int length) throws SQLException {
        String method = "bind";
        this.connection.LOGGER.entry(this.getClass(), method, new Object[]{index, parameter, type, encoding, length});
        NzPreparedQuery query = (NzPreparedQuery)this.query;
        query.setParamBinary(index, 0);
        if (parameter == null) {
            if (type == NzType.NZ_VARBINARY) {
                query.setParamBinary(index, 1);
            }
            query.setParameter(index, "NULL");
            return;
        }
        switch (type) {
            case NZ_UNKNOWN: 
            case NZ_BYTEINT: 
            case NZ_SMALLINT: 
            case NZ_INTEGER: 
            case NZ_BIGINT: 
            case NZ_FLOAT: 
            case NZ_DOUBLE: 
            case NZ_NUMERIC: {
                query.setParameter(index, parameter.toString());
                break;
            }
            case NZ_TIME: {
                long fraction = ((Time)parameter).getTime() % 1000L;
                query.setParameter(index, "'" + parameter + "." + fraction + "'");
                break;
            }
            case NZ_BOOL: 
            case NZ_INTERVAL: 
            case NZ_DATE: 
            case NZ_TIMEZONE: {
                query.setParameter(index, "'" + parameter + "'");
                break;
            }
            case NZ_TIMESTAMP: {
                this.bindBuffer.setLength(0);
                Timestamp x = (Timestamp)parameter;
                this.bindBuffer.ensureCapacity(32);
                this.bindBuffer.append("'");
                int l_year = x.getYear() + 1900;
                this.bindBuffer.append(l_year);
                this.bindBuffer.append('-');
                int l_month = x.getMonth() + 1;
                if (l_month < 10) {
                    this.bindBuffer.append('0');
                }
                this.bindBuffer.append(l_month);
                this.bindBuffer.append('-');
                int l_day = x.getDate();
                if (l_day < 10) {
                    this.bindBuffer.append('0');
                }
                this.bindBuffer.append(l_day);
                this.bindBuffer.append(' ');
                int l_hours = x.getHours();
                if (l_hours < 10) {
                    this.bindBuffer.append('0');
                }
                this.bindBuffer.append(l_hours);
                this.bindBuffer.append(':');
                int l_minutes = x.getMinutes();
                if (l_minutes < 10) {
                    this.bindBuffer.append('0');
                }
                this.bindBuffer.append(l_minutes);
                this.bindBuffer.append(':');
                int l_seconds = x.getSeconds();
                if (l_seconds < 10) {
                    this.bindBuffer.append('0');
                }
                this.bindBuffer.append(l_seconds);
                char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] l_nanos = Integer.toString(x.getNanos()).toCharArray();
                System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
                this.bindBuffer.append('.');
                this.bindBuffer.append(l_decimal, 0, 6);
                this.bindBuffer.append("'");
                query.setParameter(index, "'" + parameter + "'");
                break;
            }
            case NZ_BINARY: {
                if (parameter instanceof InputStream) {
                    try {
                        InputStream stream = (InputStream)parameter;
                        byte[] bytes = new byte[length];
                        int charsRead = stream.read(bytes, 0, length);
                        if (encoding == null) {
                            this.converToDbDtring(new String(bytes, 0, charsRead));
                        } else {
                            this.converToDbDtring(new String(bytes, 0, charsRead, encoding));
                        }
                        query.setParameter(index, this.bindBuffer.toString());
                        break;
                    }
                    catch (IOException e) {
                        NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
                        this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                        throw etothrow;
                    }
                }
                if (parameter instanceof Reader) {
                    try {
                        Reader reader = (Reader)parameter;
                        char[] chars = new char[length];
                        int charsRead = reader.read(chars, 0, length);
                        this.converToDbDtring(new String(chars, 0, charsRead));
                        query.setParameter(index, this.bindBuffer.toString());
                        break;
                    }
                    catch (IOException e) {
                        NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
                        this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                        throw etothrow;
                    }
                }
                if (parameter instanceof byte[]) {
                    byte[] bytes = (byte[])parameter;
                    this.bindBuffer.setLength(0);
                    for (int i = 0; i < bytes.length; ++i) {
                        int next = bytes[i];
                        if (next < 0) {
                            next = 256 + next;
                        }
                        if (next < 32 || next > 126) {
                            this.bindBuffer.append('\\');
                            this.bindBuffer.append((char)((next >> 6 & 3) + 48));
                            this.bindBuffer.append((char)((next >> 3 & 7) + 48));
                            this.bindBuffer.append((char)((next & 7) + 48));
                            continue;
                        }
                        if (bytes[i] == 92) {
                            this.bindBuffer.append("\\\\");
                            continue;
                        }
                        if (bytes[i] == 39) {
                            this.bindBuffer.append('\'');
                            this.bindBuffer.append((char)bytes[i]);
                            continue;
                        }
                        this.bindBuffer.append((char)bytes[i]);
                    }
                    query.setParameter(index, "'" + this.bindBuffer.toString() + "'");
                    break;
                }
                this.converToDbDtring(parameter.toString());
                query.setParameter(index, this.bindBuffer.toString());
                break;
            }
            case NZ_GEOMETRY: 
            case NZ_VARBINARY: {
                query.setParamBinary(index, 1);
                query.setParameter(index, NzType.byteArrToHexString((byte[])parameter));
                break;
            }
            case NZ_CHAR: 
            case NZ_VARCHAR: 
            case NZ_VARFIXEDCHAR: 
            case NZ_NCHAR: 
            case NZ_NVARCHAR: 
            case NZ_JSON: 
            case NZ_JSONB: 
            case NZ_JSONPATH: {
                this.converToDbDtring(parameter.toString());
                query.setParameter(index, this.bindBuffer.toString());
            }
        }
    }

    private synchronized void converToDbDtring(String str) {
        int len = str.length();
        this.bindBuffer.setLength(0);
        this.bindBuffer.append('\'');
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                this.bindBuffer.append('\'');
            }
            this.bindBuffer.append(c);
        }
        this.bindBuffer.append('\'');
    }

    public static String convertHexStringToBinaryString(String hexString) {
        int hexlen = hexString.length();
        StringBuilder sbuffer = new StringBuilder();
        if (hexString.equalsIgnoreCase("NULL")) {
            sbuffer.append("NULL");
            return sbuffer.toString();
        }
        sbuffer.append('\'');
        for (int i = 2; i < hexlen - 1; i += 2) {
            char c = (char)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
            if (c == '\u0000' || c == '\t' || c == '\n' || c == '\'' || c == '\\') {
                sbuffer.append('\\');
            }
            sbuffer.append(c);
        }
        sbuffer.append('\'');
        return sbuffer.toString();
    }

    public Date toDate(String s) throws NzSQLException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(15, 0);
        cal.set(16, 0);
        this.loadCalendar(cal, s);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date result = new Date(cal.getTime().getTime());
        return result;
    }

    public Time toTime(String s) throws NzSQLException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(15, 0);
        cal.set(16, 0);
        this.loadCalendar(cal, s);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(0, 1);
        Time result = new Time(cal.getTime().getTime());
        return result;
    }

    private Timestamp toTimestamp(String s) throws NzSQLException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(15, 0);
        cal.set(16, 0);
        int nanos = this.loadCalendar(cal, s);
        Timestamp result = new Timestamp(cal.getTime().getTime());
        result.setNanos(nanos);
        return result;
    }

    private int loadCalendar(GregorianCalendar cal, String s) throws NzSQLException {
        String method = "loadCalendar";
        cal.setTime(new java.util.Date(0L));
        int nanos = 0;
        try {
            int start = 0;
            int end = this.firstNonDigit(s, start);
            int num = this.number(s, start, end);
            char sep = this.charAt(s, end);
            if (sep == '-') {
                cal.set(1, num);
                start = end + 1;
                end = this.firstNonDigit(s, start);
                num = this.number(s, start, end);
                cal.set(2, num - 1);
                start = end + 1;
                end = this.firstNonDigit(s, start);
                num = this.number(s, start, end);
                cal.set(5, num);
                start = end + 1;
                while (this.charAt(s, start) == ' ') {
                    ++start;
                }
                end = this.firstNonDigit(s, start);
                try {
                    num = this.number(s, start, end);
                }
                catch (Exception e) {
                    // empty catch block
                }
                sep = this.charAt(s, end);
            }
            if (sep == ':') {
                cal.set(11, num);
                start = end + 1;
                end = this.firstNonDigit(s, start);
                num = this.number(s, start, end);
                cal.set(12, num);
                start = end + 1;
                end = this.firstNonDigit(s, start);
                num = this.number(s, start, end);
                cal.set(13, num);
                start = end + 1;
                sep = this.charAt(s, end);
                if (sep == '.') {
                    end = this.firstNonDigit(s, start);
                    nanos = num = this.number(s, start, end);
                }
            }
        }
        catch (Exception e) {
            NzSQLException etothrow = new NzSQLException("netezza.date.time.parse", "HY000", 1100, s);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        return nanos;
    }

    private int firstNonDigit(String s, int start) {
        int slen = s.length();
        for (int i = start; i < slen; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return i;
        }
        return slen;
    }

    private int number(String s, int start, int end) {
        if (start >= end) {
            throw new NumberFormatException();
        }
        String num = s.substring(start, end);
        return Integer.parseInt(num);
    }

    private char charAt(String s, int pos) {
        if (pos >= 0 && pos < s.length()) {
            return s.charAt(pos);
        }
        return '\u0000';
    }

    @Override
    public Loader getLoader() {
        if (this.connection.isBulkLoad()) {
            return this.loader;
        }
        return super.getLoader();
    }

    public void isExtTblLoadErrorOccurred(boolean flag) {
        if (this.loader instanceof NzBulkLoad) {
            ((NzBulkLoad)this.loader).setParserAborted(flag);
        }
    }

    public void nzBulkLoad() {
        ((NzBulkLoad)this.loader).load();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "setAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setAsciiStream");
            this.connection.LOGGER.fatal(this.getClass(), "setAsciiStream", etothrow);
            throw etothrow;
        }
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBinaryStream");
            this.connection.LOGGER.fatal(this.getClass(), "setBinaryStream", etothrow);
            throw etothrow;
        }
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setCharacterStream");
            this.connection.LOGGER.fatal(this.getClass(), "setCharacterStream", etothrow);
            throw etothrow;
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "setBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBlob");
        this.connection.LOGGER.fatal(this.getClass(), "setBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBlob");
        this.connection.LOGGER.fatal(this.getClass(), "setBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setClob");
        this.connection.LOGGER.fatal(this.getClass(), "setClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setClob");
        this.connection.LOGGER.fatal(this.getClass(), "setClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNString");
        this.connection.LOGGER.fatal(this.getClass(), "setNString", etothrow);
        throw etothrow;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setRowId");
        this.connection.LOGGER.fatal(this.getClass(), "setRowId", etothrow);
        throw etothrow;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "setSQLXML", etothrow);
        throw etothrow;
    }

    private static enum JavaTypes {
        String{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type) || this.isBinaryString(type) || this.isDate(type) || this.isTime(type) || this.isTimestamp(type);
            }

            @Override
            int getSqlType() {
                return 12;
            }
        }
        ,
        BigDecimal{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 2;
            }
        }
        ,
        Boolean{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 16;
            }
        }
        ,
        Integer{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 4;
            }
        }
        ,
        Long{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return -5;
            }
        }
        ,
        Float{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 7;
            }
        }
        ,
        Double{

            @Override
            boolean isValidMapping(int type) {
                return this.isNumber(type) || this.isBoolean(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 8;
            }
        }
        ,
        ByteArray{

            @Override
            boolean isValidMapping(int type) {
                return this.isBinaryString(type);
            }

            @Override
            int getSqlType() {
                return -3;
            }
        }
        ,
        Date{

            @Override
            boolean isValidMapping(int type) {
                return this.isDate(type) || this.isTimestamp(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 91;
            }
        }
        ,
        Time{

            @Override
            boolean isValidMapping(int type) {
                return this.isTime(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 92;
            }
        }
        ,
        Timestamp{

            @Override
            boolean isValidMapping(int type) {
                return this.isTime(type) || this.isDate(type) || this.isTimestamp(type) || this.isCharString(type);
            }

            @Override
            int getSqlType() {
                return 93;
            }
        }
        ,
        Array{

            @Override
            boolean isValidMapping(int type) {
                return type == 2003;
            }

            @Override
            int getSqlType() {
                return 2003;
            }
        }
        ,
        Blob{

            @Override
            boolean isValidMapping(int type) {
                return type == 2004;
            }

            @Override
            int getSqlType() {
                return 2004;
            }
        }
        ,
        Clob{

            @Override
            boolean isValidMapping(int type) {
                return type == 2005;
            }

            @Override
            int getSqlType() {
                return 2005;
            }
        }
        ,
        Struct{

            @Override
            boolean isValidMapping(int type) {
                return type == 2002;
            }

            @Override
            int getSqlType() {
                return 2002;
            }
        }
        ,
        Ref{

            @Override
            boolean isValidMapping(int type) {
                return type == 2006;
            }

            @Override
            int getSqlType() {
                return 2006;
            }
        }
        ,
        URL{

            @Override
            boolean isValidMapping(int type) {
                return type == 70;
            }

            @Override
            int getSqlType() {
                return 70;
            }
        }
        ,
        Other{

            @Override
            boolean isValidMapping(int type) {
                return type == 2000;
            }

            @Override
            int getSqlType() {
                return 2000;
            }
        };

        private static final Map<String, JavaTypes> canonicalNames;

        static JavaTypes getJavaType(Object x) {
            if (x == null) {
                return Other;
            }
            if (x instanceof Array) {
                return Array;
            }
            if (x instanceof Blob) {
                return Blob;
            }
            if (x instanceof Clob) {
                return Clob;
            }
            if (x instanceof Struct) {
                return Struct;
            }
            if (x instanceof Ref) {
                return Ref;
            }
            JavaTypes returnVal = canonicalNames.get(x.getClass().getCanonicalName());
            if (returnVal == null) {
                return Other;
            }
            return returnVal;
        }

        abstract boolean isValidMapping(int var1);

        protected boolean isNumber(int type) {
            switch (type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isCharString(int type) {
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isBoolean(int type) {
            switch (type) {
                case -7: 
                case 16: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isBinaryString(int type) {
            switch (type) {
                case -4: 
                case -3: 
                case -2: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isDate(int type) {
            switch (type) {
                case 91: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isTime(int type) {
            switch (type) {
                case 92: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isTimestamp(int type) {
            switch (type) {
                case 93: {
                    return true;
                }
            }
            return false;
        }

        abstract int getSqlType();

        static {
            canonicalNames = new HashMap<String, JavaTypes>();
            canonicalNames.put(String.class.getCanonicalName(), String);
            canonicalNames.put(BigDecimal.class.getCanonicalName(), BigDecimal);
            canonicalNames.put(Boolean.class.getCanonicalName(), Boolean);
            canonicalNames.put(Byte.class.getCanonicalName(), Integer);
            canonicalNames.put(Short.class.getCanonicalName(), Integer);
            canonicalNames.put(Integer.class.getCanonicalName(), Integer);
            canonicalNames.put(Long.class.getCanonicalName(), Long);
            canonicalNames.put(Float.class.getCanonicalName(), Float);
            canonicalNames.put(Double.class.getCanonicalName(), Double);
            canonicalNames.put(Date.class.getCanonicalName(), Date);
            canonicalNames.put(Time.class.getCanonicalName(), Time);
            canonicalNames.put(Timestamp.class.getCanonicalName(), Timestamp);
            canonicalNames.put(URL.class.getCanonicalName(), URL);
            canonicalNames.put("byte[]", ByteArray);
        }
    }

    private class BulkExtTableDefinitionQuery
    extends NzQuery {
        final String tableName;
        final StringBuilder buffer;
        final int columns;
        static final String USING_CLAUSE = " USING (  DATAOBJECT('/tmp/junk')  REMOTESOURCE 'jdbc'  DELIMITER '\t'  ESCAPECHAR '\\'  CTRLCHARS 'YES'  CRINSTRING 'YES'  ENCODING 'INTERNAL'  MAXERRORS 1 QUOTEDVALUE 'YES' );";
        final int columnSize;

        public BulkExtTableDefinitionQuery(String tableName, int columns) {
            this.tableName = tableName;
            this.buffer = new StringBuilder();
            this.columns = columns;
            this.columnSize = 64000 / columns < 16000 ? 64000 / columns : 16000;
            this.generate();
        }

        void generate() {
            int colLength = 0;
            this.buffer.append(" CREATE EXTERNAL TABLE " + this.tableName + " ( ");
            for (int i = 0; i < this.columns; ++i) {
                colLength = ((NzPreparedQuery)NzPreparedStatament.this.query).getMaxParamLength(i);
                if (colLength > 16000) {
                    this.buffer.append("c" + i + " varchar(" + colLength + ")");
                } else {
                    this.buffer.append("c" + i + " nvarchar(" + colLength + ")");
                }
                if (i >= this.columns - 1) continue;
                this.buffer.append(',');
            }
            this.buffer.append(" ) ");
            this.buffer.append(USING_CLAUSE);
        }

        @Override
        public NzQuery.QueryType getQueryType() {
            return NzQuery.QueryType.OTHER;
        }

        @Override
        public boolean isParsed() {
            return false;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return this.buffer.toString();
        }

        @Override
        public String toString() {
            return this.buffer.toString();
        }
    }

    private class NzBulkLoad
    extends NzLoad {
        int blockSize;
        byte[] blockBuffer;
        StringBuilder buffer;
        private boolean parserAborted;

        public NzBulkLoad() {
            super(NzPreparedStatament.this.connection);
        }

        @Override
        public boolean isReading() {
            return false;
        }

        @Override
        public void processLogs(String logDir, String fileName, int logType) throws SQLException {
            if (this.parserAborted) {
                if (logDir.equals("/tmp")) {
                    if (NzPreparedStatament.this.connection.getDatasource() != null) {
                        logDir = NzPreparedStatament.this.connection.getDatasource().getLogDirPath();
                    } else if (NzConstants.OS.startsWith("windows")) {
                        logDir = "C:";
                    }
                }
                super.processLogs(logDir, fileName, logType);
            } else {
                int numBytes = 0;
                while ((numBytes = NzPreparedStatament.this.connection.receiveIntR(4)) != 0) {
                    NzPreparedStatament.this.connection.receiveBytes(numBytes);
                }
            }
        }

        @Override
        public boolean setUp() throws SQLException {
            String method = "setUp";
            NzPreparedStatament.this.connection.LOGGER.entry(this.getClass(), method);
            int clientVersion = 1;
            NzPreparedStatament.this.connection.receiveString();
            NzPreparedStatament.this.connection.receiveIntR(4);
            NzPreparedStatament.this.connection.sendInt(clientVersion, 4);
            NzPreparedStatament.this.connection.flush();
            NzPreparedStatament.this.connection.receiveIntR(4);
            this.blockSize = NzPreparedStatament.this.connection.receiveIntR(4);
            NzPreparedStatament.this.connection.LOGGER.debug(this.getClass(), method, "BLOCK SIZE: " + this.blockSize);
            if (this.blockSize <= 0) {
                NzPreparedStatament.this.connection.setBulkLoad(false);
                throw new NzSQLException("ntezza.ext.table.invalid.block.size", "HY000", 1100, this.blockSize);
            }
            this.blockBuffer = new byte[this.blockSize];
            this.buffer = new StringBuilder();
            NzPreparedStatament.this.connection.LOGGER.exit(this.getClass(), method, true);
            return true;
        }

        public void load() {
            String method = "load";
            NzPreparedStatament.this.connection.LOGGER.entry(this.getClass(), method);
            try {
                int totalBytes = 0;
                int count = 0;
                NzPreparedQuery query = (NzPreparedQuery)NzPreparedStatament.this.query;
                String[] params = null;
                int length = query.batchSize();
                for (int index = 0; index < length; ++index) {
                    byte[] bytes;
                    params = query.get(index);
                    this.buffer.setLength(0);
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) {
                            this.buffer.append("NULL");
                        } else {
                            boolean isParamBinary;
                            boolean bl = isParamBinary = query.getParamBinary(i + 1) == 1;
                            if (isParamBinary) {
                                this.buffer.append(NzPreparedStatament.convertHexStringToBinaryString(params[i]));
                            } else {
                                int len = params[i].length();
                                for (int j = 0; j < len; ++j) {
                                    char c = params[i].charAt(j);
                                    if (c == '\\' || c == '\t' || c == '\n') {
                                        this.buffer.append('\\');
                                    }
                                    this.buffer.append(c);
                                }
                            }
                        }
                        if (i >= params.length - 1) continue;
                        this.buffer.append('\t');
                    }
                    if (++count < query.batchSize()) {
                        this.buffer.append('\n');
                    }
                    if (totalBytes + (bytes = this.buffer.toString().getBytes("UTF-8")).length > this.blockBuffer.length) {
                        NzPreparedStatament.this.connection.sendInt(1, 4);
                        NzPreparedStatament.this.connection.sendInt(totalBytes, 4);
                        NzPreparedStatament.this.connection.sendBytes(this.blockBuffer, totalBytes);
                        NzPreparedStatament.this.connection.flush();
                        totalBytes = 0;
                    }
                    System.arraycopy(bytes, 0, this.blockBuffer, totalBytes, bytes.length);
                    totalBytes += bytes.length;
                }
                if (!NzPreparedStatament.this.connection.stopLoading) {
                    NzPreparedStatament.this.connection.sendInt(1, 4);
                    NzPreparedStatament.this.connection.sendInt(totalBytes, 4);
                    NzPreparedStatament.this.connection.sendBytes(this.blockBuffer, totalBytes);
                    NzPreparedStatament.this.connection.flush();
                    NzPreparedStatament.this.connection.sendInt(3, 4);
                    NzPreparedStatament.this.connection.flush();
                } else {
                    NzPreparedStatament.this.connection.sendInt(2, 4);
                    NzPreparedStatament.this.connection.sendInt(3, 4);
                    String errormsg = "ET load is aborted";
                    NzPreparedStatament.this.connection.sendInt(errormsg.length() + 1, 4);
                    NzPreparedStatament.this.connection.sendBytes(Encoding.UNICODE.encode(errormsg));
                    NzPreparedStatament.this.connection.sendChar('\u0000');
                    String errormsg1 = "NzXferExtTable.run";
                    NzPreparedStatament.this.connection.sendInt(errormsg1.length() + 1, 4);
                    NzPreparedStatament.this.connection.sendBytes(Encoding.UNICODE.encode(errormsg1));
                    NzPreparedStatament.this.connection.sendChar('\u0000');
                    NzPreparedStatament.this.connection.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setParserAborted(boolean parserAborted) {
            this.parserAborted = parserAborted;
        }
    }
}

