/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzSQLException;
import org.netezza.internal.PgType;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzPreparedStatament;
import org.netezza.sql.query.NzCallableQuery;

public class NzCallableStatement
extends NzPreparedStatament
implements CallableStatement {
    private static final int RESULTINDEX = 1;
    private final HashMap<Integer, Integer> outParamMap = new HashMap();
    private final HashMap<Integer, Integer> numericScaleMap = new HashMap();
    private boolean wasNull;
    private List<Integer> inParamIndexList;
    private List<Integer> resParamIndexList;
    private int totalParams;

    public NzCallableStatement(NzConnection connection, String sql) throws SQLException {
        super(connection);
        this.query = new NzCallableQuery(connection, sql).parse();
        this.prepare();
        this.inParamIndexList = ((NzCallableQuery)this.query).getParam().getInParam().getInParamIndex();
        this.resParamIndexList = ((NzCallableQuery)this.query).getParam().getOutParam().getResParamIndex();
        this.totalParams = ((NzCallableQuery)this.query).getNumberOfParameters();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        int scale;
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(2);
        if (this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        int prevScaleOfColumn = rs.getMetaData().getScale(parameterIndex);
        int n = scale = this.outParamMap.containsKey(parameterIndex) && this.numericScaleMap.get(parameterIndex) < prevScaleOfColumn ? this.numericScaleMap.get(parameterIndex) : prevScaleOfColumn;
        if (rs.next()) {
            BigDecimal colValue = rs.getBigDecimal(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            if (scale != prevScaleOfColumn) {
                colValue = colValue.setScale(scale, 6);
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return colValue;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, scale);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(2);
        if (this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (scale < 0) {
            NzSQLException ex = new NzSQLException("scale must be greater than or equal to zero", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            BigDecimal colValue = rs.getBigDecimal(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return colValue.setScale(scale, 6);
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        String method = "getBoolean";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(-7);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            boolean value = rs.getBoolean(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return false;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        String method = "getByte";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(-6);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            byte values = rs.getByte(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return values;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(91);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Date date = rs.getDate(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return date;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        String method = "getDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, cal);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(91);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Date date = rs.getDate(parameterIndex, cal);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return date;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        String method = "getDouble";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(8);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            double value = rs.getDouble(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0.0;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        String method = "getFloat";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(6);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            float value = rs.getFloat(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0.0f;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        String method = "getInt";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(4);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            int value = rs.getInt(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        String method = "getLong";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(-5);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Long value = rs.getLong(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0L;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        String method = "getShort";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(5);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            short value = rs.getShort(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return 0;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        String method = "getString";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(1);
        types.add(12);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            String value = rs.getString(parameterIndex);
            this.wasNull = rs.wasNull();
            this.connection.LOGGER.exit(this.getClass(), method);
            return value;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(92);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Time time = rs.getTime(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return time;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        String method = "getTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(92);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Time time = rs.getTime(parameterIndex, cal);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return time;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(93);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Timestamp timestamp = rs.getTimestamp(parameterIndex);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return timestamp;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        String method = "getTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, cal);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(93);
        if (!this.isOutParameterRegistered(parameterIndex, types)) {
            OutParameterNorRegisteredException ex = new OutParameterNorRegisteredException();
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ResultSet rs = this.getResultSet();
        if (rs.next()) {
            Timestamp timestamp = rs.getTimestamp(parameterIndex, cal);
            this.wasNull = rs.wasNull();
            if (this.wasNull) {
                this.connection.LOGGER.exit(this.getClass(), method);
                return null;
            }
            this.connection.LOGGER.exit(this.getClass(), method);
            return timestamp;
        }
        NzSQLException ex = new NzSQLException("This procedure call doesn't return value", "HY000", 1100, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, ex);
        throw ex;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw new OutParameterNorRegisteredException();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        PgType[] types;
        String method = "registerOutParameter";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType);
        if (!((NzCallableQuery)this.query).isCallableQuery()) {
            NzSQLException ex = new NzSQLException("SQL statement is not callable", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (((NzCallableQuery)this.query).getParam().getOutParam().getNumberOfResParams() < 1) {
            NzSQLException ex = new NzSQLException("only out/result parameters can be registered", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        boolean isValidSQLType = false;
        if (parameterIndex != 1) {
            NzSQLException ex = new NzSQLException("out parameters are not supported \n Instructions: \n\t\tuse result parameter for getting result", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        for (PgType type : types = PgType.values()) {
            if (sqlType != type.getSqlType()) continue;
            isValidSQLType = true;
        }
        if (!isValidSQLType) {
            NzSQLException ex = new NzSQLException("result parameter type is not supported", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        this.outParamMap.put(parameterIndex, sqlType);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        String method = "registerOutParameter";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType, scale);
        this.registerOutParameter(parameterIndex, sqlType);
        if (scale < 0) {
            NzSQLException ex = new NzSQLException("scale must be greater than or equal to zero", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        this.numericScaleMap.put(parameterIndex, scale);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        String method = "registerOutParameter";
        this.connection.LOGGER.entry(this.getClass(), method, paramIndex, sqlType, typeName);
        this.registerOutParameter(paramIndex, sqlType);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new NamedParametersNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        String method = "registerOutParameter";
        this.connection.LOGGER.entry(this.getClass(), method, i, x);
        if (i < 1 || i > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, i);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(i)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setArray(i, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String method = "setAsciiStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setAsciiStream(parameterIndex, x, length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String method = "setBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setBigDecimal(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String method = "setBinaryStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setBinaryStream(parameterIndex, x, length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        String method = "setBoolean";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setBoolean(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        String method = "setByte";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setByte(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        String method = "setBytes";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setBytes(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String method = "setCharacterStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, reader, length);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setCharacterStream(parameterIndex, reader, length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String method = "setDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setDate(parameterIndex, x, cal);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        String method = "setDate";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String method = "setDouble";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setDouble(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        String method = "setFloat";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, Float.valueOf(x));
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setFloat(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        String method = "setInt";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setInt(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        String method = "setLong";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setLong(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        String method = "setNull";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType, typeName);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setNull(parameterIndex, sqlType, typeName);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String method = "setNull";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, sqlType);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setNull(parameterIndex, sqlType);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, targetSqlType, scale);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setObject(parameterIndex, x, targetSqlType, scale);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, targetSqlType);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setObject(parameterIndex, x, targetSqlType);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        String method = "setObject";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setObject(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        String method = "setRef";
        this.connection.LOGGER.entry(this.getClass(), method, i, x);
        if (i < 1 || i > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, i);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(i)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setRef(i, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        String method = "setShort";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setShort(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        String method = "setString";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setString(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String method = "setTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setTime(parameterIndex, x, cal);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        String method = "setTime";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setTime(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String method = "setTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, cal);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setTimestamp(parameterIndex, x, cal);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String method = "setTimestamp";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setTimestamp(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String method = "setUnicodeStream";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x, length);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setUnicodeStream(parameterIndex, x, length);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        String method = "setURL";
        this.connection.LOGGER.entry(this.getClass(), method, parameterIndex, x);
        if (parameterIndex < 1 || parameterIndex > this.totalParams) {
            NzSQLException ex = new NzSQLException("netezza.param.idx.out.of.range", "07009", 11430, parameterIndex);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.inParamIndexList.contains(parameterIndex)) {
            NzSQLException ex = new NzSQLException("Value can be set for IN/INOUT parameter type only", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        super.setURL(parameterIndex, x);
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new BatchUpdateException("NZ: Stored Procedure call always returns a Result Set", "HY000", 11401, null);
    }

    protected boolean isOutParameterRegistered(int paramIndex, List<Integer> types) {
        String method = "isOutParameterRegistered";
        this.connection.LOGGER.entry(this.getClass(), method, paramIndex, types);
        if (!this.outParamMap.containsKey(paramIndex)) {
            return false;
        }
        int sqlType = this.outParamMap.get(paramIndex);
        if (!types.contains(sqlType)) {
            this.connection.LOGGER.exit(this.getClass(), method);
            return false;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return true;
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "getNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNClob");
        this.connection.LOGGER.fatal(this.getClass(), "getNClob", etothrow);
        throw etothrow;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNClob");
        this.connection.LOGGER.fatal(this.getClass(), "getNClob", etothrow);
        throw etothrow;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNString");
        this.connection.LOGGER.fatal(this.getClass(), "getNString", etothrow);
        throw etothrow;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNString");
        this.connection.LOGGER.fatal(this.getClass(), "getNString", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getObject");
        this.connection.LOGGER.fatal(this.getClass(), "getObject", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getObject");
        this.connection.LOGGER.fatal(this.getClass(), "getObject", etothrow);
        throw etothrow;
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getRowId");
        this.connection.LOGGER.fatal(this.getClass(), "getRowId", etothrow);
        throw etothrow;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getRowId");
        this.connection.LOGGER.fatal(this.getClass(), "getRowId", etothrow);
        throw etothrow;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "getSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "getSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "setAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setAsciiStream");
        this.connection.LOGGER.fatal(this.getClass(), "setAsciiStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "setBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBinaryStream");
        this.connection.LOGGER.fatal(this.getClass(), "setBinaryStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBlob");
        this.connection.LOGGER.fatal(this.getClass(), "setBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBlob");
        this.connection.LOGGER.fatal(this.getClass(), "setBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setBlob");
        this.connection.LOGGER.fatal(this.getClass(), "setBlob", etothrow);
        throw etothrow;
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setClob");
        this.connection.LOGGER.fatal(this.getClass(), "setClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setClob");
        this.connection.LOGGER.fatal(this.getClass(), "setClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setClob");
        this.connection.LOGGER.fatal(this.getClass(), "setClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNCharacterStream");
        this.connection.LOGGER.fatal(this.getClass(), "setNCharacterStream", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNClob");
        this.connection.LOGGER.fatal(this.getClass(), "setNClob", etothrow);
        throw etothrow;
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNString");
        this.connection.LOGGER.fatal(this.getClass(), "setNString", etothrow);
        throw etothrow;
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setRowId");
        this.connection.LOGGER.fatal(this.getClass(), "setRowId", etothrow);
        throw etothrow;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setSQLXML");
        this.connection.LOGGER.fatal(this.getClass(), "setSQLXML", etothrow);
        throw etothrow;
    }

    private class NamedParametersNotSupportedException
    extends NzSQLException {
        private static final String key = "named parameters not supported";

        public NamedParametersNotSupportedException() {
            super(key, "HY000", 1100, new Object[]{null});
        }
    }

    private class OutParameterNorRegisteredException
    extends NzSQLException {
        private static final String key = "out parameter not registered";

        public OutParameterNorRegisteredException() {
            super(key, "HY000", 1100, new Object[]{null});
        }
    }
}

