/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public enum PgType {
    PG_BOOLEAN("BOOLEAN", 16, -7, 1, 1, 0, false, false, Boolean.class.getName()),
    PG_NAME("NAME", 19, 1, 32768, 1, 0, true, false, String.class.getName()),
    PG_BPCHAR("CHAR", 1042, 1, 32768, 1, 0, true, false, String.class.getName()),
    PG_CHAR("CHAR", 18, 1, 32768, 1, 0, true, false, String.class.getName()),
    PG_VARCHAR("VARCHAR", 1043, 12, 32768, -1, 0, true, false, String.class.getName()),
    PG_NCHAR("NCHAR", 2522, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_NVARCHAR("NVCHAR", 2530, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_GEOMETRY("ST_GEOMETRY", 2552, -3, 32768, -1, 0, true, false, byte[].class.getName()),
    PG_VARBINARY("VARBINARY", 2568, -3, 32768, -1, 0, true, false, byte[].class.getName()),
    PG_INT2VECTOR("INT2VECTOR", 22, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_TEXT("TEXT", 25, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_REG_PROCEDURE("REGPROCEDURE", 24, -8, 8192, -1, 0, true, false, String.class.getName()),
    PG_BYTEINT("BYTEINT", 2500, -6, 4, 3, 0, false, true, Byte.class.getName()),
    PG_SMALLINT("SMALLINT", 21, 5, 6, 5, 0, false, true, Short.class.getName()),
    PG_INTEGER("INTEGER", 23, 4, 11, 10, 0, false, true, Integer.class.getName()),
    PG_BIGINT("BIGINT", 20, -5, 20, 19, 0, false, true, Long.class.getName()),
    PG_OID("OID", 26, 4, 11, 10, 0, false, true, Integer.class.getName()),
    PG_REAL("REAL", 700, 7, 13, 6, 0, false, true, Float.class.getName()),
    PG_FLOAT("FLOAT", 700, 6, 13, 6, 0, false, true, Float.class.getName()),
    PG_DOUBLE("DOUBLE", 701, 8, 22, 14, 0, false, true, Double.class.getName()),
    PG_NUMERIC("NUMERIC", 1700, 2, 38, 38, 37, false, true, BigDecimal.class.getName()),
    PG_DECIMAL("DECIMAL", 1700, 3, 38, 38, 37, false, true, BigDecimal.class.getName()),
    PG_DATE("DATE", 1082, 91, 10, 10, 0, false, false, Date.class.getName()),
    PG_TIME("TIME", 1083, 92, 15, 15, 6, false, false, Time.class.getName()),
    PG_TIMESTAMP("TIMESTAMP", 1184, 93, 26, 26, 6, false, false, Timestamp.class.getName()),
    PG_INTERVAL("INTERVAL", 1186, 101, 50, 50, 0, false, false, Object.class.getName()),
    PG_TIMETZ("TIMETZ", 1266, 12, 21, 21, 6, false, false, String.class.getName()),
    PG_ABSTIME("ABSTIME", 702, 93, 26, 26, 6, false, false, Timestamp.class.getName()),
    PG_JSON("JSON", 2652, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_JSONB("JSONB", 2653, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_JSONPATH("JSONPATH", 2654, 1, 8192, -1, 0, true, false, String.class.getName()),
    PG_UNKNOWN("VARCHAR", 0, 12, 32768, -1, 0, true, false, String.class.getName());

    private final String name;
    private final int oid;
    private final int sqlType;
    private final int size;
    private final short precision;
    private final short scale;
    private final short nullable = (short)2;
    private final boolean caseSensitive;
    private final boolean searchable = true;
    private final boolean signed;
    private final boolean autoIncrement = false;
    private final String className;

    private PgType(String name, int oid, int sqlType, int size, short precision, short scale, boolean caseSensitive, boolean signed, String className) {
        this.name = name;
        this.oid = oid;
        this.sqlType = sqlType;
        this.size = size;
        this.precision = precision;
        this.scale = scale;
        this.caseSensitive = caseSensitive;
        this.signed = signed;
        this.className = className;
    }

    public static PgType getPgType(int oid) {
        PgType[] types;
        for (PgType type : types = PgType.values()) {
            if (type.oid != oid) continue;
            return type;
        }
        return null;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getName() {
        return this.name;
    }

    public short getNullable() {
        return 2;
    }

    public int getOid() {
        return this.oid;
    }

    public short getPrecision() {
        return this.precision;
    }

    public short getScale() {
        return this.scale;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getSize() {
        return this.size;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getClassName() {
        return this.className;
    }
}

