/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import org.netezza.internal.NzQuery;
import org.netezza.internal.ParseException;

public class NzSimpleQuery
extends NzQuery {
    private final String query;
    private StringBuilder nativeQuery;
    private boolean parsed;
    private NzQuery.QueryType type;

    public NzSimpleQuery(String query) {
        this.query = query;
        this.nativeQuery = new StringBuilder();
    }

    @Override
    public NzQuery parse() throws ParseException {
        if (this.query == null) {
            throw new ParseException("Query can not be NULL");
        }
        if (!this.parsed && this.isEscapeProcessing()) {
            this.parsed = true;
            int index = 0;
            char c = '\u0000';
            int length = this.query.length();
            char next = '\u0000';
            StringBuilder buffer = new StringBuilder();
            StringBuilder newToken = new StringBuilder();
            block13: while (index < length) {
                c = this.query.charAt(index++);
                block0 : switch (c) {
                    case '\"': 
                    case '\'': {
                        char quote = c;
                        this.nativeQuery.append(c);
                        while (index < this.query.length()) {
                            c = this.query.charAt(index++);
                            this.nativeQuery.append(c);
                            if (c != quote) continue;
                            break block0;
                        }
                        continue block13;
                    }
                    case '/': {
                        if (this.type == null) {
                            newToken.append(c);
                        } else {
                            this.nativeQuery.append(c);
                        }
                        if (index == this.query.length()) break;
                        if (this.type == null) {
                            index = this.parseMultiLineComment(index, newToken);
                            break;
                        }
                        next = this.query.charAt(index++);
                        this.nativeQuery.append(next);
                        if (next != '*') continue block13;
                        while (index < this.query.length()) {
                            next = this.query.charAt(index++);
                            this.nativeQuery.append(next);
                            if (next != '*' || index >= this.query.length() || (next = this.query.charAt(index++)) != '/') continue;
                            this.nativeQuery.append(next);
                            break block0;
                        }
                        continue block13;
                    }
                    case '-': {
                        this.nativeQuery.append(c);
                        if (index == this.query.length()) break;
                        if ((next = this.query.charAt(index++)) == '-') {
                            do {
                                this.nativeQuery.append(next);
                            } while (index < this.query.length() && (next = this.query.charAt(index++)) != '\n');
                            if (next != '\n') continue block13;
                            this.nativeQuery.append(next);
                            break;
                        }
                        this.nativeQuery.append(next);
                        break;
                    }
                    case '{': {
                        buffer = new StringBuilder();
                        buffer.append(c);
                        int curlyBraceCounter = 1;
                        char quoteInEscape = '\u0000';
                        do {
                            if (index >= this.query.length()) {
                                throw new ParseException("Syntax Error");
                            }
                            c = this.query.charAt(index++);
                            if (quoteInEscape == '\u0000') {
                                switch (c) {
                                    case '{': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter + 1);
                                        break;
                                    }
                                    case '}': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter - 1);
                                        break;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        quoteInEscape = c;
                                        break;
                                    }
                                }
                            } else if (c == quoteInEscape) {
                                quoteInEscape = '\u0000';
                            }
                            buffer.append(c);
                        } while (curlyBraceCounter != 0);
                        StringBuilder escapeBuilder = new StringBuilder();
                        int val = this.parseEscapeSequence(buffer.toString(), escapeBuilder);
                        if (val == -2) {
                            this.nativeQuery.append(escapeBuilder + " ");
                            break;
                        }
                        if (val != -1) continue block13;
                        throw new ParseException("Syntax Error");
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        String type;
                        if (this.type == null && (type = this.nativeQuery.toString().trim().toUpperCase()) != null && type.length() != 0) {
                            this.type = NzQuery.QueryType.getType(type.toUpperCase());
                        }
                        this.nativeQuery.append(c);
                        break;
                    }
                    case ';': {
                        this.nativeQuery.append(c);
                        if (this.type == NzQuery.QueryType.BATCH) break;
                        while (index < this.query.length()) {
                            next = this.query.charAt(index++);
                            this.nativeQuery.append(next);
                            if (next == ' ' || next == '\t' || next == '\n') continue;
                            this.type = NzQuery.QueryType.BATCH;
                            break block0;
                        }
                        continue block13;
                    }
                    default: {
                        this.nativeQuery.append(c);
                    }
                }
            }
            if (newToken.length() > 0) {
                this.nativeQuery = new StringBuilder().append((CharSequence)newToken).append((CharSequence)this.nativeQuery);
            }
            if (this.type == null) {
                this.type = NzQuery.QueryType.OTHER;
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.query;
    }

    @Override
    public NzQuery.QueryType getQueryType() {
        return this.type;
    }

    @Override
    public String toNativeString() {
        return this.isEscapeProcessing() ? this.nativeQuery.toString() : this.query;
    }

    @Override
    public boolean isParsed() {
        return this.parsed;
    }

    private int parseMultiLineComment(int index, StringBuilder newToken) {
        char next = this.query.charAt(index++);
        newToken.append(next);
        if (next == '*') {
            while (index < this.query.length()) {
                next = this.query.charAt(index++);
                newToken.append(next);
                if (next != '*' || index >= this.query.length() || (next = this.query.charAt(index++)) != '/') continue;
                newToken.append(next);
                break;
            }
        }
        return index;
    }
}

