/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.netezza.core.Encoding;
import org.netezza.datasource.NzDatasource;
import org.netezza.error.NzSQLException;
import org.netezza.error.NzUnknownBackendResponseException;
import org.netezza.internal.NzSocket;

class GssAction
implements PrivilegedAction {
    private final NzSocket socket;
    private final NzDatasource datasource;

    public GssAction(NzSocket socket, NzDatasource datasource) {
        this.socket = socket;
        this.datasource = datasource;
    }

    public Object run() {
        return this.startContextEstablishment();
    }

    public String startContextEstablishment() {
        try {
            GSSManager manager = GSSManager.getInstance();
            Oid[] desiredMechs = new Oid[]{new Oid("1.2.840.113554.1.2.2")};
            String rawuser = this.datasource.getUser();
            if (rawuser.startsWith("\"") && rawuser.endsWith("\"")) {
                rawuser = rawuser.substring(1, rawuser.length() - 1);
            }
            String hostName = "";
            try {
                InetAddress host = InetAddress.getByName(this.datasource.getHost());
                hostName = host.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new IOException("Could not resolve the host name : " + hostName);
            }
            GSSCredential clientCreds = this.datasource.getGSSCredential();
            if (clientCreds == null) {
                clientCreds = manager.createCredential(1);
            }
            GSSName serverName = manager.createName("netezza@" + hostName, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = manager.createContext(serverName, desiredMechs[0], clientCreds, 0);
            secContext.requestMutualAuth(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            boolean established = false;
            while (!established) {
                outToken = secContext.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    this.socket.sendInt(4 + outToken.length, 4);
                    this.socket.sendBytes(outToken);
                    this.socket.flush();
                }
                if (!secContext.isEstablished()) {
                    char response = this.socket.receiveChar();
                    if (response == 'E') {
                        String errorMsg = this.receiveErrorString(Encoding.UNICODE);
                        return errorMsg;
                    }
                    if (response == 'R') {
                        int type = this.socket.receiveIntR(4);
                        if (type == 8) {
                            int len = this.socket.receiveIntR(4);
                            inToken = this.socket.receiveBytes(len);
                            continue;
                        }
                        return "Wrong type received : " + type;
                    }
                    NzUnknownBackendResponseException etothrow = new NzUnknownBackendResponseException(response);
                    return etothrow.getMessage();
                }
                established = true;
            }
        }
        catch (SQLException eSQL) {
            return eSQL.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (GSSException gsse) {
            return "GSSException : " + gsse.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveErrorString(Encoding encoding) throws SQLException {
        int s = 0;
        byte[] bs = new byte[8192];
        try {
            int buflen = bs.length;
            boolean done = false;
            block5: while (!done) {
                while (s < buflen) {
                    int c;
                    NzSocket nzSocket = this.socket;
                    synchronized (nzSocket) {
                        c = this.socket.receiveInt();
                    }
                    if (c < 0) {
                        throw new NzSQLException("netezza.con.closed.illegal.op", "HY000", 1115, new Object[0]);
                    }
                    if (c == 0) {
                        bs[s] = 0;
                        done = true;
                        continue block5;
                    }
                    bs[s++] = (byte)c;
                    if (s < buflen) continue;
                    byte[] newrst = new byte[buflen *= 2];
                    System.arraycopy(bs, 0, newrst, 0, s);
                    bs = newrst;
                }
            }
        }
        catch (IOException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            throw etothrow;
        }
        return encoding.decode(bs, 0, s);
    }
}

