/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.util.Hashtable;
import java.util.List;
import org.netezza.internal.ParseException;

public enum EscapeFunction {
    ABS{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "abs(" + arguments.get(0) + ')';
        }
    }
    ,
    ACOS{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "acos(" + arguments.get(0) + ')';
        }
    }
    ,
    ASIN{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "asin(" + arguments.get(0) + ')';
        }
    }
    ,
    ATAN{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "atan(" + arguments.get(0) + ')';
        }
    }
    ,
    ATAN2{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 2) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "atan2(" + arguments.get(0) + ',' + arguments.get(1) + ')';
        }
    }
    ,
    CEILING{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "ceil(" + arguments.get(0) + ')';
        }
    }
    ,
    COS{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "cos(" + arguments.get(0) + ')';
        }
    }
    ,
    COT{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "cot(" + arguments.get(0) + ')';
        }
    }
    ,
    DEGREES{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "degrees(" + arguments.get(0) + ')';
        }
    }
    ,
    EXP{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "exp(" + arguments.get(0) + ')';
        }
    }
    ,
    FLOOR{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "floor(" + arguments.get(0) + ')';
        }
    }
    ,
    LOG{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "ln(" + arguments.get(0) + ')';
        }
    }
    ,
    LOG10{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "log(" + arguments.get(0) + ')';
        }
    }
    ,
    MOD{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 2) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "mod(" + arguments.get(0) + ',' + arguments.get(1) + ')';
        }
    }
    ,
    PI{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 0) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "pi()";
        }
    }
    ,
    POWER{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 2) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "pow(" + arguments.get(0) + ',' + arguments.get(1) + ')';
        }
    }
    ,
    RADIANS{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "radians(" + arguments.get(0) + ')';
        }
    }
    ,
    RAND{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments == null || arguments.isEmpty()) {
                return "random()";
            }
            if (arguments.size() == 1) {
                return "(setseed(" + arguments.get(0) + ") * 0 + random())";
            }
            throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
        }
    }
    ,
    ROUND{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() == 1) {
                return "round(" + arguments.get(0) + ')';
            }
            if (arguments.size() == 2) {
                return "round(" + arguments.get(0) + ',' + arguments.get(1) + ')';
            }
            throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
        }
    }
    ,
    SIGN{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "sign(" + arguments.get(0) + ')';
        }
    }
    ,
    SIN{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "sin(" + arguments.get(0) + ')';
        }
    }
    ,
    SQRT{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "sqrt(" + arguments.get(0) + ')';
        }
    }
    ,
    TAN{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "tan(" + arguments.get(0) + ')';
        }
    }
    ,
    TRUNCATE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 2) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "trunc(" + arguments.get(0) + ',' + arguments.get(1) + ')';
        }
    }
    ,
    CONCAT{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            int size = arguments.size();
            for (int i = 0; i < size; ++i) {
                builder.append(arguments.get(i));
                if (i == arguments.size() - 1) continue;
                builder.append(" || ");
            }
            return builder.append(')').toString();
        }
    }
    ,
    LCASE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "lower(" + arguments.get(0) + ')';
        }
    }
    ,
    LENGTH{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "length(" + arguments.get(0) + ')';
        }
    }
    ,
    LOCATE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments != null && arguments.size() == 2) {
                return "position(" + arguments.get(0) + " in " + arguments.get(1) + ")";
            }
            if (arguments != null && arguments.size() == 3) {
                return "position(" + arguments.get(0) + " in substring(" + arguments.get(1) + " from " + arguments.get(2) + "))";
            }
            throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
        }
    }
    ,
    LTRIM{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "trim(leading from " + arguments.get(0) + ')';
        }
    }
    ,
    RTRIM{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "trim(trailing from " + arguments.get(0) + ')';
        }
    }
    ,
    SUBSTRING{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments != null && arguments.size() == 2) {
                return "substr(" + arguments.get(0) + "," + arguments.get(1) + ")";
            }
            if (arguments != null && arguments.size() == 3) {
                return "substr(" + arguments.get(0) + "," + arguments.get(1) + "," + arguments.get(2) + ")";
            }
            throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
        }
    }
    ,
    UCASE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 1) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "upper(" + arguments.get(0) + ')';
        }
    }
    ,
    CURDATE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 0) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "now()";
        }
    }
    ,
    NOW,
    DATABASE{

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 0) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            return "current_catalog";
        }
    }
    ,
    CONVERT{
        private final Hashtable<String, String> casts = new Hashtable();
        {
            this.casts.put("BIT", "boolean ");
            this.casts.put("BOOLEAN", "boolean ");
            this.casts.put("TINYINT", "byteint ");
            this.casts.put("SMALLINT", "smallint ");
            this.casts.put("INTEGER", "integer ");
            this.casts.put("BIGINT", "bigint ");
            this.casts.put("FLOAT", "float ");
            this.casts.put("REAL", "float ");
            this.casts.put("DOUBLE", "double ");
            this.casts.put("DECIMAL", "decimal ");
            this.casts.put("NUMERIC", "decimal ");
            this.casts.put("CHAR", "char(50) ");
            this.casts.put("VARCHAR", "varchar(50) ");
            this.casts.put("DATE", "date ");
            this.casts.put("TIME", "time ");
            this.casts.put("TIMESTAMP", "timestamp ");
        }

        @Override
        public final synchronized String invoke(List<String> arguments) throws ParseException {
            if (arguments.size() != 2) {
                throw new ParseException("Invalid Number of arguments for Escape Function " + (Object)((Object)this));
            }
            StringBuilder builder = new StringBuilder("cast( ");
            builder.append(arguments.get(0).toString().trim());
            String toType = arguments.get(1).toString().trim();
            if (toType.regionMatches(true, 0, "SQL_", 0, 4)) {
                toType = toType.substring(4);
            }
            if (!this.casts.containsKey(toType.toUpperCase())) {
                throw new ParseException("Unsupported conversion type");
            }
            builder.append(" as ");
            builder.append(this.casts.get(toType.toUpperCase()));
            return builder.append(')').toString();
        }
    };


    public String invoke(List<String> arguments) throws ParseException {
        return null;
    }

    public static final StringBuilder getNumericFunctions() {
        return new StringBuilder().append((Object)ABS).append(", ").append((Object)ACOS).append(", ").append((Object)ASIN).append(", ").append((Object)ATAN).append(", ").append((Object)ATAN2).append(", ").append((Object)CEILING).append(", ").append((Object)COS).append(", ").append((Object)COT).append(", ").append((Object)DEGREES).append(", ").append((Object)EXP).append(", ").append((Object)FLOOR).append(", ").append((Object)LOG).append(", ").append((Object)LOG10).append(", ").append((Object)MOD).append(", ").append((Object)PI).append(", ").append((Object)POWER).append(", ").append((Object)RADIANS).append(", ").append((Object)RAND).append(", ").append((Object)ROUND).append(", ").append((Object)SIGN).append(", ").append((Object)SIN).append(", ").append((Object)SQRT).append(", ").append((Object)TAN).append(", ").append((Object)TRUNCATE);
    }

    public static final StringBuilder getStringFunctions() {
        return new StringBuilder().append((Object)CONCAT).append(", ").append((Object)LCASE).append(", ").append((Object)LENGTH).append(", ").append((Object)LOCATE).append(", ").append((Object)LTRIM).append(", ").append((Object)RTRIM).append(", ").append((Object)SUBSTRING).append(", ").append((Object)UCASE);
    }

    public static final StringBuilder getDateNTimeFunctions() {
        return new StringBuilder().append((Object)CURDATE).append(", ").append((Object)NOW);
    }

    public static final StringBuilder getSystemFunctions() {
        return new StringBuilder().append((Object)DATABASE);
    }

    public static final StringBuilder getConversionFunctions() {
        return new StringBuilder().append((Object)CONVERT);
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

