/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptExecutor {
    private static final Logger logger = LogManager.getLogger(ScriptExecutor.class);
    private static final String BASE_DIR = System.getProperty("user.dir");

    public static void executeBatchScript(String script) {
        try {
            String line;
            logger.info(" =============== Executing Batch Script =============== ");
            String command = "cmd /c call " + script;
            logger.info("cmd: " + command);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                logger.info(line);
            }
            reader.close();
            logger.info(" =============== Script Execution Completed =============== ");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public static void restartSaws() {
        logger.info(" saws restart in progress ............ ");
        ScriptExecutor.startSAWS();
    }

    public static void restartPandas() {
        logger.info(" Pandas restart in progress ............ ");
        ScriptExecutor.startPandas();
    }

    public static void stopSaws() {
        logger.info(" stopping saws............ ");
        ScriptExecutor.executeCMD(ScriptExecutor.getBtachExecCMD("saws_service_stop.bat"));
        logger.info(" saws stopped ............ ");
    }

    public static void startSAWS() {
        logger.info(" starting  saws............ ");
        try {
            String line;
            String command = "";
            String os = System.getProperty("os.name").toLowerCase();
            command = os.contains("win") ? ScriptExecutor.getBtachExecCMD("dvsum_gateway_setup.bat restart") : "bash dvsum_gateway_setup.sh restart";
            logger.info(command);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info(line);
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        logger.info(" saws started ............ ");
    }

    public static void startPandas() {
        try {
            String line;
            String command = ScriptExecutor.getBtachExecCMD("pandas_service_start.bat");
            logger.info(command);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info(line);
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        logger.info(" Pandas started ............ ");
    }

    public static void executeCMD(String cmd) {
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            int exitVal = proc.waitFor();
            logger.info("Exit value: " + exitVal);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error", (Throwable)e);
        }
    }

    public static String getBtachExecCMD(String batchScript) {
        String cmd = "cmd /c call  \"" + BASE_DIR + "\\" + batchScript + "\"";
        return cmd;
    }
}

