/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.starter;

import com.dvsum.starter.Constants;
import com.dvsum.starter.HttpsRequestor;
import com.dvsum.util.FileUtil;
import com.dvsum.util.ScriptExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SAWSStarter
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SAWSStarter.class);
    private static ScheduledExecutorService scheduler = null;
    private static int sawsNotRespondingCount = 0;
    private static int pythonServiceNotRespondingCount = 0;
    private static boolean sawsEverConnected = false;
    private static boolean pythonServiceEverConnected = false;
    private static final int MAX_NOT_RESPONDING_COUNT = 10;

    public static void main(String[] args) {
        logger.info("Starting monitor.........");
        SAWSStarter.executeScheduledTask();
    }

    public static void executeScheduledTask() {
        scheduler = Executors.newSingleThreadScheduledExecutor();
        SAWSStarter task = new SAWSStarter();
        scheduler.scheduleAtFixedRate(task, Constants.INITIAL_DELAY.intValue(), Constants.PERIODIC_INTERVAL.intValue(), TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        this.spinUpSAWSIfDown();
    }

    private void spinUpSAWSIfDown() {
        boolean isSawsUp = HttpsRequestor.isSAWSUAndRunning();
        if (isSawsUp) {
            SAWSStarter.resetSawsNotRespondingCount();
            sawsEverConnected = true;
            logger.info("SAWS is up and running.");
        } else {
            SAWSStarter.incrementSawsNotRespondingCount();
            logger.warn("SAWS is not responding. Count: " + sawsNotRespondingCount);
        }
        if (!isSawsUp && sawsEverConnected && this.sawsIsNotUnderMaintenance() && SAWSStarter.sawsNotRespondingSinceLastFiveMinutes()) {
            logger.warn("SAWS has been down for 5 minutes. Attempting to restart.");
            SAWSStarter.resetSawsNotRespondingCount();
            ScriptExecutor.restartSaws();
        }
    }

    private boolean sawsIsNotUnderMaintenance() {
        return !FileUtil.isSawsUnderMaintenance();
    }

    public static boolean sawsNotRespondingSinceLastFiveMinutes() {
        return sawsNotRespondingCount >= 10;
    }

    private static synchronized void incrementSawsNotRespondingCount() {
        ++sawsNotRespondingCount;
    }

    private static synchronized void resetSawsNotRespondingCount() {
        sawsNotRespondingCount = 0;
    }

    public static boolean pythonServiceNotRespondingSinceLastFiveMinutes() {
        return pythonServiceNotRespondingCount >= 10;
    }

    private static synchronized void resetPythonServiceNotRespondingCount() {
        pythonServiceNotRespondingCount = 0;
    }

    private static synchronized void incrementPythonServiceNotRespondingCount() {
        ++pythonServiceNotRespondingCount;
    }

    public static void stopStarterService(String[] args) {
        logger.info("Stopping Starter Service......");
        scheduler.shutdownNow();
    }
}

