/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.sslcontext;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jsslutils.keystores.KeyStoreLoader;
import org.jsslutils.sslcontext.DefaultSSLContextFactory;
import org.jsslutils.sslcontext.SSLContextFactory;
import org.jsslutils.sslcontext.X509KeyManagerWrapper;
import org.jsslutils.sslcontext.X509TrustManagerWrapper;

public class X509SSLContextFactory
extends DefaultSSLContextFactory {
    private static final Logger LOGGER = Logger.getLogger(X509SSLContextFactory.class.getName());
    public static final String KEYSTORE_FILE_PROP = "org.jsslutils.prop.keyStore";
    public static final String KEYSTORE_TYPE_PROP = "org.jsslutils.prop.keyStoreType";
    public static final String KEYSTORE_PROVIDER_PROP = "org.jsslutils.prop.keyStoreProvider";
    public static final String KEYSTORE_PASSWORD_PROP = "org.jsslutils.prop.keyStorePassword";
    public static final String KEYSTORE_PROVIDER_CLASS_PROP = "org.jsslutils.prop.keyStoreProviderClass";
    public static final String KEYSTORE_PROVIDER_ARGFILE_PROP = "org.jsslutils.prop.keyStoreProviderArgFile";
    public static final String KEYSTORE_PROVIDER_ARGTEXT_PROP = "org.jsslutils.prop.keyStoreProviderArgText";
    public static final String KEY_PASSWORD_PROP = "org.jsslutils.prop.keyPassword";
    public static final String TRUSTSTORE_FILE_PROP = "org.jsslutils.prop.trustStore";
    public static final String TRUSTSTORE_TYPE_PROP = "org.jsslutils.prop.trustStoreType";
    public static final String TRUSTSTORE_PROVIDER_PROP = "org.jsslutils.prop.trustStoreProvider";
    public static final String TRUSTSTORE_PASSWORD_PROP = "org.jsslutils.prop.trustStorePassword";
    public static final String TRUSTSTORE_PROVIDER_CLASS_PROP = "org.jsslutils.prop.trustStoreProviderClass";
    public static final String TRUSTSTORE_PROVIDER_ARGFILE_PROP = "org.jsslutils.prop.trustStoreProviderArgFile";
    public static final String TRUSTSTORE_PROVIDER_ARGTEXT_PROP = "org.jsslutils.prop.trustStoreProviderArgText";
    private KeyStore keyStore;
    private char[] keyPassword;
    private KeyStore trustStore;
    private CallbackHandler keyPasswordCallbackHandler;
    private CallbackHandler keyStorePasswordCallbackHandler;
    private CallbackHandler trustStorePasswordCallbackHandler;
    private X509KeyManagerWrapper keyManagerWrapper;
    private X509TrustManagerWrapper trustManagerWrapper;

    public X509SSLContextFactory() {
        this(null, (char[])null, null);
    }

    public X509SSLContextFactory(KeyStore keyStore, String keyPassword, KeyStore trustStore) {
        this(keyStore, keyPassword != null ? keyPassword.toCharArray() : null, trustStore);
    }

    public X509SSLContextFactory(KeyStore keyStore, char[] keyPassword, KeyStore trustStore) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.setKeyPassword(keyPassword);
    }

    public void configure(Properties properties) throws SSLContextFactory.SSLContextFactoryException {
        super.configure(properties);
        try {
            KeyStoreLoader ksl;
            if (this.getKeyStore() == null) {
                ksl = new KeyStoreLoader();
                ksl.setKeyStorePath(properties.getProperty(KEYSTORE_FILE_PROP));
                ksl.setKeyStoreType(properties.getProperty(KEYSTORE_TYPE_PROP));
                ksl.setKeyStoreProvider(properties.getProperty(KEYSTORE_PROVIDER_PROP));
                ksl.setKeyStorePassword(properties.getProperty(KEYSTORE_PASSWORD_PROP));
                ksl.setKeyStorePasswordCallbackHandler(this.keyStorePasswordCallbackHandler);
                ksl.setKeyStoreProviderClass(properties.getProperty(KEYSTORE_PROVIDER_CLASS_PROP));
                ksl.setKeyStoreProviderArgFile(properties.getProperty(KEYSTORE_PROVIDER_ARGFILE_PROP));
                ksl.setKeyStoreProviderArgText(properties.getProperty(KEYSTORE_PROVIDER_ARGTEXT_PROP));
                this.keyStore = ksl.loadKeyStore();
            }
            if (this.getTrustStore() == null) {
                ksl = new KeyStoreLoader();
                ksl.setKeyStorePath(properties.getProperty(TRUSTSTORE_FILE_PROP));
                ksl.setKeyStoreType(properties.getProperty(TRUSTSTORE_TYPE_PROP));
                ksl.setKeyStoreProvider(properties.getProperty(TRUSTSTORE_PROVIDER_PROP));
                ksl.setKeyStorePassword(properties.getProperty(TRUSTSTORE_PASSWORD_PROP));
                ksl.setKeyStorePasswordCallbackHandler(this.trustStorePasswordCallbackHandler);
                ksl.setKeyStoreProviderClass(properties.getProperty(TRUSTSTORE_PROVIDER_CLASS_PROP));
                ksl.setKeyStoreProviderArgFile(properties.getProperty(TRUSTSTORE_PROVIDER_ARGFILE_PROP));
                ksl.setKeyStoreProviderArgText(properties.getProperty(TRUSTSTORE_PROVIDER_ARGTEXT_PROP));
                this.trustStore = ksl.loadKeyStore();
            }
        }
        catch (KeyStoreException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (CertificateException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (IOException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    protected KeyStore getKeyStore() {
        return this.keyStore;
    }

    protected KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setKeyPassword(char[] keyPassword) {
        if (keyPassword != null) {
            this.keyPassword = new char[keyPassword.length];
            System.arraycopy(keyPassword, 0, this.keyPassword, 0, keyPassword.length);
        } else if (this.keyPassword != null) {
            Arrays.fill(this.keyPassword, ' ');
        }
    }

    public void setKeyPasswordCallbackHandler(CallbackHandler keyPasswordCallbackHandler) {
        this.keyPasswordCallbackHandler = keyPasswordCallbackHandler;
    }

    public void setKeyStorePasswordCallbackHandler(CallbackHandler keyStorePasswordCallbackHandler) {
        this.keyStorePasswordCallbackHandler = keyStorePasswordCallbackHandler;
    }

    public void setTrustStorePasswordCallbackHandler(CallbackHandler trustStorePasswordCallbackHandler) {
        this.trustStorePasswordCallbackHandler = trustStorePasswordCallbackHandler;
    }

    protected KeyManager[] getRawKeyManagers() throws SSLContextFactory.SSLContextFactoryException {
        if (this.keyStore != null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                if (this.keyPassword != null || this.keyPasswordCallbackHandler == null) {
                    kmf.init(this.keyStore, this.keyPassword);
                } else {
                    PasswordCallback passwordCallback = new PasswordCallback("Key password? ", false);
                    this.keyPasswordCallbackHandler.handle(new Callback[]{passwordCallback});
                    char[] password = passwordCallback.getPassword();
                    kmf.init(this.keyStore, password);
                    if (password != null) {
                        Arrays.fill(password, ' ');
                    }
                }
                return kmf.getKeyManagers();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
            catch (KeyStoreException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
            catch (IOException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
            catch (UnsupportedCallbackException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
        }
        return null;
    }

    public void setKeyManagerWrapper(X509KeyManagerWrapper keyManagerWrapper) {
        this.keyManagerWrapper = keyManagerWrapper;
    }

    public KeyManager[] getKeyManagers() throws SSLContextFactory.SSLContextFactoryException {
        KeyManager[] keyManagers = this.getRawKeyManagers();
        X509KeyManagerWrapper wrapper = this.keyManagerWrapper;
        if (wrapper != null && keyManagers != null) {
            try {
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = wrapper.wrapKeyManager((X509KeyManager)keyManagers[i]);
                }
            }
            catch (SecurityException e) {
                LOGGER.log(Level.WARNING, "Error when instantiating the wrapping trust manager. Falling back to unwrapped manager.", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Error when instantiating the wrapping trust manager. Falling back to unwrapped manager.", e);
            }
        }
        return keyManagers;
    }

    protected TrustManager[] getRawTrustManagers() throws SSLContextFactory.SSLContextFactoryException {
        if (this.trustStore != null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(this.trustStore);
                return tmf.getTrustManagers();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
            catch (KeyStoreException e) {
                throw new SSLContextFactory.SSLContextFactoryException(e);
            }
        }
        return null;
    }

    public void setTrustManagerWrapper(X509TrustManagerWrapper trustManagerWrapper) {
        this.trustManagerWrapper = trustManagerWrapper;
    }

    public TrustManager[] getTrustManagers() throws SSLContextFactory.SSLContextFactoryException {
        TrustManager[] trustManagers = this.getRawTrustManagers();
        X509TrustManagerWrapper wrapper = this.trustManagerWrapper;
        if (wrapper != null && trustManagers != null) {
            try {
                for (int i = 0; i < trustManagers.length; ++i) {
                    if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                    trustManagers[i] = wrapper.wrapTrustManager((X509TrustManager)trustManagers[i]);
                }
            }
            catch (SecurityException e) {
                LOGGER.log(Level.WARNING, "Error when instantiating the wrapping trust manager. Falling back to unwrapped manager.", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Error when instantiating the wrapping trust manager. Falling back to unwrapped manager.", e);
            }
        }
        return trustManagers;
    }
}

