/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet.parser;

import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pcal.sqlsheet.parser.CreateTableStatement;
import net.pcal.sqlsheet.parser.InsertIntoStatement;
import net.pcal.sqlsheet.parser.JdbcParameter;
import net.pcal.sqlsheet.parser.ParsedStatement;
import net.pcal.sqlsheet.parser.SelectStarStatement;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;

public class SqlSheetParser {
    private CCJSqlParserManager parser;

    public ParsedStatement parse(String sql) throws SQLException {
        Statement statement;
        if (this.parser == null) {
            this.parser = new CCJSqlParserManager();
        }
        try {
            statement = this.parser.parse((Reader)new StringReader(sql));
        }
        catch (Exception e) {
            SQLException sq = new SQLException(e.getMessage());
            sq.initCause(e);
            throw sq;
        }
        if (statement instanceof Select) {
            SelectBody body = ((Select)statement).getSelectBody();
            if (!(body instanceof PlainSelect)) {
                throw new SQLException("ORDER BY and UNION not supported on Excel sheets.");
            }
            final FromItem from = ((PlainSelect)body).getFromItem();
            if (!(from instanceof Table)) {
                throw new SQLException("Subselects not supported on Excel sheets.");
            }
            if (((PlainSelect)body).getDistinct() != null) {
                throw new SQLException("DISTINCT not supported on Excel sheets.");
            }
            if (((PlainSelect)body).getInto() != null) {
                throw new SQLException("SELECT INTO not supported on Excel sheets.");
            }
            if (((PlainSelect)body).getHaving() != null) {
                throw new SQLException("HAVING not supported on Excel sheets.");
            }
            if (((PlainSelect)body).getGroupByColumnReferences() != null) {
                throw new SQLException("GROUP BY not supported on Excel sheets.");
            }
            List selectItems = ((PlainSelect)body).getSelectItems();
            if (selectItems == null || selectItems.isEmpty() || selectItems.size() > 1 || !(selectItems.get(0) instanceof AllColumns)) {
                throw new SQLException("Only 'SELECT *' is supported on Excel sheets");
            }
            return new SelectStarStatement(){

                public String getTable() {
                    return ((Table)from).getName();
                }
            };
        }
        if (statement instanceof CreateTable) {
            final String table = ((CreateTable)statement).getTable().getName();
            List cols = ((CreateTable)statement).getColumnDefinitions();
            final ArrayList<String> names = new ArrayList<String>();
            final ArrayList<String> types = new ArrayList<String>();
            for (ColumnDefinition cd : cols) {
                names.add(SqlSheetParser.stripUnderscores(cd.getColumnName()));
                types.add(cd.getColDataType().getDataType());
            }
            return new CreateTableStatement(){

                @Override
                public String getTable() {
                    return table;
                }

                @Override
                public List<String> getColumns() {
                    return names;
                }

                @Override
                public List<String> getTypes() {
                    return types;
                }
            };
        }
        if (statement instanceof Insert) {
            final String table = ((Insert)statement).getTable().getName();
            List cols = ((Insert)statement).getColumns();
            final ArrayList<String> names = new ArrayList<String>();
            final ArrayList<Object> values = new ArrayList<Object>();
            for (Column cd : cols) {
                names.add(SqlSheetParser.stripUnderscores(cd.getColumnName()));
            }
            ItemsList ilist = ((Insert)statement).getItemsList();
            if (!(ilist instanceof ExpressionList)) {
                throw new SQLException("INSERT from subselect not supported with excel sheets");
            }
            List exps = ((ExpressionList)ilist).getExpressions();
            for (Expression exp : exps) {
                if (exp instanceof StringValue) {
                    values.add(((StringValue)exp).getValue());
                    continue;
                }
                if (exp instanceof DateValue) {
                    values.add(((DateValue)exp).getValue());
                    continue;
                }
                if (exp instanceof TimestampValue) {
                    values.add(((TimestampValue)exp).getValue());
                    continue;
                }
                if (exp instanceof TimeValue) {
                    values.add(((TimeValue)exp).getValue());
                    continue;
                }
                if (exp instanceof DoubleValue) {
                    values.add(((DoubleValue)exp).getValue());
                    continue;
                }
                if (exp instanceof LongValue) {
                    values.add(((LongValue)exp).getValue());
                    continue;
                }
                if (exp instanceof NullValue) {
                    values.add(null);
                    continue;
                }
                if (exp instanceof net.sf.jsqlparser.expression.JdbcParameter) {
                    values.add(JdbcParameter.INSTANCE);
                    continue;
                }
                throw new SQLException("Cannot handle expression of class " + exp.getClass().getName() + ", value = " + exp.toString());
            }
            return new InsertIntoStatement(){

                @Override
                public String getTable() {
                    return table;
                }

                @Override
                public List<String> getColumns() {
                    return names;
                }

                @Override
                public List<Object> getValues() {
                    return values;
                }
            };
        }
        throw new SQLException("Could not process " + sql + " (" + statement.getClass().getName() + ")");
    }

    private static String stripUnderscores(String columnName) {
        return columnName.replace('_', ' ');
    }
}

