/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import net.pcal.sqlsheet.XlsResultSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsResultSetMetaData
implements ResultSetMetaData {
    private String[] columnNames;
    private final DataFormatter formatter;
    private XlsResultSet resultset;

    public XlsResultSetMetaData(Sheet sheet, XlsResultSet resultset) throws SQLException {
        if (sheet == null) {
            throw new IllegalArgumentException();
        }
        this.resultset = resultset;
        Row row = sheet.getRow(0);
        if (row == null) {
            throw new SQLException("No header row in sheet");
        }
        this.formatter = new DataFormatter();
        this.columnNames = new String[row.getLastCellNum()];
        for (int c = 0; c < this.columnNames.length; c = (int)((short)(c + 1))) {
            Cell cell = row.getCell(c);
            this.columnNames[c] = this.formatter.formatCellValue(cell);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnLabel(int jdbcCol) {
        return this.columnNames[jdbcCol - 1];
    }

    @Override
    public String getColumnName(int jdbcCol) {
        return this.columnNames[jdbcCol - 1];
    }

    @Override
    public String getCatalogName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int jdbcColumn) throws SQLException {
        return this.resultset.getNextRowObject(jdbcColumn).getClass().getName();
    }

    @Override
    public int getColumnDisplaySize(int arg0) {
        return 0;
    }

    @Override
    public int getColumnType(int jdbcColumn) throws SQLException {
        if (this.resultset.getNextRowObject(jdbcColumn).getClass().isAssignableFrom(String.class)) {
            return 12;
        }
        if (this.resultset.getNextRowObject(jdbcColumn).getClass().isAssignableFrom(Double.class)) {
            return 8;
        }
        if (this.resultset.getNextRowObject(jdbcColumn).getClass().isAssignableFrom(Date.class)) {
            return 91;
        }
        return 1111;
    }

    @Override
    public String getColumnTypeName(int jdbcColumn) throws SQLException {
        return this.resultset.getNextRowObject(jdbcColumn).getClass().getName();
    }

    @Override
    public int getPrecision(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isAutoIncrement(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

